/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.session;

import com.arm.streamline.analysis.AnalysisBase;
import com.arm.streamline.analysis.AnalysisMessages;
import com.arm.streamline.analysis.database.DatabaseUtils;
import com.arm.streamline.analysis.database.ProcessingElementReferenceSetReaderWriter;
import com.arm.streamline.analysis.database.api.IAnalysisReaderFactoryV2;
import com.arm.streamline.analysis.database.api.activity.IAnalysisActivityReader;
import com.arm.streamline.analysis.database.api.annotations.IAnalysisAnnotationsReader;
import com.arm.streamline.analysis.database.api.counters.IAnalysisHardwareCounterReader;
import com.arm.streamline.analysis.database.stream.factory.AnalysisDatabaseFactory;
import com.arm.streamline.analysis.database.stream.factory.DatabaseLayout;
import com.arm.streamline.analysis.elfdwarf.ElfDwarf;
import com.arm.streamline.analysis.gator.ICaptureDetails;
import com.arm.streamline.analysis.live.LiveGator;
import com.arm.streamline.analysis.model.AnalysisModel;
import com.arm.streamline.analysis.model.CounterMap;
import com.arm.streamline.analysis.model.DBProperties;
import com.arm.streamline.analysis.model.DeviceTypeCalculator;
import com.arm.streamline.analysis.model.IMonotonicRawToVmTimestamp;
import com.arm.streamline.analysis.model.ImageRecordName;
import com.arm.streamline.analysis.model.KernelSymbol;
import com.arm.streamline.analysis.model.ProfilerKernelModule;
import com.arm.streamline.analysis.model.VirtualMachineProperties;
import com.arm.streamline.analysis.processor.AnalysisReportWriter;
import com.arm.streamline.analysis.processor.annotate.Annotate;
import com.arm.streamline.analysis.processor.annotate.AnnotateMarker;
import com.arm.streamline.analysis.processor.profile.Profile;
import com.arm.streamline.analysis.processor.profile.ProfileV3;
import com.arm.streamline.analysis.processor.timeline.CAMJobWriter;
import com.arm.streamline.analysis.processor.timeline.Counters;
import com.arm.streamline.analysis.processor.timeline.ThreadsActivity;
import com.arm.streamline.analysis.processor.timeline.ThreadsWait;
import com.arm.streamline.analysis.session.IDatabaseGenerator;
import com.arm.streamline.analysis.session.IFinalWriter;
import com.arm.streamline.analysis.session.ImageTransfer;
import com.arm.streamline.analysis.session.SessionSettings;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.analysis.IAnalysisHandler;
import com.arm.streamline.common.model.chart.SeriesAliasUtils;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.common.model.warnings.IWarnings;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.common.model.warnings.WarningSeverity;
import com.arm.streamline.common.model.warnings.WarningType;
import com.arm.streamline.common.model.warnings.Warnings;
import com.arm.streamline.common.report.model.ResolutionMode;
import com.arm.streamline.common.utility.ClusterNameUtils;
import com.arm.streamline.databrowser.ICapture;
import com.arm.streamline.databrowser.ICaptureProxy;
import com.arm.streamline.databrowser.IOpenable;
import com.arm.streamline.databrowser.IProgressObserver;
import com.arm.streamline.databrowser.IStopHandler;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import com.arm.streamline.model.session.SampleRate;
import com.arm.streamline.protocol.misc.AttachedApkEntries;
import com.arm.streamline.report.api.write.IReportWriterFactory;
import com.arm.streamline.report.model.VariableReplacer;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.streamline.utility.io.StreamlineFileUtils;
import com.arm.utils.NullChecking;
import com.arm.utils.function.Throwing;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.function.LongPredicate;
import java.util.function.LongUnaryOperator;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SessionProcessor
implements IStopHandler,
IAnalysisHandler {
    public static final String APC_WARNINGS_DIR = "/db";
    protected CountDownLatch mCaptureInProgress = null;
    protected boolean mDiscard;
    protected boolean mDone;
    protected ElfDwarf mElfDwarf;
    protected Throwable mErrorException;
    protected ImageTransfer mImageTransfer;
    protected LiveGator mLive;
    protected Thread mMainThread = null;
    protected @Nullable ICaptureProxy mProxy;
    protected boolean mStopRequested;
    private IAnalysisReaderFactoryV2 dbAnalysisReaderFactory;
    private final Set<String> dwarfWarnings = new HashSet<String>();
    private @Nullable ICapture mAnalysisDocument;
    private @Nullable AnalysisModel mAnalysisModel;
    private Annotate mAnnotate;
    private AnnotateMarker mAnnotateMarker;
    private CAMJobWriter mCAM;
    private Counters mCounters;
    private final Object mErrorMutex = new Object();
    private @Nullable Profile mProfile;
    private @Nullable ProfileV3 mProfileV3;
    private int mProgress = -1;
    private final TObjectIntHashMap<Object> mProgressMap = new TObjectIntHashMap();
    private boolean mShowProcesses = true;
    private ThreadsActivity mThreadsActivity;
    private AnalysisBase mThreadsWait;
    private IUniqueIds mUniqueIds;
    private final @NonNull IWarnings mWarnings = new Warnings();
    private @Nullable IDatabaseGenerator mDatabaseGenerator = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkIsNonZero(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAnalysisReaderFactoryV2.IAnalysisReaderActivityStream stream) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (IAnalysisActivityReader reader = stream.createReader();){
                IAnalysisActivityReader.IValue value = (IAnalysisActivityReader.IValue)reader.read();
                if (value != null) {
                }
                return false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException exception) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkIsNonZero(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAnalysisReaderFactoryV2.IAnalysisReaderHardwareCounterStream stream) {
        int channelCount = stream.getChannelCount();
        if (channelCount == 0) {
            return true;
        }
        @NonNull CounterRecord counterRecord = stream.getCounterRecord();
        if (!SessionProcessor.isMaliCounterThatMayBeZero(counterRecord) && !SessionProcessor.isHWCounterThatMayBeZero(counterRecord)) {
            return true;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (IAnalysisHardwareCounterReader reader = stream.createReader();){
                IAnalysisHardwareCounterReader.Value value = (IAnalysisHardwareCounterReader.Value)reader.read();
                if (value != null) {
                }
                return false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private static long getDurationLimitInNanoSecs(int durationLimitInSecs, DBProperties timeReader) throws Exception {
        long sessionDurationInNanosecs = 0L;
        long timeReaderDurationInNanosecs = 0L;
        try {
            sessionDurationInNanosecs = (long)durationLimitInSecs * 1000000000L;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            timeReaderDurationInNanosecs = timeReader.getDurationInNanosecs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sessionDurationInNanosecs > 0L && sessionDurationInNanosecs < timeReaderDurationInNanosecs) {
            return sessionDurationInNanosecs;
        }
        if (timeReaderDurationInNanosecs > 0L) {
            return timeReaderDurationInNanosecs;
        }
        throw new Exception(AnalysisMessages.ZERO_DURATION);
    }

    private static boolean isHWCounterThatMayBeZero(@NonNull CounterRecord counter) {
        if (counter.isDerived() || counter.isMetric()) {
            return false;
        }
        String name = counter.getCounter();
        if (name.endsWith("_softirq") || name.endsWith("_irq") || name.endsWith("_switch") || name.endsWith("_freq") || name.endsWith("_system") || name.endsWith("_user") || name.endsWith("_ccnt")) {
            return false;
        }
        if (ClusterNameUtils.getArchName((String)counter.getCounter()) == null) {
            return false;
        }
        @NonNull String alias = counter.getAlias(false);
        return !"ClockCycles".equals(alias);
    }

    private static boolean isMaliCounterThatMayBeZero(@NonNull CounterRecord counter) {
        String name = counter.getCounter();
        return name.startsWith("ARM_Mali-4") || name.startsWith("ARM_Mali-T") || name.startsWith("ARM_Mali-G") || counter.getDeviceTypeOrDefault().isGPU();
    }

    public void cancel() {
        if (this.mMainThread != null) {
            this.mMainThread.interrupt();
        }
        if (this.mElfDwarf != null) {
            this.mElfDwarf.interrupt();
        }
        if (this.mAnalysisModel != null) {
            this.mAnalysisModel.interrupt();
        }
        if (this.mAnnotate != null) {
            this.mAnnotate.interrupt();
        }
        if (this.mCounters != null) {
            this.mCounters.interrupt();
        }
        if (this.mProfile != null) {
            this.mProfile.interrupt();
        }
        if (this.mProfileV3 != null) {
            this.mProfileV3.interrupt();
        }
        if (this.mThreadsActivity != null) {
            this.mThreadsActivity.interrupt();
        }
        if (this.mThreadsWait != null) {
            this.mThreadsWait.interrupt();
        }
        if (this.mCAM != null) {
            this.mCAM.interrupt();
        }
        if (this.mImageTransfer != null) {
            this.mImageTransfer.interrupt();
        }
    }

    public void captureStopped() {
        this.mCaptureInProgress.countDown();
    }

    @Override
    public void discard() {
        this.mDiscard = true;
        this.cancel();
    }

    public void dwarfWarning(@NonNull String message) {
        if (!this.dwarfWarnings.contains(message)) {
            this.dwarfWarnings.add(message);
            this.warning(new WarningItem(WarningType.ELF_DWARF, WarningSeverity.MEDIUM, AnalysisMessages.ELF_DWARF_WARNING, message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(Throwable ex) {
        Object object = this.mErrorMutex;
        synchronized (object) {
            if (this.mErrorException == null) {
                this.mErrorException = ex;
            }
        }
        this.cancel();
    }

    public LiveGator getLive() {
        return this.mLive;
    }

    public boolean getShowProcesses() {
        return this.mShowProcesses;
    }

    public IUniqueIds getUniqueIds() {
        return this.mUniqueIds;
    }

    public boolean hasValidCapture() {
        return !this.mDiscard && this.mErrorException == null;
    }

    @Override
    public boolean isCapturing() {
        return !this.mStopRequested;
    }

    public boolean isDiscard() {
        return this.mDiscard;
    }

    public boolean isDone() {
        return this.mDone;
    }

    @Override
    public boolean isStoppable() {
        return true;
    }

    /*
     * Exception decompiling
     */
    public void produceReport(@NonNull IAnalysisInputSettings analysisSettings, @NonNull String capturePath, @NonNull String outputPath, boolean is64Bit, @NonNull IWarnings captureWarnings, @NonNull IClustersInfo clustersInfo, @NonNull ICaptureDetails captureDetails, @NonNull IFinalWriter finalWriter, IDatabaseGenerator dbGenerator, int durationLimitInSecs, @Nullable TargetAddressString targetAddressStr, @Nullable SampleRate sampleRate, @NonNull ICapture capture, @Nullable IOpenable openable, @NonNull IProgressObserver progressObserver, boolean openResult, @Nullable ResolutionMode previousResolutionMode) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progress(Object obj, int progress) {
        if (progress > 100) {
            progress = 100;
        }
        TObjectIntHashMap<Object> tObjectIntHashMap = this.mProgressMap;
        synchronized (tObjectIntHashMap) {
            this.mProgressMap.put(obj, progress);
            int theProgress = 100;
            TObjectIntIterator itr = this.mProgressMap.iterator();
            while (itr.hasNext()) {
                itr.advance();
                int value = itr.value();
                if (value >= theProgress) continue;
                theProgress = value;
            }
            if (theProgress > this.mProgress) {
                this.mProgress = theProgress;
                if (this.mAnalysisDocument != null) {
                    this.mAnalysisDocument.setProgress(theProgress);
                }
            }
        }
    }

    public void setCaptureProxy(@NonNull ICaptureProxy proxy) {
        this.mProxy = proxy;
    }

    public void setShowProcesses(boolean showProcesses) {
        this.mShowProcesses = showProcesses;
    }

    public void setUniqueIds(IUniqueIds uid) {
        this.mUniqueIds = uid;
    }

    @Override
    public void stop() {
        if (this.mProxy != null) {
            this.mProxy.stopLiveRequestSend();
        }
        if (this.mDatabaseGenerator != null) {
            this.mDatabaseGenerator.stop();
            this.mDatabaseGenerator = null;
        }
        this.discard();
    }

    public void waitUntilCaptureStops() {
        if (this.mCaptureInProgress != null) {
            try {
                this.mCaptureInProgress.await();
            }
            catch (InterruptedException exception) {
                this.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warning(WarningItem warningItem) {
        IWarnings iWarnings = this.mWarnings;
        synchronized (iWarnings) {
            if (this.mWarnings.size() < 100) {
                this.mWarnings.add(warningItem);
            }
        }
    }

    protected void checkError() throws Throwable {
        if (this.mErrorException instanceof NullPointerException) {
            CommonPlugin.error((Throwable)this.mErrorException);
            throw this.mErrorException;
        }
        if (this.mErrorException != null || this.mDiscard && this.mStopRequested) {
            throw new InterruptedException();
        }
    }

    protected void close() throws IOException {
        try {
            if (this.mElfDwarf != null) {
                this.mElfDwarf.close();
                this.mElfDwarf = null;
            }
            if (this.mAnnotate != null) {
                this.mAnnotate.close();
                this.mAnnotate = null;
            }
            if (this.mAnnotateMarker != null) {
                this.mAnnotateMarker.close();
                this.mAnnotateMarker = null;
            }
            if (this.mCounters != null) {
                this.mCounters.close();
                this.mCounters = null;
            }
            if (this.mProfile != null) {
                this.mProfile.close();
                this.mProfile = null;
            }
            if (this.mProfileV3 != null) {
                this.mProfileV3.close();
                this.mProfileV3 = null;
            }
            if (this.mThreadsActivity != null) {
                this.mThreadsActivity.close();
                this.mThreadsActivity = null;
            }
            if (this.mThreadsWait != null) {
                this.mThreadsWait.close();
                this.mThreadsWait = null;
            }
            if (this.mAnalysisModel != null) {
                this.mAnalysisModel.close();
                this.mAnalysisModel = null;
            }
            if (this.mCAM != null) {
                this.mCAM.close();
                this.mCAM = null;
            }
            if (this.mImageTransfer != null) {
                this.mImageTransfer.close();
            }
            if (this.mDatabaseGenerator != null) {
                this.mDatabaseGenerator = null;
            }
        }
        finally {
            if (this.dbAnalysisReaderFactory != null) {
                this.dbAnalysisReaderFactory.close();
                this.dbAnalysisReaderFactory = null;
            }
        }
    }

    protected synchronized void join() {
        if (this.mElfDwarf != null) {
            this.mElfDwarf.join();
        }
        if (this.mAnalysisModel != null) {
            this.mAnalysisModel.join();
        }
        if (this.mAnnotate != null) {
            this.mAnnotate.join();
        }
        if (this.mCounters != null) {
            this.mCounters.join();
        }
        if (this.mProfile != null) {
            this.mProfile.join();
        }
        if (this.mProfileV3 != null) {
            this.mProfileV3.join();
        }
        if (this.mThreadsActivity != null) {
            this.mThreadsActivity.join();
        }
        if (this.mThreadsWait != null) {
            this.mThreadsWait.join();
        }
        if (this.mCAM != null) {
            this.mCAM.join();
        }
        if (this.mImageTransfer != null) {
            this.mImageTransfer.join();
        }
    }

    protected void waitLive() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeAPCWarningsXMLFile(String capturePath) {
        IWarnings iWarnings = this.mWarnings;
        synchronized (iWarnings) {
            if (!this.mWarnings.isEmpty()) {
                this.mWarnings.save(new File(capturePath + APC_WARNINGS_DIR));
                this.mWarnings.clear();
            }
        }
    }

    private void checkHWCountersForZeroes(ICaptureDetails captureDetails, @NonNull Set<@NonNull String> nonZeroCounterAlias) {
        boolean found = false;
        for (CounterRecord counter : captureDetails.getCounterList()) {
            if (!SessionProcessor.isHWCounterThatMayBeZero(counter)) continue;
            @NonNull String alias = counter.getAlias(true);
            if (nonZeroCounterAlias.contains(alias)) {
                return;
            }
            found = true;
        }
        if (found) {
            WarningItem item = new WarningItem(WarningType.COUNTER_CONFIGURATION, WarningSeverity.LOW, AnalysisMessages.PMU_NOT_CONFIGURED_TITLE, AnalysisMessages.PMU_NOT_CONFIGURED_DESCRIPTION);
            this.warning(item);
        }
    }

    private void checkMaliCountersForZeroes(ICaptureDetails captureDetails, @NonNull Set<@NonNull String> nonZeroCounterAlias, @NonNull Set<@NonNull String> nonZeroEventNames) {
        boolean found = false;
        for (CounterRecord counter : captureDetails.getCounterList()) {
            if (!SessionProcessor.isMaliCounterThatMayBeZero(counter)) continue;
            @NonNull String alias = counter.getAlias(false);
            if (counter.getCounterClass() != CounterClass.ACTIVITY && nonZeroCounterAlias.contains(alias) || counter.getCounterClass() == CounterClass.ACTIVITY && nonZeroEventNames.contains(alias)) {
                return;
            }
            found = true;
        }
        if (found) {
            WarningItem item = new WarningItem(WarningType.COUNTER_CONFIGURATION, WarningSeverity.LOW, AnalysisMessages.MALI_NO_PROFILING_TITLE, AnalysisMessages.MALI_NO_PROFILING_DESCRIPTION);
            this.warning(item);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void generateReport(@NonNull SessionSettings settings, @NonNull IAnalysisInputSettings analysisSettings, boolean is64Bit, @NonNull ICaptureDetails captureDetails, @NonNull IFinalWriter finalWriter, @NonNull List<@NonNull ImageRecordName> imageFiles, int durationLimitInSecs, @Nullable TargetAddressString targetAddressStr, @Nullable SampleRate sampleRate, @NonNull AttachedApkEntries attachedApkEntries, boolean useReportV3) throws Throwable {
        IAnalysisReaderFactoryV2 dbAnalysisReaderFactory;
        @NonNull File dbDirectory = DatabaseLayout.getDatabaseRoot((File)new File(settings.getInputPath()));
        @NonNull DeviceTypeCalculator deviceTypeCalculator = captureDetails.createDeviceTypeCalculator();
        this.dbAnalysisReaderFactory = dbAnalysisReaderFactory = AnalysisDatabaseFactory.create((File)dbDirectory, (DeviceTypeCalculator)deviceTypeCalculator);
        @NonNull @NonNull TLongObjectMap kernelSymbols = dbAnalysisReaderFactory.getKernelSymbols();
        this.mUniqueIds = dbAnalysisReaderFactory.getApplications();
        @NonNull CounterMap counters = dbAnalysisReaderFactory.getAllCounters();
        @NonNull ProcessingElementReferenceSet processingElements = dbAnalysisReaderFactory.getProcessingElementsReferenceSet();
        @NonNull IClustersInfo clustersInfo = dbAnalysisReaderFactory.getClustersInfo();
        @NonNull TLongObjectMap vmStateMap = dbAnalysisReaderFactory.getVmStateMap();
        @NonNull DBProperties stateReader = dbAnalysisReaderFactory.getDbProperties();
        @NonNull LongPredicate isAppTracingMode = vm -> {
            VirtualMachineProperties state = (VirtualMachineProperties)vmStateMap.get(vm);
            if (state == null) {
                return stateReader.isApplicationTracingMode();
            }
            return state.isApplicationTracingMode();
        };
        VariableReplacer variableReplacer = new VariableReplacer();
        variableReplacer.createClusterVariables(clustersInfo);
        clustersInfo.updateCounterRecordsWithClusterInformation(captureDetails.getCounterList());
        clustersInfo.writeXML(new File(settings.getOutputPath()));
        variableReplacer.writeXML(VariableReplacer.getOutPutStream((File)new File(settings.getOutputPath())));
        settings.setDurationInNanosecs(SessionProcessor.getDurationLimitInNanoSecs(durationLimitInSecs, stateReader));
        @NonNull IReportWriterFactory reportDataWriter = IReportWriterFactory.create((File)new File(settings.getOutputPath()));
        @NonNull LongUnaryOperator vmExitTimeSupplier = vmUID -> ((VirtualMachineProperties)NullChecking.neverNull((Object)((VirtualMachineProperties)vmStateMap.get(vmUID)))).getVmEndTimestamp();
        @NonNull ArrayList<@NonNull T> sortedCpuList = new ArrayList(processingElements.getList(DeviceType.CPU));
        sortedCpuList.sort(Comparator.naturalOrder());
        @NonNull ToIntFunction<@NonNull ProcessingElementReference> peReferenceToClusterNumber = peReference -> {
            int coreIndex = Collections.binarySearch(sortedCpuList, peReference);
            if (coreIndex < 0) {
                throw new AssertionError();
            }
            return clustersInfo.getClusterIndex(coreIndex);
        };
        this.mCounters = new Counters(settings, arg_0 -> ((CounterMap)counters).getDeviceType(arg_0), vmExitTimeSupplier, this, dbAnalysisReaderFactory, (IUniqueIds)NullChecking.neverNull((Object)this.mUniqueIds), reportDataWriter);
        this.mThreadsActivity = new ThreadsActivity(settings, this, clustersInfo.getNumberOfClusters(), peReferenceToClusterNumber, captureDetails, dbAnalysisReaderFactory);
        this.mThreadsWait = new ThreadsWait(settings, captureDetails, this, dbAnalysisReaderFactory);
        @NonNull IAnalysisAnnotationsReader annotationReader = dbAnalysisReaderFactory.createAnnotationsReader();
        this.mAnnotateMarker = (AnnotateMarker)Throwing.closeIfThrows(() -> new AnnotateMarker(settings.getOutputPath()), (Closeable[])new Closeable[]{annotationReader});
        this.mAnnotate = (Annotate)Throwing.closeIfThrows(() -> new Annotate(settings, this, annotationReader, this.mAnnotateMarker, this.mUniqueIds), (Closeable[])new Closeable[]{annotationReader});
        this.mCAM = new CAMJobWriter(settings, this, dbAnalysisReaderFactory.enumerateCAMDataStreams());
        this.checkError();
        @NonNull Set<@NonNull String> nonZeroCounterAlias = dbAnalysisReaderFactory.enumerateCounterStreams().stream().filter(SessionProcessor::checkIsNonZero).map(IAnalysisReaderFactoryV2.IAnalysisReaderHardwareCounterStream::getCounterRecord).map(cr -> cr.getAlias(true)).collect(Collectors.toSet());
        @NonNull Set<@NonNull String> nonZeroEventAlias = dbAnalysisReaderFactory.enumerateActivityStreams().stream().filter(SessionProcessor::checkIsNonZero).map(IAnalysisReaderFactoryV2.IAnalysisReaderActivityStream::getEventsChart).flatMap(ec -> Arrays.stream(ec.getNames()).map(n -> SeriesAliasUtils.createAlias((String)ec.getTitle(), (String)n))).collect(Collectors.toSet());
        this.checkHWCountersForZeroes(captureDetails, nonZeroCounterAlias);
        this.checkMaliCountersForZeroes(captureDetails, nonZeroCounterAlias, nonZeroEventAlias);
        File outputFile = new File(settings.getOutputPath());
        dbAnalysisReaderFactory.writeApplicationsToReport(outputFile);
        dbAnalysisReaderFactory.writeCoresToReport(outputFile);
        dbAnalysisReaderFactory.writePeReferencesToReport(outputFile);
        dbAnalysisReaderFactory.writeVmsToReport(outputFile);
        ProcessingElementReferenceSetReaderWriter.write((File)new File(settings.getOutputPath(), "pe-references.xml"), (ProcessingElementReferenceSet)processingElements);
        finalWriter.writeXML(settings.getOutputPath());
        this.checkError();
        if (this.mErrorException != null || this.mDiscard) {
            return;
        }
        if (useReportV3) {
            ProfileV3 profileV3;
            if (AnalysisDatabaseFactory.ENABLE_V3_LOGGING) {
                System.out.println("Using V3 reporting backend");
            }
            this.mProfileV3 = profileV3 = new ProfileV3(this, new File(captureDetails.getPath()));
            @NonNull DBProperties dbProperties = DatabaseLayout.readDatabaseProperties((File)dbDirectory);
            AnalysisReportWriter.writeStateXML(settings, targetAddressStr, sampleRate, DatabaseUtils.getName(settings.getInputPath()), captureDetails, is64Bit, stateReader.isApplicationTracingMode(), dbProperties.getDurationInNanosecs());
        } else {
            Profile profile;
            AnalysisModel analysisModel;
            this.mAnalysisModel = analysisModel = new AnalysisModel(analysisSettings, durationLimitInSecs, imageFiles.toArray(new ImageRecordName[imageFiles.size()]), settings.getInputPath(), settings.getOutputPath(), captureDetails, this, ProfilerKernelModule.buildKernelSymbolLookup((TLongObjectMap<List<KernelSymbol>>)kernelSymbols));
            analysisModel.join();
            this.checkError();
            if (this.mErrorException != null || this.mDiscard) {
                return;
            }
            this.mProfile = profile = new Profile(settings, analysisModel, this, captureDetails.getBacktraceProcessing(), dbAnalysisReaderFactory.createCodeProfilingReader(), (TLongObjectMap<? extends IMonotonicRawToVmTimestamp>)vmStateMap, attachedApkEntries, isAppTracingMode);
            this.writeReportWarningsXML(settings.getInputPath(), settings.getOutputPath());
            profile.join();
            AnalysisReportWriter.write(settings, analysisModel, profile, (IUniqueIds)NullChecking.neverNull((Object)this.mUniqueIds), this.mShowProcesses, captureDetails, DatabaseUtils.getName(settings.getInputPath()), is64Bit, targetAddressStr, sampleRate, stateReader.isApplicationTracingMode());
        }
        this.progress(this, 100);
        this.join();
    }

    private void setAnalysisPath(String outputPath, @NonNull ICapture capture, @NonNull IProgressObserver progressObserver) throws IOException {
        File analysisDirectory = new File(outputPath);
        this.mAnalysisDocument = capture;
        this.progress(this, 0);
        progressObserver.pause();
        try {
            StreamlineFileUtils.deleteAsynchronously(analysisDirectory);
        }
        finally {
            progressObserver.resume();
        }
        if (!analysisDirectory.mkdirs()) {
            throw new IOException(MessageFormat.format(AnalysisMessages.FAILED_TO_CREATE_REPORT, analysisDirectory.getCanonicalPath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeReportWarningsXML(String capturePath, String outputPath) {
        IWarnings iWarnings = this.mWarnings;
        synchronized (iWarnings) {
            this.mWarnings.load(new File(capturePath + APC_WARNINGS_DIR));
            if (!this.mWarnings.isEmpty()) {
                this.mWarnings.save(new File(outputPath));
                this.mWarnings.clear();
            }
        }
    }

    private /* synthetic */ void lambda$0(WarningItem w) {
        this.mWarnings.add(w);
    }
}

