/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.timeline;

import com.arm.streamline.analysis.AnalysisBase;
import com.arm.streamline.analysis.AnalysisMessages;
import com.arm.streamline.analysis.database.CAMTrackWriter;
import com.arm.streamline.analysis.database.api.IAnalysisReaderFactoryV2;
import com.arm.streamline.analysis.database.api.cam.IAnalysisCAMReader;
import com.arm.streamline.analysis.database.stream.factory.CAMView;
import com.arm.streamline.analysis.model.CAMXML;
import com.arm.streamline.analysis.processor.timeline.CAMIndexDataFileWriter;
import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.analysis.session.SessionSettings;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.common.model.warnings.WarningSeverity;
import com.arm.streamline.common.model.warnings.WarningType;
import com.arm.streamline.common.utility.io.StreamUtils;
import com.arm.streamline.model.cam.CAM_Model;
import com.arm.utils.NullChecking;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CAMJobWriter
extends AnalysisBase {
    private final @NonNull String mOutputPath;
    private final @NonNull SessionSettings mSettings;
    private final @NonNull Set<? extends // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IAnalysisReaderFactoryV2.IAnalysisCAMDataStream> streams;

    private static int getCookie(@NonNull TObjectIntMap<String> cookieMap, @NonNull DataOutputStream cookieWriter, @Nullable String name) throws IOException {
        int cookie = cookieMap.get((Object)(name = name != null ? name : ""));
        if (cookie == cookieMap.getNoEntryValue()) {
            cookie = cookieMap.size();
            cookieMap.put((Object)name, cookie);
            byte[] bytes = name.getBytes(StandardCharsets.UTF_8);
            cookieWriter.writeInt(cookie);
            cookieWriter.writeInt(bytes.length);
            cookieWriter.write(bytes);
        }
        return cookie;
    }

    public CAMJobWriter(@NonNull SessionSettings settings, @NonNull SessionProcessor sp, @NonNull Set<? extends // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IAnalysisReaderFactoryV2.IAnalysisCAMDataStream> streams) {
        super(sp);
        this.streams = streams;
        this.mSettings = settings;
        this.progress(0);
        this.mOutputPath = settings.getOutputPath();
        this.setName("CAM", settings.getInputPath(), settings.getOutputPath());
        this.setPriorityLower();
        this.start();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void process() {
        try {
            IAnalysisReaderFactoryV2.IAnalysisCAMDataStream iAnalysisCAMDataStream;
            int viewUID;
            TIntObjectMap streamsByView;
            IAnalysisReaderFactoryV2.IAnalysisCAMDataStream prev;
            @NonNull TLongObjectHashMap streams = new TLongObjectHashMap();
            Iterator<? extends IAnalysisReaderFactoryV2.IAnalysisCAMDataStream> iterator = this.streams.iterator();
            do {
                if (!iterator.hasNext()) {
                    Throwable throwable = null;
                    iterator = null;
                    try (CAMXML.CAMXmlWriter camXmlWriter = new CAMXML.CAMXmlWriter(new File(this.mOutputPath));){
                        TLongObjectIterator vmIt = streams.iterator();
                        block22: while (true) {
                            if (!vmIt.hasNext()) {
                                return;
                            }
                            vmIt.advance();
                            long vmUID = vmIt.key();
                            @NonNull TIntObjectMap viewsMap = (TIntObjectMap)NullChecking.neverNull((Object)((TIntObjectMap)vmIt.value()));
                            TIntObjectIterator viewIt = viewsMap.iterator();
                            while (true) {
                                File baseViewPath;
                                String nonNullName;
                                CAMView camView;
                                int viewUID2;
                                block42: {
                                    Object item;
                                    if (!viewIt.hasNext()) continue block22;
                                    viewIt.advance();
                                    viewUID2 = viewIt.key();
                                    // Could not load outer class - annotation placement on inner may be incorrect
                                     @NonNull IAnalysisReaderFactoryV2.IAnalysisCAMDataStream stream = (IAnalysisReaderFactoryV2.IAnalysisCAMDataStream)NullChecking.neverNull((Object)((IAnalysisReaderFactoryV2.IAnalysisCAMDataStream)viewIt.value()));
                                    camView = stream.getCAMView();
                                    @Nullable String name = camView.name;
                                    nonNullName = ((String)NullChecking.neverNullOr((Object)name, (Object)("CAM View " + viewUID2))).replaceAll("[^\\w\\-_ ]", "");
                                    if (name == null) {
                                        String error = String.format(AnalysisMessages.WARNING_NONEXISTENT_VIEW, vmUID, viewUID2);
                                        item = new WarningItem(WarningType.CAM, WarningSeverity.HIGH, AnalysisMessages.WARNING_INVALID_DATA_TITLE, error);
                                        this.warning((WarningItem)item);
                                    }
                                    baseViewPath = CAM_Model.findViewPath(new File(this.mOutputPath), vmUID, nonNullName);
                                    baseViewPath.mkdirs();
                                    item = null;
                                    Object var17_25 = null;
                                    try {
                                        @NonNull CAMIndexDataFileWriter binWriterInstance = new CAMIndexDataFileWriter(this.mSettings, baseViewPath);
                                        try {
                                            block41: {
                                                @NonNull DataOutputStream jobWriter = StreamUtils.createCompressedDataOutput((File)new File(baseViewPath, "jobs.bin"));
                                                try {
                                                    try (@NonNull DataOutputStream cookieWriter = StreamUtils.createCompressedDataOutput((File)new File(baseViewPath, "cookies.txt"));){
                                                        @NonNull TObjectIntHashMap cookieMap = new TObjectIntHashMap(10, 0.5f, -1);
                                                        CAMJobWriter.getCookie((TObjectIntMap<String>)cookieMap, cookieWriter, "");
                                                        Throwable throwable2 = null;
                                                        Object var23_35 = null;
                                                        try (IAnalysisCAMReader mReader = stream.createReader();){
                                                            IAnalysisCAMReader.Value nextValue = null;
                                                            while ((nextValue = mReader.read()) != null) {
                                                                CAMJobWriter.emit(nextValue, binWriterInstance, jobWriter, cookieWriter, (TObjectIntMap<String>)cookieMap);
                                                            }
                                                        }
                                                        catch (Throwable throwable3) {
                                                            if (throwable2 == null) {
                                                                throwable2 = throwable3;
                                                                throw throwable2;
                                                            }
                                                            if (throwable2 == throwable3) throw throwable2;
                                                            throwable2.addSuppressed(throwable3);
                                                            throw throwable2;
                                                        }
                                                    }
                                                    if (jobWriter == null) break block41;
                                                }
                                                catch (Throwable throwable4) {
                                                    if (item == null) {
                                                        item = throwable4;
                                                    } else if (item != throwable4) {
                                                        ((Throwable)item).addSuppressed(throwable4);
                                                    }
                                                    if (jobWriter == null) throw item;
                                                    jobWriter.close();
                                                    throw item;
                                                }
                                                jobWriter.close();
                                            }
                                            if (binWriterInstance == null) break block42;
                                        }
                                        catch (Throwable throwable5) {
                                            if (item == null) {
                                                item = throwable5;
                                            } else if (item != throwable5) {
                                                ((Throwable)item).addSuppressed(throwable5);
                                            }
                                            if (binWriterInstance == null) throw item;
                                            binWriterInstance.close();
                                            throw item;
                                        }
                                        binWriterInstance.close();
                                    }
                                    catch (Throwable throwable6) {
                                        if (item == null) {
                                            item = throwable6;
                                            throw item;
                                        }
                                        if (item == throwable6) throw item;
                                        ((Throwable)item).addSuppressed(throwable6);
                                        throw item;
                                    }
                                }
                                @NonNull File tracksFile = new File(baseViewPath, "tracks.bin");
                                @NonNull TIntObjectIterator tracksIterator = camView.tracks.iterator();
                                CAMTrackWriter.write((File)tracksFile, (TIntObjectIterator)tracksIterator);
                                camXmlWriter.write(vmUID, viewUID2, nonNullName, camView.originUtid);
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable7) {
                        void var2_9;
                        if (throwable == null) {
                            Throwable throwable8 = throwable7;
                            throw var2_9;
                        }
                        if (throwable == throwable7) throw var2_9;
                        throwable.addSuppressed(throwable7);
                        throw var2_9;
                    }
                }
                iAnalysisCAMDataStream = iterator.next();
                @NonNull CAMView camView = iAnalysisCAMDataStream.getCAMView();
                long vmUID = camView.vmUID;
                viewUID = camView.viewUID;
                streamsByView = (TIntObjectMap)streams.get(vmUID);
                if (streamsByView != null) continue;
                streamsByView = new TIntObjectHashMap();
                streams.put(vmUID, (Object)streamsByView);
            } while ((prev = (IAnalysisReaderFactoryV2.IAnalysisCAMDataStream)streamsByView.put(viewUID, (Object)iAnalysisCAMDataStream)) == null);
            throw new AssertionError();
        }
        catch (IOException e) {
            this.error(e);
        }
    }

    private static void emit(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAnalysisCAMReader.Value value, @NonNull CAMIndexDataFileWriter binWriter, @NonNull DataOutputStream jobWriter, @NonNull DataOutputStream cookieWriter, @NonNull TObjectIntMap<String> cookieMap) throws IOException {
        jobWriter.writeInt(value.jobUID);
        jobWriter.writeInt(value.track);
        int cookie = CAMJobWriter.getCookie(cookieMap, cookieWriter, value.name);
        jobWriter.writeInt(cookie);
        jobWriter.writeLong(value.startTime);
        jobWriter.writeLong(value.duration);
        jobWriter.writeInt(value.primaryDependency);
        jobWriter.writeInt(value.dependencies.length);
        int[] nArray = value.dependencies;
        int n = value.dependencies.length;
        int n2 = 0;
        while (n2 < n) {
            int dependency = nArray[n2];
            jobWriter.writeInt(dependency);
            ++n2;
        }
        jobWriter.writeInt(value.colour);
        jobWriter.writeInt(-1);
        jobWriter.writeUTF(value.detailText);
        binWriter.addBin(value.jobUID, value.startTime, value.startTime + value.duration);
    }
}

