/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.timeline;

import com.arm.streamline.analysis.processor.timeline.CAMIndexDataFileScaleWriter;
import com.arm.streamline.analysis.session.SessionSettings;
import com.arm.streamline.report.shared.io.IndexDataFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class CAMIndexDataFileWriter
implements Closeable {
    private static final long NS_PER_SECOND = 1000000000L;
    private final @NonNull File mBaseDir;
    private final @NonNull List<@NonNull Bin> mBins = new ArrayList<Bin>();
    private final long mCaptureLength;
    private final int[] mScale;
    private final int[] mTicksPerScale;

    public CAMIndexDataFileWriter(SessionSettings settings, @NonNull File baseDir) {
        this.mScale = settings.getTimeScale();
        this.mTicksPerScale = settings.getTicksPerScale();
        this.mCaptureLength = settings.getDurationInNanosecs();
        this.mBaseDir = baseDir;
    }

    public void addBin(int uid, long startTime, long stopTime) {
        this.mBins.add(new Bin(uid, startTime, stopTime));
    }

    @Override
    public void close() throws IOException {
        CAMIndexDataFileScaleWriter writer = new CAMIndexDataFileScaleWriter(this.mCaptureLength, this.mBins);
        long scaleMultiplier = 1000000000L / (long)this.mScale[0];
        int scaleIndex = 0;
        while (scaleIndex < this.mScale.length) {
            long tickMultiplier = (long)this.mTicksPerScale[scaleIndex] * scaleMultiplier;
            Throwable throwable = null;
            Object var8_7 = null;
            try (IndexDataFileAdapter binFile = new IndexDataFileAdapter(new File(this.mBaseDir, String.format("cam_%d.bin", this.mScale[scaleIndex])));){
                writer.process(tickMultiplier, binFile);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++scaleIndex;
        }
    }

    protected static class Bin
    implements Comparable<Bin> {
        protected final int mCommandUID;
        protected final long mStartTime;
        protected final long mStopTime;

        protected Bin(int uid, long startTime, long stopTime) {
            this.mCommandUID = uid;
            this.mStartTime = startTime;
            this.mStopTime = stopTime;
        }

        @Override
        public int compareTo(Bin o) {
            int result = Long.compare(this.mStartTime, o.mStartTime);
            if (result != 0) {
                return result;
            }
            return Long.compare(this.mStopTime, o.mStopTime);
        }
    }

    protected static class IndexDataFileAdapter
    implements CAMIndexDataFileScaleWriter.IBinIndexWriter,
    Closeable {
        private final @NonNull IndexDataFile dataFile;

        public IndexDataFileAdapter(@NonNull File path) throws IOException {
            this.dataFile = new IndexDataFile(path.getCanonicalPath());
        }

        @Override
        public void close() throws IOException {
            this.dataFile.flush();
            this.dataFile.close();
        }

        @Override
        public void writeBlobIndex(byte[] buffer, int offset, int length) throws IOException {
            this.dataFile.writeBlobIndex(buffer, offset, length);
        }

        @Override
        public void writeEmptyIndex() throws IOException {
            this.dataFile.writeLEInt(-1);
            this.dataFile.writeIndex();
        }
    }
}

