/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.timeline;

import com.arm.streamline.analysis.processor.timeline.CAMIndexDataFileWriter;
import com.arm.utils.NullChecking;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class CAMIndexDataFileScaleWriter {
    private int binLength = 0;
    private final  @NonNull CAMIndexDataFileWriter.Bin @NonNull [] bins;
    private boolean changed;
    private int lastTickStartIndex = 0;
    private final @NonNull List< @NonNull CAMIndexDataFileWriter.Bin> mBins;
    private final int mBinsSize;
    private final long mCaptureLength;
    private final @NonNull TIntList removedCountList;
    private final @NonNull TIntList removedIndexList;
    private final @NonNull ByteBuffer writeBuffer;

    private static int removedBins( @NonNull CAMIndexDataFileWriter.Bin @NonNull [] bins, int binLength, @NonNull TIntList removedIndexList, @NonNull TIntList removedCountList) {
        int removedListSize = removedIndexList.size();
        assert (removedCountList.size() == removedListSize);
        int removedListIndex = removedListSize - 1;
        while (removedListIndex >= 0) {
            int removedIndex = removedIndexList.get(removedListIndex);
            int removedCount = removedCountList.get(removedListIndex);
            int moveFromIndex = removedIndex + removedCount;
            int moveToIndex = removedIndex;
            int moveLength = binLength - moveFromIndex;
            System.arraycopy(bins, moveFromIndex, bins, moveToIndex, moveLength);
            binLength -= removedCount;
            --removedListIndex;
        }
        return binLength;
    }

    public CAMIndexDataFileScaleWriter(long captureLength, @NonNull List< @NonNull CAMIndexDataFileWriter.Bin> binsList) {
        this.mBins = binsList;
        this.mCaptureLength = captureLength;
        this.mBinsSize = binsList.size();
        this.removedIndexList = new TIntArrayList(this.mBinsSize);
        this.removedCountList = new TIntArrayList(this.mBinsSize);
        this.writeBuffer = (ByteBuffer)NullChecking.neverNull((Object)ByteBuffer.allocate(this.mBinsSize * 4));
        this.writeBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.bins = new CAMIndexDataFileWriter.Bin[this.mBinsSize];
        Collections.sort(this.mBins);
    }

    public void process(long tickMultiplier, @NonNull IBinIndexWriter binFile) throws IOException {
        long lastTickStart = this.mCaptureLength / tickMultiplier * tickMultiplier;
        int lastReadIndex = 0;
        this.lastTickStartIndex = 0;
        this.binLength = 0;
        this.changed = false;
        long tick = 0L;
        while (tick < this.mCaptureLength) {
            long tickEnd = tick + tickMultiplier;
            this.removeExpiredBins(tick, lastTickStart);
            int binIndex = lastReadIndex;
            while (binIndex < this.mBinsSize) {
                CAMIndexDataFileWriter.Bin bin = this.mBins.get(binIndex);
                if (bin.mStartTime >= tickEnd) break;
                lastReadIndex = binIndex + 1;
                if (bin.mStopTime >= tick) {
                    this.changed = true;
                    this.bins[this.binLength++] = bin;
                    this.writeBuffer.putInt(bin.mCommandUID);
                }
                ++binIndex;
            }
            if (this.writeBuffer.position() > 0) {
                binFile.writeBlobIndex(this.writeBuffer.array(), 0, this.changed ? this.writeBuffer.position() : 0);
            } else {
                binFile.writeEmptyIndex();
            }
            tick += tickMultiplier;
        }
    }

    private void removeExpiredBins(long tick, long lastTickStart) {
        this.removedIndexList.clear();
        this.removedCountList.clear();
        this.writeBuffer.position(this.lastTickStartIndex * 4);
        this.changed = false;
        int binIndex = this.lastTickStartIndex;
        while (binIndex < this.binLength) {
            CAMIndexDataFileWriter.Bin bin = this.bins[binIndex];
            if (bin.mStopTime >= tick) {
                this.writeBuffer.putInt(bin.mCommandUID);
                if (bin.mStopTime >= lastTickStart && this.lastTickStartIndex == binIndex) {
                    ++this.lastTickStartIndex;
                }
            } else {
                int removedListSize = this.removedIndexList.size();
                assert (removedListSize == this.removedCountList.size());
                if (removedListSize > 0) {
                    int removedCount;
                    int removedListTailIndex = removedListSize - 1;
                    int removedIndex = this.removedIndexList.get(removedListTailIndex);
                    if (binIndex == removedIndex + (removedCount = this.removedCountList.get(removedListTailIndex))) {
                        this.removedCountList.set(removedListTailIndex, removedCount + 1);
                    } else {
                        this.removedIndexList.add(binIndex);
                        this.removedCountList.add(1);
                    }
                } else {
                    this.removedIndexList.add(binIndex);
                    this.removedCountList.add(1);
                }
                this.changed = true;
            }
            ++binIndex;
        }
        this.binLength = CAMIndexDataFileScaleWriter.removedBins(this.bins, this.binLength, this.removedIndexList, this.removedCountList);
    }

    public static interface IBinIndexWriter {
        public void writeBlobIndex(byte[] var1, int var2, int var3) throws IOException;

        public void writeEmptyIndex() throws IOException;
    }
}

