/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.profile;

import com.arm.streamline.analysis.database.api.profiling.IProfileEvent;
import com.arm.streamline.analysis.database.api.profiling.IProfileSource;
import com.arm.streamline.analysis.database.api.profiling.ProfileDataPoint;
import com.arm.streamline.analysis.processor.profile.CallPathsFileWriter;
import com.arm.streamline.analysis.processor.profile.ICallPathsFileWriter;
import com.arm.streamline.analysis.processor.profile.IProfileWriterFactory;
import com.arm.streamline.analysis.processor.timeline.CallpathsInstructions;
import com.arm.streamline.analysis.processor.timeline.ICallpathsInstructions;
import com.arm.streamline.common.model.icounters.InstructionCounterSourceMetadata;
import com.arm.streamline.common.report.model.ResolutionMode;
import com.arm.streamline.common.utility.io.LittleEndianDataOutputStream;
import com.arm.streamline.report.model.icounters.InstructionCounterConstants;
import com.arm.streamline.report.shared.icounter.InstructionCounterMetadataXml;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public class ProfileWriterFactory
implements IProfileWriterFactory {
    private final @NonNull File outputPath;
    private final @NonNull Map<@NonNull IProfileSource, @NonNull TObjectIntMap<IProfileEvent>> sourceToEventToPathIndexMap = new HashMap<IProfileSource, TObjectIntMap<IProfileEvent>>();
    private final @NonNull TObjectIntMap<IProfileSource> sourceToPathIndexMap = new TObjectIntHashMap(10, 0.5f, 0);
    private final int densestBinsPerSecond;

    public ProfileWriterFactory(@NonNull String outputPath, @NonNull ResolutionMode resolutionMode) {
        this.outputPath = new File(outputPath);
        this.densestBinsPerSecond = resolutionMode.toDensestZoomLevel().getBps();
    }

    @Override
    public @NonNull IProfileWriterFactory.ICallpathsBinWriter createCallpathsBinWriter(@NonNull ProfileDataPoint event) throws IOException {
        File output = this.getMetricsOutput(event, "callpaths.bin");
        final LittleEndianDataOutputStream callpathsBin = new LittleEndianDataOutputStream(output);
        return new IProfileWriterFactory.ICallpathsBinWriter(){

            @Override
            public void add(int link, long samples) throws IOException {
                callpathsBin.writeLEInt(link);
                callpathsBin.writeLELong(samples);
            }

            @Override
            public void close() throws IOException {
                callpathsBin.close();
            }
        };
    }

    @Override
    public @NonNull ICallPathsFileWriter createCallpathsFileWriter(@NonNull IProfileSource source) throws IOException {
        return new CallPathsFileWriter(this.getSourceOutput(source, "callpaths.bin"));
    }

    @Override
    public @NonNull ICallPathsFileWriter createCommonCallpathsFileWriter() throws IOException {
        return new CallPathsFileWriter(this.getICounterOutput("callpaths.bin"));
    }

    @Override
    public @NonNull IProfileWriterFactory.IInstructionCounterMetadataWriter createEventMetadataWriter(@NonNull IProfileEvent event) throws IOException {
        final File output = this.getEventOutput(event, "metadata.xml");
        return new IProfileWriterFactory.IInstructionCounterMetadataWriter(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public void write(@NonNull InstructionCounterMetadataXml metadata) throws IOException {
                InstructionCounterMetadataXml.save((File)output, (InstructionCounterMetadataXml)metadata);
            }
        };
    }

    @Override
    public @NonNull IProfileWriterFactory.IInstructionsBinWriter createInstructionsBinWriter(@NonNull ProfileDataPoint event) throws IOException {
        File output = this.getMetricsOutput(event, "instructions.bin");
        final LittleEndianDataOutputStream instructionsBin = new LittleEndianDataOutputStream(output);
        return new IProfileWriterFactory.IInstructionsBinWriter(){

            @Override
            public void add(long samples) throws IOException {
                instructionsBin.writeLELong(samples);
            }

            @Override
            public void close() throws IOException {
                instructionsBin.close();
            }
        };
    }

    @Override
    public @NonNull IProfileWriterFactory.ILinesBinWriter createLinesBinWriter() throws IOException {
        File output = this.getICounterOutput("lines.bin");
        final LittleEndianDataOutputStream countsBin = new LittleEndianDataOutputStream(output);
        return new IProfileWriterFactory.ILinesBinWriter(){

            @Override
            public void add(int line, int functionIndex) throws IOException {
                countsBin.writeLEInt(line);
                countsBin.writeLEInt(functionIndex);
            }

            @Override
            public void close() throws IOException {
                countsBin.close();
            }
        };
    }

    @Override
    public @NonNull IProfileWriterFactory.IInstructionCounterSourceMetadataWriter createSourceMetadataWriter(@NonNull IProfileSource source) throws IOException {
        final File output = this.getSourceOutput(source, "metadata.xml");
        return new IProfileWriterFactory.IInstructionCounterSourceMetadataWriter(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public void write(@NonNull InstructionCounterSourceMetadata metadata) throws IOException {
                InstructionCounterSourceMetadata.save((File)output, (InstructionCounterSourceMetadata)metadata);
            }
        };
    }

    @Override
    public @NonNull ICallpathsInstructions createTimelineWriter(@NonNull ProfileDataPoint event) throws IOException {
        return new CallpathsInstructions(this.getDataPointOutput(event, "timeline").getPath(), this.densestBinsPerSecond);
    }

    private @NonNull File getDataPointOutput(@NonNull ProfileDataPoint dataPoint, @NonNull String filename) {
        int sourceId = this.getSourceId(dataPoint.event.getSource());
        int eventId = this.getEventId(dataPoint.event);
        @NonNull File dataPointDir = InstructionCounterConstants.getDataPointPath((File)this.outputPath, (int)sourceId, (int)eventId, (int)dataPoint.dataPointId);
        dataPointDir.mkdirs();
        return new File(dataPointDir, filename);
    }

    private int getEventId(@NonNull IProfileEvent event) {
        @NonNull IProfileSource source = event.getSource();
        @NonNull TObjectIntMap eventToPathIndexMap = this.sourceToEventToPathIndexMap.computeIfAbsent(source, s -> new TObjectIntHashMap(10, 0.5f, 0));
        return eventToPathIndexMap.adjustOrPutValue((Object)event, 0, eventToPathIndexMap.size());
    }

    private @NonNull File getEventOutput(@NonNull IProfileEvent event, @NonNull String filename) {
        int sourceId = this.getSourceId(event.getSource());
        int eventId = this.getEventId(event);
        @NonNull File eventDir = InstructionCounterConstants.getEventPath((File)this.outputPath, (int)sourceId, (int)eventId);
        eventDir.mkdirs();
        return new File(eventDir, filename);
    }

    private @NonNull File getICounterOutput(@NonNull String filename) {
        @NonNull File icounterDir = new File(this.outputPath, "icounter");
        icounterDir.mkdirs();
        return new File(icounterDir, filename);
    }

    private @NonNull File getMetricsOutput(@NonNull ProfileDataPoint dataPoint, @NonNull String filename) {
        @NonNull File metricsDir = this.getDataPointOutput(dataPoint, "metrics");
        metricsDir.mkdirs();
        return new File(metricsDir, filename);
    }

    private int getSourceId(@NonNull IProfileSource source) {
        return this.sourceToPathIndexMap.adjustOrPutValue((Object)source, 0, this.sourceToPathIndexMap.size());
    }

    private @NonNull File getSourceOutput(@NonNull IProfileSource source, @NonNull String filename) {
        int sourceId = this.getSourceId(source);
        @NonNull File sourceDir = InstructionCounterConstants.getSourcePath((File)this.outputPath, (int)sourceId);
        sourceDir.mkdirs();
        return new File(sourceDir, filename);
    }
}

