/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.profile;

import com.arm.streamline.analysis.AnalysisBase;
import com.arm.streamline.common.analysis.IAnalysisHandler;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.jni.apcdbgen.ApcReport;
import com.arm.streamline.jni.apcdbgen.ApcReportGen;
import com.arm.streamline.jni.common.CancellationPredicate;
import com.arm.streamline.jni.common.IProgressMonitorFactory;
import com.arm.streamline.utility.HandlerProgressMonitorFactory;
import java.io.File;
import java.util.concurrent.ExecutorService;
import org.eclipse.jdt.annotation.NonNull;

public class ProfileV3
extends AnalysisBase {
    private final @NonNull ApcReportGen apcReportGen;
    private final @NonNull CancellationPredicate cancellation;
    private final @NonNull File apcCapture;

    public ProfileV3(@NonNull IAnalysisHandler handler, @NonNull File apcCapture) {
        super(handler);
        ExecutorService executor = Task.getExecutorService();
        this.apcCapture = apcCapture;
        this.cancellation = new CancellationPredicate();
        this.apcReportGen = new ApcReportGen("performance-studio", executor, (IProgressMonitorFactory)new HandlerProgressMonitorFactory(handler, apcCapture));
        this.start();
    }

    @Override
    public void cancel() {
        super.cancel();
        this.cancellation.cancel();
    }

    @Override
    protected void process() {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                ApcReport report = this.apcReportGen.openReport(this.apcCapture, this.cancellation);
                if (report != null) {
                    report.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.getHandler().error((Throwable)e);
        }
    }
}

