/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.profile;

import com.arm.streamline.analysis.AnalysisBase;
import com.arm.streamline.analysis.database.api.profiling.IAnalysisCodeProfilingReader;
import com.arm.streamline.analysis.gator.BacktraceProcessing;
import com.arm.streamline.analysis.model.AnalysisModel;
import com.arm.streamline.analysis.model.IMonotonicRawToVmTimestamp;
import com.arm.streamline.analysis.model.SourcefileRecord;
import com.arm.streamline.analysis.processor.profile.InstructionReader;
import com.arm.streamline.analysis.processor.profile.JITDumpParser;
import com.arm.streamline.analysis.processor.profile.JITDumpParserException;
import com.arm.streamline.analysis.processor.profile.JITDumpStateBuilder;
import com.arm.streamline.analysis.processor.profile.Messages;
import com.arm.streamline.analysis.processor.profile.ProfileFunctionMap;
import com.arm.streamline.analysis.processor.profile.ProfileProcessor;
import com.arm.streamline.analysis.processor.profile.ProfileProcessorFactory;
import com.arm.streamline.analysis.processor.profile.ProfileWriter;
import com.arm.streamline.analysis.processor.profile.ProfileWriterFactory;
import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.analysis.session.SessionSettings;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.analysis.IAnalysisHandler;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.common.model.warnings.WarningSeverity;
import com.arm.streamline.common.model.warnings.WarningType;
import com.arm.streamline.common.widget.CommonError;
import com.arm.streamline.model.session.PathWithEnabledFlag;
import com.arm.streamline.protocol.misc.AttachedApkEntries;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.utils.NullChecking;
import com.arm.utils.function.IThrowingSupplier;
import com.arm.utils.function.Throwing;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongPredicate;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class Profile
extends AnalysisBase {
    private final @NonNull Stream<@NonNull IThrowingSupplier<@NonNull IAnalysisCodeProfilingReader, IOException>> streamProviders;
    private final @NonNull TIntObjectMap<List<@NonNull JITDumpStateBuilder.JITDumpState>> jitdumpFiles = new TIntObjectHashMap();
    private final @NonNull List<@NonNull PathWithEnabledFlag> mJitDumpFiles;
    private final @Nullable InstructionReader instructionReader;
    private final @NonNull ProfileWriter writer;
    private @Nullable ProfileWriter.Result result = null;
    private final @Nullable ProfileFunctionMap functionMap;
    private final @NonNull File apcDirectory;

    private static void loadJITDumps(@NonNull IAnalysisHandler handler, @NonNull File apcDirectory, @NonNull List<@NonNull PathWithEnabledFlag> jitDumpFiles, @NonNull TIntObjectMap<List<@NonNull JITDumpStateBuilder.JITDumpState>> result) {
        for (PathWithEnabledFlag jitdumpFile : jitDumpFiles) {
            if (!jitdumpFile.isUsed()) continue;
            File path = jitdumpFile.resolvePath(apcDirectory);
            try {
                Throwable throwable = null;
                Object var8_11 = null;
                try {
                    FileInputStream fis = new FileInputStream(path);
                    try {
                        try (BufferedInputStream bis = new BufferedInputStream(fis);){
                            JITDumpParser.JITDump dump = JITDumpParser.parse(bis);
                            JITDumpStateBuilder stateBuilder = new JITDumpStateBuilder(path, dump.header);
                            dump.sort();
                            for (JITDumpParser.JITDump.JITDumpRecord r : dump.getRecords()) {
                                stateBuilder.processRecord(r);
                            }
                            JITDumpStateBuilder.JITDumpState state = stateBuilder.getState();
                            JITDumpParser.JITDump.JITDumpHeader header = state.getHeader();
                            ArrayList<@NonNull JITDumpStateBuilder.JITDumpState> list = (ArrayList<JITDumpStateBuilder.JITDumpState>)result.get(header.pid);
                            if (list == null) {
                                list = new ArrayList<JITDumpStateBuilder.JITDumpState>();
                                result.put(header.pid, list);
                            }
                            list.add(state);
                        }
                        if (fis == null) continue;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (fis != null) {
                            fis.close();
                        }
                        throw throwable;
                    }
                    fis.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (JITDumpParserException e) {
                handler.warning(new WarningItem(WarningType.SESSION_PROCESSOR, WarningSeverity.MEDIUM, String.format(Messages.Profile_JITDumpParserException_Title, path.getAbsolutePath()), (String)NullChecking.neverNullOr((Object)e.getMessage(), (Object)"")));
                e.printStackTrace();
            }
            catch (Exception e) {
                handler.warning(new WarningItem(WarningType.SESSION_PROCESSOR, WarningSeverity.MEDIUM, String.format(Messages.Profile_UnexpectedException_Title, path.getAbsolutePath()), (String)NullChecking.neverNullOr((Object)e.getMessage(), (Object)"")));
                e.printStackTrace();
            }
        }
    }

    public Profile(SessionSettings settings, AnalysisModel model, @NonNull SessionProcessor sp, @NonNull BacktraceProcessing backtraceProcessing, @NonNull Stream<@NonNull IThrowingSupplier<@NonNull IAnalysisCodeProfilingReader, IOException>> streamProviders, @NonNull TLongObjectMap<? extends IMonotonicRawToVmTimestamp> perVmTimestampAdjustmentFactor, @NonNull AttachedApkEntries attachedApkEntries, @NonNull LongPredicate isAppTracingMode) {
        super(sp);
        this.progress(0);
        this.apcDirectory = new File(model.getCaptureDetails().getPath());
        this.streamProviders = streamProviders;
        @NonNull String outputPath = settings.getOutputPath();
        InstructionReader instructionReader = null;
        try {
            instructionReader = new InstructionReader(outputPath);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.instructionReader = instructionReader;
        this.functionMap = instructionReader != null ? new ProfileFunctionMap(instructionReader, model.getCaptureDetails().isCallStackUnwindingSupported()) : null;
        this.mJitDumpFiles = model.getAnalysisInputSettings().getJitDumpFilePaths();
        ProfileProcessor processor = ProfileProcessorFactory.create(this.jitdumpFiles, (IUniqueIds)NullChecking.neverNull((Object)sp.getUniqueIds()), backtraceProcessing, settings.getDurationInNanosecs(), perVmTimestampAdjustmentFactor, this.functionMap != null ? this.functionMap : ignore -> null, model.getImageRecordMap(), attachedApkEntries, isAppTracingMode, model.getAnalysisInputSettings().isFilterCallStacksDataEnabled());
        this.writer = new ProfileWriter(processor, new ProfileWriterFactory(outputPath, settings.getResolutionMode()));
        this.setName("Profile", settings.getInputPath(), settings.getOutputPath());
        this.setPriorityLower();
        this.start();
    }

    @Override
    public void close() {
        try {
            if (this.instructionReader != null) {
                this.instructionReader.close();
            }
        }
        catch (IOException exception) {
            CommonPlugin.error((Throwable)exception);
            CommonError.show((Plugin)StreamlinePlugin.getInstance(), (String)"com.arm.streamline", (Throwable)exception);
        }
        super.close();
    }

    public long getSamplesOffset(@NonNull SourcefileRecord file) {
        ProfileWriter.Result result = this.result;
        return result != null ? result.getSamplesOffset.applyAsLong(file) : 0L;
    }

    public long getSamplesQuantity(@NonNull SourcefileRecord file) {
        ProfileWriter.Result result = this.result;
        return result != null ? result.getSamplesQuantity.applyAsLong(file) : 0L;
    }

    @Override
    protected void process() {
        try {
            Profile.loadJITDumps(this.getHandler(), this.apcDirectory, this.mJitDumpFiles, this.jitdumpFiles);
            Throwing.forEach(this.streamProviders, provider -> {
                Throwable throwable = null;
                Object var3_4 = null;
                try (IAnalysisCodeProfilingReader codeProfilingReader = (IAnalysisCodeProfilingReader)provider.get();){
                    this.writer.processDatabase(this::progress, codeProfilingReader);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            });
            this.result = this.writer.finish();
            if (this.functionMap != null) {
                this.functionMap.generateCallstackWarnings(this.writer.getImageRecordMap(), this::warning);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            this.error(e);
        }
    }
}

