/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.profile;

import com.arm.streamline.analysis.model.IFunctionRecord;
import com.arm.streamline.analysis.model.JITSourcefileRecordList;
import com.arm.streamline.analysis.model.SourcefileRecord;
import com.arm.streamline.analysis.processor.profile.FunctionHeaderFooter;
import com.arm.streamline.analysis.processor.profile.IInstructionReader;
import com.arm.streamline.analysis.processor.profile.InstructionWriter;
import com.arm.streamline.analysis.processor.profile.JITDumpStateBuilder;
import com.arm.streamline.common.analysis.session.AddressMap;
import com.arm.streamline.common.analysis.session.AddressMap64;
import com.arm.utils.NullChecking;
import com.arm.utils.function.IMultiIntSupplier;
import com.arm.utils.io.ByteBufferUtils;
import gnu.trove.list.array.TIntArrayList;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntSupplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class JITFunctionRecord
implements IFunctionRecord {
    public static final @NonNull String JITTED_CODE = "<JITTED CODE>";
    private static final @NonNull IInstructionLengthProvider EMPTY_INSTRUCTION_LENGTHS = new ArmInstructionLengthProvider(0);
    private static final String JIT_REMAP_PATH = "/JITTED_CODE/";
    private static final int T32_OPCODE_PREFIX = 59392;
    private static final int EM_AARCH32 = 40;
    private static final int EM_AARCH64 = 183;
    private final int firstInstruction;
    private final int id;
    private final long mapAddress;
    private final @NonNull Shared shared;

    public static @NonNull IInstructionLengthProvider calculateInstructionLengths(byte @Nullable [] instructions, int elfMachine, boolean dwarf, boolean littleEndian) {
        if (instructions == null) {
            return EMPTY_INSTRUCTION_LENGTHS;
        }
        if (elfMachine == 183 || elfMachine == 40 && !dwarf) {
            return new ArmInstructionLengthProvider(instructions.length / 4);
        }
        if (elfMachine != 40) {
            return EMPTY_INSTRUCTION_LENGTHS;
        }
        ByteBuffer buffer = ByteBuffer.wrap(instructions);
        buffer.order(littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        TIntArrayList result = new TIntArrayList();
        try {
            while (buffer.hasRemaining()) {
                int opcode = ByteBufferUtils.read2bytesUnsigned((ByteBuffer)buffer);
                if (opcode >= 59392) {
                    ByteBufferUtils.read2bytesUnsigned((ByteBuffer)buffer);
                    result.add(4);
                    continue;
                }
                result.add(2);
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        return new ThumbInstructionLengthProvider((int[])NullChecking.neverNull((Object)result.toArray()));
    }

    public static byte @Nullable [] readInstructionData(@NonNull JITDumpStateBuilder.JITCode codeObject) {
        @NonNull SoftReference<byte[]> weakRef = codeObject.loadRecord.codeBytes;
        byte[] result = (byte[])((Reference)weakRef).get();
        if (result != null) {
            return result;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (RandomAccessFile raf = new RandomAccessFile(codeObject.jitdumpFile, "r");){
                byte[] instructions = new byte[codeObject.loadRecord.codeSize];
                raf.seek(codeObject.loadRecord.offset + (long)codeObject.loadRecord.codeRelativeOffset);
                raf.readFully(instructions, 0, instructions.length);
                return instructions;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exception) {
            return null;
        }
    }

    public JITFunctionRecord(@NonNull IntSupplier functionIdSupplier, @NonNull IMultiIntSupplier instructionIdSupplier, @NonNull Shared shared, @NonNull JITDumpStateBuilder.JITCodeMapping codeMappingObject) {
        this.shared = shared;
        this.id = functionIdSupplier.getAsInt();
        this.mapAddress = codeMappingObject.address;
        this.firstInstruction = instructionIdSupplier.getFirstOfNAsInt(shared.instructionLengthsProvider.getInstructionCount() + 1);
    }

    @Override
    public @Nullable FunctionHeaderFooter createFunctionHeaderFooter(@NonNull IInstructionReader ignored) throws IOException {
        @Nullable JITInstructionReader instructionReader = this.getInstructionReader();
        return instructionReader != null ? new FunctionHeaderFooter(this, instructionReader) : null;
    }

    @Override
    public @NonNull Map<@NonNull String, @Nullable String> getAliases() {
        return Collections.emptyMap();
    }

    @Override
    public @Nullable SourcefileRecord getFile() {
        return this.shared.sourceFile;
    }

    @Override
    public int getFirstInstruction() {
        return this.firstInstruction;
    }

    @Override
    public int getFirstSourceline() {
        return this.shared.lowestSourceLine;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public int getLastInstruction() {
        return this.firstInstruction + this.shared.instructionLengthsProvider.getInstructionCount();
    }

    @Override
    public int getLastSourceline() {
        return this.shared.highestSourceLine;
    }

    @Override
    public @NonNull String getName() {
        return this.shared.name;
    }

    @Override
    public long getOffsetInFile(long address) {
        return address - this.mapAddress;
    }

    @Override
    public int getSize() {
        byte @Nullable [] instructions = this.shared.instructions;
        return instructions != null ? instructions.length : 0;
    }

    @Override
    public int getStack() {
        return 0;
    }

    @Override
    public boolean hasStackFrame() {
        return false;
    }

    @Override
    public boolean isScript() {
        return false;
    }

    @Override
    public boolean isUnknown() {
        return false;
    }

    public void writeInstructions(@NonNull InstructionWriter writer) throws IOException {
        int functionSourcefileID;
        writer.writeFunctionMarker(this.firstInstruction, this.id, false);
        @Nullable JITInstructionReader instructionReader = this.getInstructionReader();
        @Nullable SourcefileRecord functionSourcefile = this.shared.sourceFile;
        int n = functionSourcefileID = functionSourcefile != null ? functionSourcefile.getId() : 0;
        if (instructionReader != null) {
            int i = 0;
            while (i < this.shared.instructionLengthsProvider.getInstructionCount()) {
                int index = i + 1 + this.firstInstruction;
                @NonNull IInstructionReader.InstructionReaderEntry entry = instructionReader.get(index);
                boolean inline = entry.sourceFileID != functionSourcefileID && functionSourcefileID != 0;
                this.writeInstruction(writer, i, entry, inline);
                ++i;
            }
        }
    }

    private @Nullable JITInstructionReader getInstructionReader() {
        byte @Nullable [] instructions = this.shared.instructions;
        if (instructions == null) {
            return null;
        }
        @NonNull ByteBuffer buffer = ByteBuffer.wrap(instructions);
        buffer.order(this.shared.littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        if (this.shared.elfMachine == 183) {
            return new JITInstructionReader(buffer, this.shared.instructionLengthsProvider, this.firstInstruction, this.mapAddress, this.shared.lineNumberOffsets, this.shared.sourceFiles, true);
        }
        if (this.shared.elfMachine == 40 && !this.shared.thumb) {
            return new JITInstructionReader(buffer, this.shared.instructionLengthsProvider, this.firstInstruction, this.mapAddress, this.shared.lineNumberOffsets, this.shared.sourceFiles, false);
        }
        if (this.shared.elfMachine != 40) {
            return null;
        }
        return new JITInstructionReader(buffer, this.shared.instructionLengthsProvider, this.firstInstruction, this.mapAddress, this.shared.lineNumberOffsets, this.shared.sourceFiles);
    }

    private void writeInstruction(@NonNull InstructionWriter writer, int index, @NonNull IInstructionReader.InstructionReaderEntry entry, boolean inline) throws IOException {
        int instructionID = this.firstInstruction + index + 1;
        switch (entry.type) {
            case A32: 
            case A64: {
                if (entry.instructionLength != 4) {
                    throw new AssertionError();
                }
                writer.writeInstruction(instructionID, entry.address, entry.opcode, entry.sourceFileID, entry.sourceLine, false, false, false, entry.type == IInstructionReader.InstructionReaderEntry.Type.A64, inline, false);
                break;
            }
            case T32: {
                if ((entry.opcode & 0xFFFF) >= 59392) {
                    if (entry.instructionLength != 4) {
                        throw new AssertionError();
                    }
                    writer.writeInstruction(instructionID, entry.address, entry.opcode, entry.sourceFileID, entry.sourceLine, true, false, false, false, inline, false);
                    break;
                }
                if (entry.instructionLength != 2) {
                    throw new AssertionError();
                }
                writer.writeInstruction(instructionID, entry.address, entry.opcode, entry.sourceFileID, entry.sourceLine, true, false, true, false, inline, false);
                break;
            }
            default: {
                throw new AssertionError((Object)entry.type);
            }
        }
    }

    private static final class ArmInstructionLengthProvider
    implements IInstructionLengthProvider {
        private final int instructionCount;

        public ArmInstructionLengthProvider(int instructionCount) {
            this.instructionCount = instructionCount;
        }

        @Override
        public int getInstructionCount() {
            return this.instructionCount;
        }

        @Override
        public int getInstructionLength(int index) {
            if (index < 0 || index >= this.instructionCount) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return 4;
        }

        @Override
        public int getInstructionOffset(int index) {
            if (index < 0 || index >= this.instructionCount) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return index * 4;
        }
    }

    private static interface IInstructionLengthProvider {
        public int getInstructionCount();

        public int getInstructionLength(int var1);

        public int getInstructionOffset(int var1);
    }

    private static final class JITInstructionReader
    implements IInstructionReader {
        private final boolean a64;
        private final @NonNull ByteBuffer buffer;
        private final long codeAddress;
        private final int firstInstruction;
        private final @NonNull IInstructionLengthProvider instructionLengthsProvider;
        private final @Nullable AddressMap64<@NonNull JITDumpStateBuilder.JITLineNumberAddressMap.JITLineNumberAndFile> lineNumberOffsets;
        private final @NonNull Map<@NonNull String, @NonNull SourcefileRecord> sourceFiles;
        private final boolean thumb;

        public JITInstructionReader(@NonNull ByteBuffer buffer, @NonNull IInstructionLengthProvider instructionLengthsProvider, int firstInstruction, long codeAddress, @Nullable AddressMap64<@NonNull JITDumpStateBuilder.JITLineNumberAddressMap.JITLineNumberAndFile> lineNumberOffsets, @NonNull Map<@NonNull String, @NonNull SourcefileRecord> sourceFiles) {
            this.buffer = buffer;
            this.firstInstruction = firstInstruction;
            this.instructionLengthsProvider = instructionLengthsProvider;
            this.codeAddress = codeAddress;
            this.lineNumberOffsets = lineNumberOffsets;
            this.sourceFiles = sourceFiles;
            this.a64 = false;
            this.thumb = true;
        }

        public JITInstructionReader(@NonNull ByteBuffer buffer, @NonNull IInstructionLengthProvider instructionLengthsProvider, int firstInstruction, long codeAddress, @Nullable AddressMap64<@NonNull JITDumpStateBuilder.JITLineNumberAddressMap.JITLineNumberAndFile> lineNumberOffsets, @NonNull Map<@NonNull String, @NonNull SourcefileRecord> sourceFiles, boolean a64) {
            this.buffer = buffer;
            this.firstInstruction = firstInstruction;
            this.instructionLengthsProvider = instructionLengthsProvider;
            this.codeAddress = codeAddress;
            this.lineNumberOffsets = lineNumberOffsets;
            this.sourceFiles = sourceFiles;
            this.a64 = a64;
            this.thumb = false;
        }

        @Override
        public @NonNull IInstructionReader.InstructionReaderEntry get(int index) throws IOException {
            int sourceLine;
            if (index < this.firstInstruction || index > this.firstInstruction + this.instructionLengthsProvider.getInstructionCount()) {
                throw new IndexOutOfBoundsException();
            }
            if (index == this.firstInstruction) {
                @Nullable JITDumpStateBuilder.JITLineNumberAddressMap.JITLineNumberAndFile lineNumberAndFile = this.getSourceInfo(0);
                int sourceFileID = this.getSourceFileID(lineNumberAndFile);
                int sourceLine2 = lineNumberAndFile != null ? lineNumberAndFile.line : 0;
                return new IInstructionReader.InstructionReaderEntry(index, IInstructionReader.InstructionReaderEntry.Type.MARKER, this.codeAddress, 0, 0, sourceFileID, sourceLine2);
            }
            int instructionID = index - this.firstInstruction - 1;
            int instructionOffset = this.instructionLengthsProvider.getInstructionOffset(instructionID);
            int instructionLength = this.instructionLengthsProvider.getInstructionLength(instructionID);
            long address = this.codeAddress + (long)instructionOffset;
            int opcode = this.getOpcode(instructionOffset, instructionLength);
            @Nullable JITDumpStateBuilder.JITLineNumberAddressMap.JITLineNumberAndFile lineNumberAndFile = this.getSourceInfo(instructionOffset);
            int sourceFileID = this.getSourceFileID(lineNumberAndFile);
            int n = sourceLine = lineNumberAndFile != null ? lineNumberAndFile.line : 0;
            @NonNull IInstructionReader.InstructionReaderEntry.Type type = this.thumb ? IInstructionReader.InstructionReaderEntry.Type.T32 : (this.a64 ? IInstructionReader.InstructionReaderEntry.Type.A64 : IInstructionReader.InstructionReaderEntry.Type.A32);
            return new IInstructionReader.InstructionReaderEntry(index, type, address, opcode, instructionLength, sourceFileID, sourceLine);
        }

        private int getOpcode(int instructionOffset, int instructionLength) {
            switch (instructionLength) {
                case 2: {
                    return Short.toUnsignedInt(this.buffer.getShort(instructionOffset));
                }
                case 4: {
                    if (this.thumb) {
                        return Short.toUnsignedInt(this.buffer.getShort(instructionOffset)) | Short.toUnsignedInt(this.buffer.getShort(instructionOffset + 2)) << 16;
                    }
                    return this.buffer.getInt(instructionOffset);
                }
            }
            throw new AssertionError(instructionLength);
        }

        private int getSourceFileID(@Nullable JITDumpStateBuilder.JITLineNumberAddressMap.JITLineNumberAndFile lineNumberAndFile) {
            if (lineNumberAndFile == null) {
                return 0;
            }
            @NonNull SourcefileRecord sourceFileRecord = (SourcefileRecord)NullChecking.neverNull((Object)this.sourceFiles.get(lineNumberAndFile.filename));
            return sourceFileRecord.getId();
        }

        private @Nullable JITDumpStateBuilder.JITLineNumberAddressMap.JITLineNumberAndFile getSourceInfo(int instructionOffset) {
            @Nullable AddressMap64<@NonNull JITDumpStateBuilder.JITLineNumberAddressMap.JITLineNumberAndFile> lineNumberOffsets = this.lineNumberOffsets;
            if (lineNumberOffsets == null) {
                return null;
            }
            return (JITDumpStateBuilder.JITLineNumberAddressMap.JITLineNumberAndFile)lineNumberOffsets.findUpto(Integer.toUnsignedLong(instructionOffset));
        }
    }

    public static final class Shared {
        protected final long codeAddress;
        protected final int elfMachine;
        protected final int highestSourceLine;
        protected final @NonNull IInstructionLengthProvider instructionLengthsProvider;
        protected final byte @Nullable [] instructions;
        protected final @Nullable AddressMap64<@NonNull JITDumpStateBuilder.JITLineNumberAddressMap.JITLineNumberAndFile> lineNumberOffsets;
        protected final boolean littleEndian;
        protected final int lowestSourceLine;
        protected final @NonNull String name;
        protected final @Nullable SourcefileRecord sourceFile;
        protected final @NonNull Map<@NonNull String, @NonNull SourcefileRecord> sourceFiles;
        protected final boolean thumb;

        public Shared(@NonNull JITSourcefileRecordList sourcefileList, @NonNull JITDumpStateBuilder.JITCode codeObject, boolean thumb) {
            this.thumb = thumb;
            this.elfMachine = codeObject.header.elfMachine;
            this.littleEndian = codeObject.header.littleEndian;
            this.name = codeObject.loadRecord.name;
            this.codeAddress = codeObject.loadRecord.codeAddr;
            this.instructions = JITFunctionRecord.readInstructionData(codeObject);
            this.instructionLengthsProvider = JITFunctionRecord.calculateInstructionLengths(this.instructions, this.elfMachine, thumb, this.littleEndian);
            @Nullable AddressMap64<@NonNull JITDumpStateBuilder.JITLineNumberAddressMap.JITLineNumberAndFile> lineNumberOffsets = codeObject.lineNumberOffsets;
            if (lineNumberOffsets != null && lineNumberOffsets.size() > 0) {
                this.lineNumberOffsets = lineNumberOffsets;
                this.sourceFiles = new HashMap<String, SourcefileRecord>();
                String firstFilename = null;
                int lowestLine = 0;
                int highestLine = 0;
                for (AddressMap.Entry lineNumberOffset : lineNumberOffsets) {
                    this.sourceFiles.computeIfAbsent(((JITDumpStateBuilder.JITLineNumberAddressMap.JITLineNumberAndFile)lineNumberOffset.value).filename, filename -> {
                        @NonNull File sourceFile = new File(JITFunctionRecord.JIT_REMAP_PATH, (String)filename);
                        return sourcefileList.getOrCreate(sourceFile);
                    });
                    if (firstFilename == null) {
                        firstFilename = ((JITDumpStateBuilder.JITLineNumberAddressMap.JITLineNumberAndFile)lineNumberOffset.value).filename;
                        lowestLine = ((JITDumpStateBuilder.JITLineNumberAddressMap.JITLineNumberAndFile)lineNumberOffset.value).line;
                        highestLine = ((JITDumpStateBuilder.JITLineNumberAddressMap.JITLineNumberAndFile)lineNumberOffset.value).line;
                        continue;
                    }
                    if (!((JITDumpStateBuilder.JITLineNumberAddressMap.JITLineNumberAndFile)lineNumberOffset.value).filename.equals(firstFilename)) continue;
                    lowestLine = Math.min(lowestLine, ((JITDumpStateBuilder.JITLineNumberAddressMap.JITLineNumberAndFile)lineNumberOffset.value).line);
                    highestLine = Math.max(highestLine, ((JITDumpStateBuilder.JITLineNumberAddressMap.JITLineNumberAndFile)lineNumberOffset.value).line);
                }
                this.lowestSourceLine = lowestLine;
                this.highestSourceLine = highestLine;
                this.sourceFile = firstFilename != null ? (SourcefileRecord)NullChecking.neverNull((Object)this.sourceFiles.get(firstFilename)) : null;
            } else {
                this.lineNumberOffsets = null;
                this.lowestSourceLine = 0;
                this.highestSourceLine = 0;
                this.sourceFile = null;
                this.sourceFiles = Collections.emptyMap();
            }
        }
    }

    private static final class ThumbInstructionLengthProvider
    implements IInstructionLengthProvider {
        private final int @NonNull [] instructionLengths;
        private final int @NonNull [] instructionOffsets;

        private static int @NonNull [] calculateOffsets(int @NonNull [] instructionLengths) {
            int @NonNull [] result = new int[instructionLengths.length];
            int total = 0;
            int i = 0;
            while (i < result.length) {
                result[i] = total;
                total += instructionLengths[i];
                ++i;
            }
            return result;
        }

        public ThumbInstructionLengthProvider(int @NonNull [] instructionLengths) {
            this.instructionLengths = instructionLengths;
            this.instructionOffsets = ThumbInstructionLengthProvider.calculateOffsets(instructionLengths);
        }

        @Override
        public int getInstructionCount() {
            return this.instructionLengths.length;
        }

        @Override
        public int getInstructionLength(int index) {
            return this.instructionLengths[index];
        }

        @Override
        public int getInstructionOffset(int index) {
            return this.instructionOffsets[index];
        }
    }
}

