/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.profile;

import com.arm.streamline.analysis.processor.profile.JITDumpParser;
import com.arm.streamline.analysis.processor.profile.JITDumpParserException;
import com.arm.streamline.analysis.processor.profile.Messages;
import com.arm.streamline.common.analysis.session.AddressMap64;
import com.arm.utils.numbers.UnsignedLong;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class JITDumpStateBuilder {
    protected final @NonNull JITLineNumberAddressMap debugInfoMap = new JITLineNumberAddressMap();
    protected final @NonNull JITDumpParser.JITDump.JITDumpHeader header;
    protected final @NonNull File jitdumpFile;
    protected final @NonNull TLongObjectMap<JITCode> loadRecords = new TLongObjectHashMap();
    protected final @NonNull ProcessTimestampStateMap processTimestampStateMap = new ProcessTimestampStateMap();
    private long lastTimestamp = 0L;
    private final @NonNull JITDumpParser.JITDump.IJITDumpRecordVisitor<Void, Void, JITDumpParserException> visitor = new JITDumpParser.JITDump.IJITDumpRecordVisitor<Void, Void, JITDumpParserException>(){

        @Override
        public Void visit(@NonNull JITDumpParser.JITDump.JITDumpRecordClose record, Void data) throws JITDumpParserException {
            return null;
        }

        @Override
        public Void visit(@NonNull JITDumpParser.JITDump.JITDumpRecordDebugInfo record, Void data) throws JITDumpParserException {
            @NonNull List<@NonNull JITDumpParser.JITDump.JITDumpRecordDebugInfo.Entry> entries = record.getEntries();
            if (!entries.isEmpty()) {
                long minAddress = -1L;
                long maxAddress = 0L;
                for (JITDumpParser.JITDump.JITDumpRecordDebugInfo.Entry entry : entries) {
                    minAddress = UnsignedLong.min((long)minAddress, (long)entry.codeAddr);
                    maxAddress = UnsignedLong.max((long)maxAddress, (long)entry.codeAddr);
                }
                JITDumpStateBuilder.this.debugInfoMap.clear(minAddress, maxAddress);
                for (JITDumpParser.JITDump.JITDumpRecordDebugInfo.Entry entry : entries) {
                    JITDumpStateBuilder.this.debugInfoMap.put(record.codeAddr, entry.codeAddr, entry.name, entry.line);
                }
            }
            return null;
        }

        @Override
        public Void visit(@NonNull JITDumpParser.JITDump.JITDumpRecordLoad record, Void data) throws JITDumpParserException {
            JITCode code = new JITCode(JITDumpStateBuilder.this.jitdumpFile, JITDumpStateBuilder.this.header, record, JITDumpStateBuilder.this.debugInfoMap.findAllOverRange(record.codeAddr, record.codeSize));
            JITDumpStateBuilder.this.loadRecords.put(record.codeIndex, (Object)code);
            JITDumpStateBuilder.this.processTimestampStateMap.load(record.pid, record.timestamp, code);
            return null;
        }

        @Override
        public Void visit(@NonNull JITDumpParser.JITDump.JITDumpRecordMove record, Void data) throws JITDumpParserException {
            @Nullable JITCode code = (JITCode)JITDumpStateBuilder.this.loadRecords.get(record.codeIndex);
            if (code == null) {
                throw new JITDumpParserException(Messages.JITDumpParserException_MISSING_LOAD);
            }
            if ((long)code.loadRecord.codeSize != record.codeSize) {
                throw new JITDumpParserException(Messages.JITDumpParserException_INVALID_RECORD_HEADER);
            }
            JITDumpStateBuilder.this.processTimestampStateMap.move(record.pid, record.timestamp, code, record.oldCodeAddr, record.newCodeAddr);
            return null;
        }

        @Override
        public Void visit(@NonNull JITDumpParser.JITDump.JITDumpRecordUnwindingInfo record, Void data) throws JITDumpParserException {
            return null;
        }
    };

    public JITDumpStateBuilder(@NonNull File jitdumpFile, @NonNull JITDumpParser.JITDump.JITDumpHeader header) {
        this.jitdumpFile = jitdumpFile;
        this.header = header;
    }

    public @NonNull JITDumpState getState() {
        return new JITDumpState(this.header, this.processTimestampStateMap);
    }

    public @Nullable JITCodeMapping mapAddress(int pid, long timestamp, long address) {
        return this.processTimestampStateMap.mapAddress(pid, timestamp, address);
    }

    public void processRecord(@NonNull JITDumpParser.JITDump.JITDumpRecord record) throws JITDumpParserException {
        this.validateTimestamp(record.timestamp);
        record.accept(this.visitor, null);
    }

    private void validateTimestamp(long timestamp) throws JITDumpParserException {
        if (UnsignedLong.compare((long)timestamp, (long)this.lastTimestamp) < 0) {
            throw new JITDumpParserException(Messages.JITDumpParserException_OUT_OF_ORDER_TIMESTAMPS);
        }
        this.lastTimestamp = timestamp;
    }

    public static final class JITCode {
        public final @NonNull JITDumpParser.JITDump.JITDumpHeader header;
        public final @NonNull File jitdumpFile;
        public final @Nullable AddressMap64<@NonNull JITLineNumberAddressMap.JITLineNumberAndFile> lineNumberOffsets;
        public final @NonNull JITDumpParser.JITDump.JITDumpRecordLoad loadRecord;

        public JITCode(@NonNull File jitdumpFile, @NonNull JITDumpParser.JITDump.JITDumpHeader header, @NonNull JITDumpParser.JITDump.JITDumpRecordLoad loadRecord, @Nullable AddressMap64<@NonNull JITLineNumberAddressMap.JITLineNumberAndFile> lineNumberOffsets) {
            this.jitdumpFile = jitdumpFile;
            this.header = header;
            this.loadRecord = loadRecord;
            this.lineNumberOffsets = lineNumberOffsets;
        }
    }

    public static final class JITCodeMapping {
        public final long address;
        public final @NonNull JITCode code;
        private final long length;
        private final boolean load;
        private final long oldAddress;
        private final @Nullable JITCodeMapping previousState;

        public JITCodeMapping(@Nullable JITCodeMapping previousState, @NonNull JITCode code) {
            this.load = true;
            this.oldAddress = 0L;
            this.previousState = previousState;
            this.code = code;
            this.address = code.loadRecord.codeAddr;
            this.length = code.loadRecord.codeSize;
        }

        public JITCodeMapping(@Nullable JITCodeMapping previousState, @NonNull JITCode code, long oldAddress, long address) {
            this.load = false;
            this.previousState = previousState;
            this.code = code;
            this.oldAddress = oldAddress;
            this.address = address;
            this.length = code.loadRecord.codeSize;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof JITCodeMapping) {
                JITCodeMapping that = (JITCodeMapping)obj;
                return this.load == that.load && this.address == that.address && this.length == that.length && this.oldAddress == that.oldAddress && this.code.equals(that.code);
            }
            return false;
        }

        public int hashCode() {
            return Long.hashCode(this.address) * 31 + Boolean.hashCode(this.load);
        }

        public final @Nullable JITCodeMapping mapAddress(long testAddress) {
            JITCodeMapping previousState;
            long endAddress = this.address + this.length;
            if (UnsignedLong.compare((long)testAddress, (long)this.address) >= 0 && UnsignedLong.compare((long)testAddress, (long)endAddress) < 0) {
                return this;
            }
            if (!this.load) {
                long oldEndAddress = this.oldAddress + this.length;
                if (UnsignedLong.compare((long)testAddress, (long)this.oldAddress) >= 0 && UnsignedLong.compare((long)testAddress, (long)oldEndAddress) < 0) {
                    return null;
                }
            }
            return (previousState = this.previousState) != null ? previousState.mapAddress(testAddress) : null;
        }

        public String toString() {
            if (this.load) {
                return String.format("Load(0x%016x):%s", this.address, this.code.loadRecord);
            }
            return String.format("Move(0x%016x -> 0x%016x):%s", this.oldAddress, this.address, this.code.loadRecord);
        }
    }

    public static final class JITDumpState {
        private final @NonNull JITDumpParser.JITDump.JITDumpHeader header;
        private final @NonNull ProcessTimestampStateMap processTimestampStateMap;

        public JITDumpState(@NonNull JITDumpParser.JITDump.JITDumpHeader header, @NonNull ProcessTimestampStateMap processTimestampStateMap) {
            this.header = header;
            this.processTimestampStateMap = processTimestampStateMap;
        }

        public @NonNull JITDumpParser.JITDump.JITDumpHeader getHeader() {
            return this.header;
        }

        public @Nullable JITCodeMapping mapAddress(int pid, long timestamp, long address) {
            return this.processTimestampStateMap.mapAddress(pid, timestamp, address);
        }
    }

    public static final class JITLineNumberAddressMap {
        private final @NonNull Map<@NonNull JITLineNumberAndFile, @NonNull JITLineNumberAndFile> lnfCache = new HashMap<JITLineNumberAndFile, JITLineNumberAndFile>();
        private final @NonNull AddressMap64<@NonNull JITLineNumberAndFile> map = new AddressMap64();

        public void clear(long minAddress, long maxAddress) {
            this.map.clear(minAddress, maxAddress);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @Nullable AddressMap64<@NonNull JITLineNumberAndFile> findAllOverRange(long baseAddress, int length) {
            @NonNull AddressMap64 result = new AddressMap64();
            long endAddress = baseAddress + Integer.toUnsignedLong(length);
            int fromIndexRaw = this.map.getIndex(baseAddress);
            int fromIndex = fromIndexRaw >= 0 ? fromIndexRaw : -fromIndexRaw - 1;
            int mapSize = this.map.size();
            int index = fromIndex;
            while (index < mapSize) {
                long addressElement = this.map.getAddress(index);
                if (UnsignedLong.compare((long)addressElement, (long)baseAddress) >= 0) {
                    if (UnsignedLong.compare((long)addressElement, (long)endAddress) >= 0) break;
                    @NonNull JITLineNumberAndFile element = (JITLineNumberAndFile)this.map.getElement(index);
                    result.add(addressElement - baseAddress, (Object)element);
                }
                ++index;
            }
            return result.size() > 0 ? result : null;
        }

        public void put(long codeAddr, long address, @NonNull String filename, int line) {
            @NonNull JITLineNumberAndFile lineNumberAndFile = this.lnfCache.computeIfAbsent(new JITLineNumberAndFile(filename, line), lnf -> lnf);
            this.map.add(address, (Object)lineNumberAndFile);
        }

        public static final class JITLineNumberAndFile {
            public final @NonNull String filename;
            public final int line;

            public JITLineNumberAndFile(@NonNull String filename, int line) {
                this.filename = filename;
                this.line = line;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj instanceof JITLineNumberAndFile) {
                    JITLineNumberAndFile that = (JITLineNumberAndFile)obj;
                    return this.line == that.line && this.filename.equals(that.filename);
                }
                return false;
            }

            public int hashCode() {
                return this.filename.hashCode() * 31 + Integer.hashCode(this.line);
            }

            public String toString() {
                return String.format("%s:%d", this.filename, this.line);
            }
        }
    }

    private static final class ProcessTimestampStateMap {
        private final @NonNull TIntObjectMap<TimestampsStateMap> mapByPid = new TIntObjectHashMap();

        public void load(int pid, long timestamp, @NonNull JITCode code) {
            @NonNull TimestampsStateMap mapByTimestamp = this.computeIfAbsent(pid);
            mapByTimestamp.load(timestamp, code);
        }

        public @Nullable JITCodeMapping mapAddress(int pid, long timestamp, long address) {
            @Nullable TimestampsStateMap result = (TimestampsStateMap)this.mapByPid.get(pid);
            if (result == null) {
                return null;
            }
            return result.mapAddress(timestamp, address);
        }

        public void move(int pid, long timestamp, @NonNull JITCode code, long oldAddress, long newAddress) {
            @NonNull TimestampsStateMap mapByTimestamp = this.computeIfAbsent(pid);
            mapByTimestamp.move(timestamp, code, oldAddress, newAddress);
        }

        private @NonNull TimestampsStateMap computeIfAbsent(int pid) {
            TimestampsStateMap result = (TimestampsStateMap)this.mapByPid.get(pid);
            if (result == null) {
                result = new TimestampsStateMap();
                this.mapByPid.put(pid, (Object)result);
            }
            return result;
        }

        public static final class TimestampsStateMap {
            private @Nullable JITCodeMapping currentState;
            private final @NonNull AddressMap64<@NonNull JITCodeMapping> mapByTimestamp = new AddressMap64();

            public void load(long timestamp, @NonNull JITCode code) {
                this.currentState = new JITCodeMapping(this.currentState, code);
                this.mapByTimestamp.add(timestamp, (Object)this.currentState);
            }

            public @Nullable JITCodeMapping mapAddress(long timestamp, long address) {
                @Nullable JITCodeMapping state = (JITCodeMapping)this.mapByTimestamp.findUpto(timestamp);
                if (state == null) {
                    return null;
                }
                return state.mapAddress(address);
            }

            public void move(long timestamp, @NonNull JITCode code, long oldAddress, long newAddress) {
                this.currentState = new JITCodeMapping(this.currentState, code, oldAddress, newAddress);
                this.mapByTimestamp.add(timestamp, (Object)this.currentState);
            }
        }
    }
}

