/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.profile;

import com.arm.streamline.analysis.processor.profile.IInstructionWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.jdt.annotation.NonNull;

public class InstructionWriter
implements IInstructionWriter,
Closeable {
    private final byte @NonNull [] buffer = new byte[20];
    private final @NonNull RandomAccessFile output;

    public InstructionWriter(@NonNull File file, boolean truncate) throws IOException {
        this.output = new RandomAccessFile(file, "rw");
        if (truncate) {
            this.output.getChannel().truncate(0L);
        }
    }

    @Override
    public void writeInstruction(int index, long address, int opcode, int fileID, int line, boolean thumb, boolean thumbEE, boolean halfword, boolean aarch64, boolean inline, boolean script) throws IOException {
        int value = fileID;
        if (thumb) {
            value |= 0x4000000;
        }
        if (thumbEE) {
            value |= 0x8000000;
        }
        if (halfword) {
            value |= 0x10000000;
        }
        if (aarch64) {
            value |= 0x40000000;
        }
        if (inline) {
            value |= 0x20000000;
        }
        if (script) {
            value |= Integer.MIN_VALUE;
        }
        InstructionWriter.bufferPack(this.buffer, address, opcode, value, line);
        this.output.seek(index * this.buffer.length);
        this.output.write(this.buffer, 0, this.buffer.length);
    }

    @Override
    public void writeFunctionMarker(int index, int functionID, boolean script) throws IOException {
        InstructionWriter.bufferPack(this.buffer, functionID, 0, 0x1000000 | (script ? Integer.MIN_VALUE : 0), 0);
        this.output.seek(index * this.buffer.length);
        this.output.write(this.buffer, 0, this.buffer.length);
    }

    @Override
    public void writeBreakMarker(int index, int breakSize) throws IOException {
        InstructionWriter.bufferPack(this.buffer, breakSize, 0, 0x2000000, 0);
        this.output.seek(index * this.buffer.length);
        this.output.write(this.buffer, 0, this.buffer.length);
    }

    private static void bufferPack(byte @NonNull [] buffer, long a, int b, int c, int d) {
        buffer[0] = (byte)a;
        buffer[1] = (byte)(a >> 8);
        buffer[2] = (byte)(a >> 16);
        buffer[3] = (byte)(a >> 24);
        buffer[4] = (byte)(a >> 32);
        buffer[5] = (byte)(a >> 40);
        buffer[6] = (byte)(a >> 48);
        buffer[7] = (byte)(a >> 56);
        buffer[8] = (byte)b;
        buffer[9] = (byte)(b >> 8);
        buffer[10] = (byte)(b >> 16);
        buffer[11] = (byte)(b >> 24);
        buffer[12] = (byte)c;
        buffer[13] = (byte)(c >> 8);
        buffer[14] = (byte)(c >> 16);
        buffer[15] = (byte)(c >> 24);
        buffer[16] = (byte)d;
        buffer[17] = (byte)(d >> 8);
        buffer[18] = (byte)(d >> 16);
        buffer[19] = (byte)(d >> 24);
    }

    @Override
    public void close() throws IOException {
        this.output.close();
    }
}

