/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.profile;

import com.arm.streamline.analysis.processor.profile.IInstructionReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class InstructionReader
implements IInstructionReader,
AutoCloseable {
    private static final @NonNull IInstructionReader.InstructionReaderEntry UNKNOWN_FUNCTION = new IInstructionReader.InstructionReaderEntry(0, IInstructionReader.InstructionReaderEntry.Type.MARKER, 0L, 0, 0, 0, 0);
    private final byte[] buffer = new byte[20];
    private @Nullable IInstructionReader.InstructionReaderEntry lastEntry;
    private @Nullable RandomAccessFile mInstructionsBIN;

    public InstructionReader(String output) throws FileNotFoundException {
        this.mInstructionsBIN = new RandomAccessFile(new File(output + "/icounter/instructions.bin"), "r");
    }

    @Override
    public void close() throws IOException {
        @Nullable RandomAccessFile mInstructionsBIN = this.mInstructionsBIN;
        if (mInstructionsBIN != null) {
            this.mInstructionsBIN = null;
            mInstructionsBIN.close();
        }
    }

    @Override
    public @NonNull IInstructionReader.InstructionReaderEntry get(int index) throws IOException {
        @Nullable RandomAccessFile mInstructionsBIN = this.mInstructionsBIN;
        @Nullable IInstructionReader.InstructionReaderEntry lastEntry = this.lastEntry;
        if (mInstructionsBIN == null) {
            throw new AssertionError();
        }
        if (index == 0) {
            return UNKNOWN_FUNCTION;
        }
        if (lastEntry == null || lastEntry.index != index) {
            IInstructionReader.InstructionReaderEntry result;
            int instructionLength;
            IInstructionReader.InstructionReaderEntry.Type type;
            boolean thumb16;
            long pos = Integer.toUnsignedLong(index) * 20L;
            mInstructionsBIN.seek(pos);
            mInstructionsBIN.readFully(this.buffer);
            long address = (long)this.buffer[0] & 0xFFL | ((long)this.buffer[1] & 0xFFL) << 8 | ((long)this.buffer[2] & 0xFFL) << 16 | ((long)this.buffer[3] & 0xFFL) << 24 | ((long)this.buffer[4] & 0xFFL) << 32 | ((long)this.buffer[5] & 0xFFL) << 40 | ((long)this.buffer[6] & 0xFFL) << 48 | ((long)this.buffer[7] & 0xFFL) << 56;
            int opcode = this.buffer[8] & 0xFF | (this.buffer[9] & 0xFF) << 8 | (this.buffer[10] & 0xFF) << 16 | (this.buffer[11] & 0xFF) << 24;
            int sourceFile = this.buffer[12] & 0xFF | (this.buffer[13] & 0xFF) << 8 | (this.buffer[14] & 0xFF) << 16;
            int info = (this.buffer[15] & 0xFF) << 24;
            int sourceLine = this.buffer[16] & 0xFF | (this.buffer[17] & 0xFF) << 8 | (this.buffer[18] & 0xFF) << 16 | (this.buffer[19] & 0xFF) << 24;
            boolean marker = (info & 0x3000000) != 0;
            boolean oban = (info & 0x40000000) != 0;
            boolean thumb = (info & 0xC000000) != 0;
            boolean bl = thumb16 = (info & 0x10000000) != 0;
            IInstructionReader.InstructionReaderEntry.Type type2 = marker ? IInstructionReader.InstructionReaderEntry.Type.MARKER : (oban ? IInstructionReader.InstructionReaderEntry.Type.A64 : (type = thumb ? IInstructionReader.InstructionReaderEntry.Type.T32 : IInstructionReader.InstructionReaderEntry.Type.A32));
            int n = marker ? 0 : (instructionLength = thumb16 ? 2 : 4);
            if (thumb16 && (oban || !thumb)) {
                throw new AssertionError();
            }
            this.lastEntry = result = new IInstructionReader.InstructionReaderEntry(index, type, address, opcode, instructionLength, sourceFile, sourceLine);
            return result;
        }
        return lastEntry;
    }
}

