/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.annotate;

import com.arm.streamline.analysis.AnalysisMessages;
import com.arm.streamline.common.analysis.IAnalysisHandler;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.common.model.warnings.WarningSeverity;
import com.arm.streamline.common.model.warnings.WarningType;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.utility.io.ImageUtils;
import com.arm.streamline.utility.ui.StreamlineUIUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.channels.ClosedByInterruptException;
import java.util.zip.GZIPInputStream;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class AnnotateVisualWorker
implements Runnable {
    private IAnalysisHandler mHandler;
    private String mImageName;
    private String mPath;
    private boolean mCompressed;

    public AnnotateVisualWorker(String path, String imageName, boolean compressed, IAnalysisHandler handler) {
        this.mHandler = handler;
        this.mImageName = imageName;
        this.mPath = path;
        this.mCompressed = compressed;
    }

    @Override
    public void run() {
        Image img = null;
        Image dst = null;
        try {
            String path = this.mPath + "/images/" + this.mImageName;
            File file = new File(path);
            if (!this.mCompressed) {
                if (!file.exists()) {
                    WarningItem item = new WarningItem(WarningType.ANNOTATE, WarningSeverity.LOW, AnalysisMessages.IMAGE_NOT_FOUND, path);
                    this.mHandler.warning(item);
                    return;
                }
            } else {
                String zipPath = path + ".gz";
                File zipFile = new File(zipPath);
                if (!zipFile.exists()) {
                    WarningItem item = new WarningItem(WarningType.ANNOTATE, WarningSeverity.LOW, AnalysisMessages.IMAGE_NOT_FOUND, zipPath);
                    this.mHandler.warning(item);
                    return;
                }
                Throwable item = null;
                Object var8_15 = null;
                try (GZIPInputStream zipped = new GZIPInputStream(new BufferedInputStream(new FileInputStream(zipPath)));){
                    Throwable throwable = null;
                    Object var11_23 = null;
                    try (FileOutputStream unzipped = new FileOutputStream(path);){
                        int len;
                        byte[] buf = new byte[4096];
                        while ((len = zipped.read(buf)) > 0) {
                            unzipped.write(buf, 0, len);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    if (item == null) {
                        item = throwable;
                    } else if (item != throwable) {
                        item.addSuppressed(throwable);
                    }
                    throw item;
                }
            }
            if ((img = ImageUtils.load(path)) == null) {
                WarningItem item = new WarningItem(WarningType.ANNOTATE, WarningSeverity.LOW, AnalysisMessages.IMAGE_NOT_FOUND, path);
                this.mHandler.warning(item);
                return;
            }
            try {
                ImageData image = img.getImageData();
                int width = image.width;
                int height = image.height;
                int annotationBlankImageWidth = StreamlineUIUtils.getAnnotationBlankImageWidth();
                int annotationBlankImageHeight = StreamlineUIUtils.getAnnotationBlankImageHeight();
                float w_scale = (float)annotationBlankImageWidth / (float)width;
                float h_scale = (float)annotationBlankImageHeight / (float)height;
                float scale = w_scale < h_scale ? w_scale : h_scale;
                int w_size = (int)((float)width * scale);
                int h_size = (int)((float)height * scale);
                int w_pos = (annotationBlankImageWidth - w_size) / 2;
                int h_pos = (annotationBlankImageHeight - h_size) / 2;
                Rectangle r = new Rectangle(0, 0, annotationBlankImageWidth, annotationBlankImageHeight);
                dst = new Image(null, r);
                GC gc = new GC((Drawable)dst);
                Color color = new Color(gc.getDevice(), new RGB(0, 0, 0));
                gc.setBackground(color);
                gc.fillRectangle(r);
                gc.drawImage(img, 0, 0, width, height, w_pos, h_pos, w_size, h_size);
                gc.dispose();
                color.dispose();
                img.dispose();
                img = null;
                ImageLoader loader = new ImageLoader();
                loader.data = new ImageData[]{dst.getImageData()};
                loader.save(this.mPath + "/thumbnails/" + FilePath.enforceExtension((String)this.mImageName, (String)".png", (boolean)true), 5);
            }
            catch (ClosedByInterruptException e) {
                this.mHandler.cancel();
            }
            catch (Exception e) {
                this.mHandler.error((Throwable)e);
            }
        }
        finally {
            if (img != null) {
                img.dispose();
            }
            if (dst != null) {
                dst.dispose();
            }
        }
    }
}

