/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model;

import com.arm.streamline.analysis.AnalysisBase;
import com.arm.streamline.analysis.model.SourcefileRecord;
import com.arm.streamline.analysis.model.SourcefileRecordList;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.utils.NullChecking;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.IntSupplier;
import org.eclipse.jdt.annotation.NonNull;

public final class XmlSourcefileRecordList
implements SourcefileRecordList {
    private static final String TAG_SOURCES = "sources";
    private static final String TAG_SOURCE = "source";
    private static final String ATTR_MODIFIED = "modified";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_UID = "uid";
    private final @NonNull TLongObjectMap<@NonNull SourcefileRecord> sourceFileRecords;
    private final @NonNull List<@NonNull SourcefileRecord> sourceFileRecordsList;

    public XmlSourcefileRecordList(@NonNull IntSupplier globalIdSupplier, @NonNull File captureDir, @NonNull File inputPath) throws IOException, InterruptedException {
        block9: {
            this.sourceFileRecords = new TLongObjectHashMap(10, 0.5f, 0L);
            XMLParser in = null;
            try {
                try {
                    String tag;
                    in = XMLParser.create((File)new File(inputPath, "sources.xml"));
                    while ((tag = in.nextTag()) != null) {
                        AnalysisBase.checkInterrupted();
                        if (!TAG_SOURCES.equals(tag)) continue;
                        long created = in.getLongAttribute(ATTR_MODIFIED, 0L);
                        String imagePath = (String)NullChecking.neverNull((Object)in.getAttribute(ATTR_PATH));
                        this.sourceFileRecords.put(0L, (Object)new SourcefileRecord(globalIdSupplier.getAsInt(), SourcefileRecordList.normalizeSourcePath(captureDir, imagePath), created));
                        String marker = in.getMarker();
                        while ((tag = in.nextTag(marker)) != null) {
                            AnalysisBase.checkInterrupted();
                            if (TAG_SOURCE.equals(tag)) {
                                String sourcePath = (String)NullChecking.neverNull((Object)in.getAttribute(ATTR_PATH));
                                int uid = in.getIntegerAttribute(ATTR_UID);
                                assert (uid != 0);
                                this.sourceFileRecords.put((long)uid, (Object)new SourcefileRecord(globalIdSupplier.getAsInt(), SourcefileRecordList.normalizeSourcePath(captureDir, sourcePath)));
                            }
                            in.skip();
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    CommonFileUtils.ignoredClose(in);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                CommonFileUtils.ignoredClose(in);
                throw throwable;
            }
            CommonFileUtils.ignoredClose((Closeable)in);
        }
        this.sourceFileRecordsList = new ArrayList<SourcefileRecord>(this.sourceFileRecords.valueCollection());
        this.sourceFileRecordsList.sort(Comparator.comparing(SourcefileRecord::getId));
    }

    public @NonNull SourcefileRecord getByImageUID(long uid) {
        return (SourcefileRecord)NullChecking.neverNull((Object)((SourcefileRecord)this.sourceFileRecords.get(uid)));
    }

    @Override
    public @NonNull List<@NonNull SourcefileRecord> getList() {
        return Collections.unmodifiableList(this.sourceFileRecordsList);
    }
}

