/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model;

import com.arm.streamline.analysis.model.KernelSymbol;
import com.arm.streamline.common.analysis.session.AddressMap64;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public final class ProfilerKernelModule {
    public static final @NonNull String VMLINUX_MODULE_NAME = "";
    public final @NonNull String name;
    public final @NonNull AddressMap64<@NonNull List<@NonNull ProfilerKernelModuleSymbol>> symbols;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull TLongObjectMap<Map<@NonNull String, @NonNull ProfilerKernelModule>> buildKernelSymbolLookup(@NonNull TLongObjectMap<List<@NonNull KernelSymbol>> kernelSymbols) {
        @NonNull @NonNull @NonNull TLongObjectHashMap result = new TLongObjectHashMap();
        @NonNull TLongObjectIterator it = kernelSymbols.iterator();
        while (it.hasNext()) {
            it.advance();
            long vmUID = it.key();
            @NonNull List symbols = (List)it.value();
            HashMap<@NonNull String, @NonNull @NonNull List> symbolsByModule = new HashMap<String, List>();
            for (KernelSymbol symbol : symbols) {
                if (symbol.type != 't' && symbol.type != 'T' && symbol.type != 'w' && symbol.type != 'W') continue;
                @NonNull @NonNull List moduleSymbols = symbolsByModule.computeIfAbsent(symbol.module, m -> new ArrayList());
                moduleSymbols.add(symbol);
            }
            if (symbolsByModule.isEmpty()) continue;
            @NonNull HashMap<@NonNull String, @NonNull ProfilerKernelModule> mappedModules = new HashMap<String, ProfilerKernelModule>();
            result.put(vmUID, mappedModules);
            for (Map.Entry entry : symbolsByModule.entrySet()) {
                @NonNull String module = (String)entry.getKey();
                @NonNull @NonNull List moduleSymbols = (List)entry.getValue();
                assert (!moduleSymbols.isEmpty());
                @NonNull TObjectIntHashMap indexesByName = new TObjectIntHashMap(10, 0.5f, 0);
                moduleSymbols.sort(Comparator.naturalOrder());
                @NonNull ProfilerKernelModule mappedModule = new ProfilerKernelModule(module);
                mappedModules.put(module, mappedModule);
                @NonNull ArrayList<@NonNull ProfilerKernelModuleSymbol> tempSymbols = new ArrayList<ProfilerKernelModuleSymbol>();
                for (KernelSymbol symbol : moduleSymbols) {
                    int indexByName = indexesByName.adjustOrPutValue((Object)symbol.symbol, 1, 0);
                    tempSymbols.add(new ProfilerKernelModuleSymbol(symbol.symbol, indexByName, -1, symbol.address));
                }
                tempSymbols.stream().map(arg_0 -> ProfilerKernelModule.lambda$1((TObjectIntMap)indexesByName, arg_0)).forEach(mappedModule::add);
            }
        }
        return result;
    }

    public ProfilerKernelModule(@NonNull String name) {
        this.name = name;
        this.symbols = new AddressMap64();
    }

    public String toString() {
        return String.format("ProfilerKernelModule [name=%s]", this.name);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void add(@NonNull ProfilerKernelModuleSymbol symbol) {
        @NonNull @NonNull List list = (List)this.symbols.computeIfAbsent(symbol.address, a -> new ArrayList());
        list.add(symbol);
    }

    private static /* synthetic */ ProfilerKernelModuleSymbol lambda$1(TObjectIntMap tObjectIntMap, ProfilerKernelModuleSymbol n) {
        return n.fix(tObjectIntMap.get((Object)n.name) + 1);
    }

    public static final class ProfilerKernelModuleSymbol {
        public final long address;
        public final int indexByName;
        public final @NonNull String name;
        public final int totalNumIndexes;

        public ProfilerKernelModuleSymbol(@NonNull String name, int indexByName, int totalNumIndexes, long address) {
            assert (indexByName >= 0);
            assert (indexByName < totalNumIndexes || totalNumIndexes < 0);
            this.name = name;
            this.indexByName = indexByName;
            this.totalNumIndexes = totalNumIndexes;
            this.address = address;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProfilerKernelModuleSymbol) {
                ProfilerKernelModuleSymbol that = (ProfilerKernelModuleSymbol)obj;
                return this.indexByName == that.indexByName && this.totalNumIndexes == that.totalNumIndexes && this.address == that.address && this.name.contentEquals(that.name);
            }
            return false;
        }

        public int hashCode() {
            return ((this.name.hashCode() * 31 + this.indexByName) * 31 * 31 + this.totalNumIndexes) * 31 + Long.hashCode(this.address);
        }

        public String toString() {
            return String.format("ProfilerKernelModuleSymbol [name=%s, indexByName=%d/%d, address=0x%016x]", this.name, this.indexByName, this.totalNumIndexes, this.address);
        }

        protected final @NonNull ProfilerKernelModuleSymbol fix(int totalNumIndexes) {
            assert (this.totalNumIndexes < 0);
            return new ProfilerKernelModuleSymbol(this.name, this.indexByName, totalNumIndexes, this.address);
        }
    }
}

