/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model;

import com.arm.streamline.analysis.model.FunctionRecord;
import com.arm.streamline.analysis.model.InstructionRecord;
import com.arm.streamline.analysis.model.SourcefileRecord;
import com.arm.streamline.analysis.processor.profile.IInstructionWriter;
import com.arm.utils.NullChecking;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class InstructionRecordMap {
    private final @Nullable IInstructionWriter mOutput;
    private int mSize;
    private final @NonNull Map<@NonNull SourcefileRecord, @NonNull TIntIntMap> mSourcelineFunctions = new HashMap<SourcefileRecord, TIntIntMap>();
    private final @NonNull List<@NonNull InstructionRecord> mInstructionList;
    private @Nullable FunctionRecord mFunctionRecord;
    private int mCount;
    private final @NonNull IntSupplier idSupplier;

    private static void writeInstructionsBIN(@NonNull IInstructionWriter output, @NonNull List<@NonNull InstructionRecord> ira) throws IOException {
        for (InstructionRecord ir : ira) {
            if (ir.isInstruction()) {
                @NonNull SourcefileRecord sfr = (SourcefileRecord)NullChecking.neverNull((Object)ir.getSourcefile());
                long address = ir.getAddress();
                int opcode = ir.getOpcode();
                int fileID = sfr.getId();
                int line = ir.getSourceline();
                output.writeInstruction(ir.getIndex(), address, opcode, fileID, line, ir.isThumb(), ir.isThumbEE(), !ir.is32Bit(), ir.isArch64(), ir.isInlined(), false);
                continue;
            }
            if (ir.isFunctionMarker()) {
                output.writeFunctionMarker(ir.getIndex(), ir.getFunctionID(), false);
                continue;
            }
            if (ir.isBreakMarker()) {
                output.writeBreakMarker(ir.getIndex(), ir.getBreakSize());
                continue;
            }
            throw new IOException("EngineModel write instructions.bin failed on unknown type");
        }
    }

    public InstructionRecordMap(@NonNull IntSupplier idSupplier) {
        this.idSupplier = idSupplier;
        this.mOutput = null;
        this.mInstructionList = new ArrayList<InstructionRecord>();
        this.mFunctionRecord = new FunctionRecord();
        this.mCount = 0;
    }

    public InstructionRecordMap(@NonNull IInstructionWriter output, @NonNull IntSupplier idSupplier) {
        this.idSupplier = idSupplier;
        this.mOutput = output;
        this.mInstructionList = new ArrayList<InstructionRecord>();
        this.mFunctionRecord = new FunctionRecord();
        this.mCount = 0;
    }

    public void addBreak(int size) throws IOException {
        InstructionRecord ir = InstructionRecord.createBreakMarker(this.idSupplier, size);
        this.addInstruction(ir);
    }

    public void addFunction(@NonNull FunctionRecord functionRecord) throws IOException {
        this.mFunctionRecord = functionRecord;
        InstructionRecord ir = InstructionRecord.createFunctionMarker(this.idSupplier, functionRecord.getID());
        this.addInstruction(ir);
    }

    public void addInstruction(long address, int opcode, @NonNull SourcefileRecord sourceFile, int sourceLine, boolean isThumb, boolean is32Bit, boolean isArch64, boolean isInlined) throws IOException {
        @Nullable FunctionRecord mFunctionRecord = this.mFunctionRecord;
        assert (mFunctionRecord != null);
        InstructionRecord ir = new InstructionRecord(this.idSupplier, address, opcode, sourceFile, sourceLine, isThumb, is32Bit, isArch64, isInlined);
        this.add(sourceFile, sourceLine, mFunctionRecord.getID(), isInlined);
        this.addInstruction(ir);
    }

    public @NonNull Map<@NonNull SourcefileRecord, @NonNull TIntIntMap> finished() throws IOException {
        this.flushRecords();
        return this.mSourcelineFunctions;
    }

    public int size() {
        return this.mSize;
    }

    private void add(@NonNull SourcefileRecord sfr, int line, int function, boolean inlined) {
        @NonNull TIntIntMap sourcelineFunctions = this.mSourcelineFunctions.computeIfAbsent(sfr, ignored -> new TIntIntHashMap());
        if (inlined) {
            function |= 0x1000000;
        }
        sourcelineFunctions.put(line, function);
    }

    private void addInstruction(@NonNull InstructionRecord ir) throws IOException {
        @Nullable FunctionRecord mFunctionRecord = this.mFunctionRecord;
        assert (mFunctionRecord != null);
        mFunctionRecord.addInstruction(ir.getIndex(), ir.isInlined(), ir.getSourcefile(), ir.getSourceline());
        this.mInstructionList.add(ir);
        ++this.mCount;
        ++this.mSize;
        this.checkRecords();
    }

    private void checkRecords() throws IOException {
        if (this.mCount >= 10000) {
            this.flushRecords();
        }
    }

    private void flushRecords() throws IOException {
        @Nullable IInstructionWriter mOutput = this.mOutput;
        if (this.mCount > 0 && mOutput != null) {
            this.mCount = 0;
            InstructionRecordMap.writeInstructionsBIN(mOutput, this.mInstructionList);
            this.mInstructionList.clear();
        }
    }
}

