/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model;

import com.arm.streamline.analysis.model.SourcefileRecord;
import java.util.function.IntSupplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class InstructionRecord {
    private final int mIndex;
    private final long mAddress;
    private final int mOpcode;
    private final @Nullable SourcefileRecord mSourcefile;
    private final int mSourceline;
    private final boolean mIsFunctionMarker;
    private final boolean mIsBreakMarker;
    private final boolean mIsThumb;
    private final boolean mIsThumbEE;
    private final boolean mIs32Bit;
    private final boolean mIsArch64;
    private final boolean mIsInlined;

    public static @NonNull InstructionRecord createBreakMarker(@NonNull IntSupplier idSupplier, int size) {
        return new InstructionRecord(idSupplier, false, size);
    }

    public static @NonNull InstructionRecord createFunctionMarker(@NonNull IntSupplier idSupplier, int functionID) {
        return new InstructionRecord(idSupplier, true, functionID);
    }

    public InstructionRecord(@NonNull IntSupplier idSupplier, long address, int opcode, @NonNull SourcefileRecord sourcefile, int sourceline, boolean isThumb, boolean is32Bit, boolean isArch64, boolean isInlined) {
        this.mIndex = idSupplier.getAsInt();
        this.mAddress = address;
        this.mOpcode = opcode;
        this.mSourcefile = sourcefile;
        this.mSourceline = sourceline;
        this.mIsThumb = isThumb;
        this.mIs32Bit = is32Bit;
        this.mIsArch64 = isArch64;
        this.mIsInlined = isInlined;
        this.mIsFunctionMarker = false;
        this.mIsBreakMarker = false;
        this.mIsThumbEE = false;
    }

    private InstructionRecord(@NonNull IntSupplier idSupplier, boolean function, int size) {
        this.mIndex = idSupplier.getAsInt();
        this.mIsFunctionMarker = function;
        this.mIsBreakMarker = !function;
        this.mOpcode = size;
        this.mAddress = 0L;
        this.mSourcefile = null;
        this.mSourceline = 0;
        this.mIsThumb = false;
        this.mIs32Bit = false;
        this.mIsArch64 = false;
        this.mIsInlined = false;
        this.mIsThumbEE = false;
    }

    public long getAddress() {
        return this.mAddress;
    }

    public int getBreakSize() {
        return this.mOpcode;
    }

    public int getFunctionID() {
        return this.mOpcode;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public int getOpcode() {
        return this.mOpcode;
    }

    public @Nullable SourcefileRecord getSourcefile() {
        return this.mSourcefile;
    }

    public int getSourceline() {
        return this.mSourceline;
    }

    public boolean is32Bit() {
        return this.mIs32Bit;
    }

    public boolean isArch64() {
        return this.mIsArch64;
    }

    public boolean isBreakMarker() {
        return this.mIsBreakMarker;
    }

    public boolean isFunctionMarker() {
        return this.mIsFunctionMarker;
    }

    public boolean isInlined() {
        return this.mIsInlined;
    }

    public boolean isInstruction() {
        return !this.mIsFunctionMarker && !this.mIsBreakMarker;
    }

    public boolean isThumb() {
        return this.mIsThumb;
    }

    public boolean isThumbEE() {
        return this.mIsThumbEE;
    }
}

