/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model;

import com.arm.streamline.analysis.elfdwarf.FunctionReader;
import com.arm.streamline.analysis.elfdwarf.IFunctionReaderCallback;
import com.arm.streamline.analysis.model.FunctionRecord;
import com.arm.streamline.analysis.model.IFunctionRecordMap;
import com.arm.streamline.analysis.model.InstructionRecordMap;
import com.arm.streamline.analysis.model.ProfilerKernelModule;
import com.arm.streamline.analysis.model.SourcefileRecord;
import com.arm.streamline.analysis.model.XmlSourcefileRecordList;
import com.arm.streamline.analysis.processor.profile.IInstructionWriter;
import com.arm.streamline.analysis.processor.profile.InstructionWriter;
import com.arm.streamline.common.analysis.session.AddressMap64;
import com.arm.utils.collections.ObjLongPair;
import com.arm.utils.numbers.UnsignedLong;
import gnu.trove.TCollections;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TLongLongMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongLongHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class FunctionRecordMap
implements IFunctionRecordMap {
    private final @NonNull AddressMap64<@NonNull FunctionRecord> functionsByAddress;
    private final @NonNull IntSupplier idSupplier;
    private final @NonNull Map<@NonNull SourcefileRecord, @NonNull TIntIntMap> sourceFileRecordMap;
    private final @NonNull TLongLongMap vmToKAllSymsOffset;
    private final @Nullable SourcefileRecord imageFile;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected static @NonNull TLongLongMap extractKallSymsOffsetMap(@NonNull TLongObjectMap<Map<@NonNull String, @NonNull ProfilerKernelModule>> modules, @NonNull String moduleName, @Nullable Map<@NonNull String, @NonNull List<@NonNull FunctionRecord>> functionsByName) {
        @NonNull TLongLongHashMap vmToKAllSymsOffset = new TLongLongHashMap(10, 0.5f, 0L, 0L);
        if (functionsByName != null) {
            @NonNull @NonNull TLongObjectIterator it = modules.iterator();
            while (it.hasNext()) {
                it.advance();
                long vmUID = it.key();
                @NonNull @NonNull Map modulesByName = (Map)it.value();
                @Nullable ProfilerKernelModule module = (ProfilerKernelModule)modulesByName.get(moduleName);
                if (module == null) continue;
                boolean foundInconsistent = false;
                Long selectedDeltaBetweenSymbolAndFunctionAddress = null;
                for (List aliases : module.symbols.getList()) {
                    for (ProfilerKernelModule.ProfilerKernelModuleSymbol symbol : aliases) {
                        @Nullable List<@NonNull FunctionRecord> matchingFunctions = functionsByName.get(symbol.name);
                        if (matchingFunctions == null || matchingFunctions.size() != symbol.totalNumIndexes) continue;
                        @NonNull FunctionRecord matchingFunction = matchingFunctions.get(symbol.indexByName);
                        long deltaBetweenSymbolAndFunctionAddress = symbol.address - matchingFunction.getStartOffset();
                        if (selectedDeltaBetweenSymbolAndFunctionAddress == null) {
                            selectedDeltaBetweenSymbolAndFunctionAddress = deltaBetweenSymbolAndFunctionAddress;
                            continue;
                        }
                        if (selectedDeltaBetweenSymbolAndFunctionAddress == deltaBetweenSymbolAndFunctionAddress) continue;
                        foundInconsistent = true;
                    }
                }
                if (selectedDeltaBetweenSymbolAndFunctionAddress == null || foundInconsistent) continue;
                vmToKAllSymsOffset.put(vmUID, selectedDeltaBetweenSymbolAndFunctionAddress.longValue());
            }
        }
        @NonNull TLongLongMap umResult = TCollections.unmodifiableMap((TLongLongMap)vmToKAllSymsOffset);
        return umResult;
    }

    public FunctionRecordMap(@NonNull IntSupplier functionIDSupplier) {
        this.idSupplier = functionIDSupplier;
        this.sourceFileRecordMap = Collections.emptyMap();
        this.functionsByAddress = new AddressMap64();
        this.vmToKAllSymsOffset = TCollections.unmodifiableMap((TLongLongMap)new TLongLongHashMap(0, 0.5f, 0L, 0L));
        this.imageFile = null;
    }

    public FunctionRecordMap(@NonNull File inputPath, @NonNull XmlSourcefileRecordList sourcefileList, @NonNull TLongObjectMap<Map<@NonNull String, @NonNull ProfilerKernelModule>> modules, @NonNull String moduleName, @NonNull IntSupplier functionIDSupplier, @NonNull IntSupplier instructionIDSupplier, @NonNull InstructionWriter output) throws IOException, InterruptedException {
        this(inputPath, sourcefileList, modules, moduleName, functionIDSupplier, instructionIDSupplier, (a, b) -> new FunctionReader(a, b).read(), output);
    }

    protected FunctionRecordMap(@NonNull IntSupplier idSupplier, @NonNull Map<@NonNull SourcefileRecord, @NonNull TIntIntMap> sourceFileRecordMap, @NonNull AddressMap64<@NonNull FunctionRecord> functionsByAddress, @NonNull TLongLongMap vmToKAllSymsOffset) {
        this.idSupplier = idSupplier;
        this.sourceFileRecordMap = sourceFileRecordMap;
        this.functionsByAddress = functionsByAddress;
        this.vmToKAllSymsOffset = vmToKAllSymsOffset;
        this.imageFile = null;
    }

    private FunctionRecordMap(@NonNull File inputPath, @NonNull XmlSourcefileRecordList sourcefileList, @NonNull TLongObjectMap<Map<@NonNull String, @NonNull ProfilerKernelModule>> modules, @NonNull String moduleName, @NonNull IntSupplier functionIDSupplier, @NonNull IntSupplier instructionIDSupplier, @NonNull IFunctionReader functionReader, @NonNull IInstructionWriter output) throws IOException, InterruptedException {
        this.imageFile = sourcefileList.getByImageUID(0L);
        Callback callback = new Callback(!modules.isEmpty(), functionIDSupplier, instructionIDSupplier, sourcefileList, this.imageFile, output);
        this.idSupplier = functionIDSupplier;
        this.functionsByAddress = callback.mFunctionsByAddress;
        try {
            functionReader.read(inputPath, callback);
        }
        finally {
            this.sourceFileRecordMap = callback.mInstructionMap.finished();
        }
        this.vmToKAllSymsOffset = FunctionRecordMap.extractKallSymsOffsetMap(modules, moduleName, callback.mFunctionsByName);
    }

    @Override
    public @NonNull FunctionRecord addFunction(long address, long offset, int size, int stack, boolean hasStackFrame, @NonNull String pretty, @NonNull Map<@NonNull String, @Nullable String> aliasNames) {
        FunctionRecord functionRecord = new FunctionRecord(this.idSupplier, address, offset, size, stack, hasStackFrame, pretty, aliasNames, this.imageFile);
        this.addFunctionRecord(offset, functionRecord);
        return functionRecord;
    }

    @Override
    public @Nullable ObjLongPair<@NonNull FunctionRecord> findFunctionByOffset(long vmUID, long offset) {
        FunctionRecord result;
        long adjustedOffset = offset - this.vmToKAllSymsOffset.get(vmUID);
        @Nullable FunctionRecord kallsymsRecord = (FunctionRecord)this.functionsByAddress.findUpto(adjustedOffset);
        if (kallsymsRecord != null && UnsignedLong.compare((long)adjustedOffset, (long)kallsymsRecord.getEndOffset()) < 0) {
            return new ObjLongPair((Object)kallsymsRecord, adjustedOffset);
        }
        if (adjustedOffset != offset && (result = (FunctionRecord)this.functionsByAddress.findUpto(offset)) != null && UnsignedLong.compare((long)offset, (long)result.getEndOffset()) < 0) {
            return new ObjLongPair((Object)result, offset);
        }
        return null;
    }

    @Override
    public @NonNull List<@NonNull FunctionRecord> getList() {
        return this.functionsByAddress.getList();
    }

    @Override
    public @Nullable TIntIntMap getSourcelineFunctions(@NonNull SourcefileRecord sfr) {
        return this.sourceFileRecordMap.get(sfr);
    }

    private void addFunctionRecord(long offset, @NonNull FunctionRecord functionRecord) {
        while (this.functionsByAddress.findAt(offset) != null) {
            ++offset;
        }
        this.functionsByAddress.add(offset, (Object)functionRecord);
    }

    private static final class Callback
    implements IFunctionReaderCallback {
        protected final @NonNull IntSupplier mFunctionIDSupplier;
        protected final @NonNull AddressMap64<@NonNull FunctionRecord> mFunctionsByAddress = new AddressMap64();
        protected final @Nullable Map<@NonNull String, @NonNull List<@NonNull FunctionRecord>> mFunctionsByName;
        protected final InstructionRecordMap mInstructionMap;
        protected final @NonNull XmlSourcefileRecordList mSourcefileList;
        protected final @Nullable SourcefileRecord mImageFile;

        public Callback(boolean buildNameMap, @NonNull IntSupplier functionIDSupplier, @NonNull IntSupplier instructionIDSupplier, @NonNull XmlSourcefileRecordList sourcefileList, @Nullable SourcefileRecord imageFile, @NonNull IInstructionWriter output) {
            this.mFunctionIDSupplier = functionIDSupplier;
            this.mInstructionMap = new InstructionRecordMap(output, instructionIDSupplier);
            this.mSourcefileList = sourcefileList;
            this.mFunctionsByName = buildNameMap ? new HashMap() : null;
            this.mImageFile = imageFile;
        }

        @Override
        public void addBreak(long size) throws IOException {
            this.mInstructionMap.addBreak((int)size);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public void addFunction(long address, long offset, long size, int stack, boolean hasStackFrame, @NonNull String name, @Nullable String unmangled, @NonNull Map<@NonNull String, @Nullable String> aliasNames) throws IOException {
            @Nullable Map<@NonNull String, @NonNull List<@NonNull FunctionRecord>> mFunctionsByName = this.mFunctionsByName;
            @NonNull String pretty = unmangled != null && !unmangled.isEmpty() && !unmangled.equals("\r") ? unmangled : name;
            @NonNull FunctionRecord functionRecord = new FunctionRecord(this.mFunctionIDSupplier, address, offset, (int)size, stack, hasStackFrame, pretty, aliasNames, this.mImageFile);
            if (mFunctionsByName != null) {
                @NonNull HashSet<@NonNull String> allNames = new HashSet<String>(aliasNames.keySet());
                allNames.add(name);
                for (String alias : allNames) {
                    @NonNull @NonNull List list = mFunctionsByName.computeIfAbsent(alias, n -> new ArrayList());
                    list.add(functionRecord);
                }
            }
            this.mFunctionsByAddress.add(offset, (Object)functionRecord);
            this.mInstructionMap.addFunction(functionRecord);
        }

        @Override
        public void addInstruction(long address, int opcode, long sourceFileUID, int sourceLine, boolean isThumb, boolean is32Bit, boolean isArch64, boolean isInlined) throws IOException {
            this.mInstructionMap.addInstruction(address, opcode, this.mSourcefileList.getByImageUID(sourceFileUID), sourceLine, isThumb, is32Bit, isArch64, isInlined);
        }
    }

    @FunctionalInterface
    public static interface IFunctionReader {
        public void read(@NonNull File var1, @NonNull IFunctionReaderCallback var2) throws IOException, InterruptedException;
    }
}

