/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model;

import com.arm.streamline.analysis.model.CAMViewData;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.model.cam.CAMMessages;
import com.arm.streamline.model.cam.CAM_Model;
import com.arm.utils.io.FileUtils;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CAMXML {
    private static final String ATTR_CLIPPED_DEPENDENCY_CHAIN = "clipped-dependency-chain";
    private static final String ATTR_HOTKEY = "hot-key";
    private static final String ATTR_ICON = "icon";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_ORIGIN_UTID = "origin-utid";
    private static final String ATTR_UID = "uid";
    private static final String ATTR_VMUID = "vmUID";
    private static final String CAM_VIEWS_FILE = "cam.xml";
    private static final int ICON_OPENCL = 1;
    private static final String TAG_CAM = "cam";
    private static final String TAG_VIEWS = "views";

    public static @NonNull TLongObjectMap<TIntObjectMap<CAMViewData>> readCAMXML(@NonNull File dbDirectory) throws IOException {
        return CAMXML.readCAMXML(dbDirectory, (vmUID, viewUID, viewName, icon, hotKey, clipDependencyChain, originUtid) -> new CAMViewData(viewName, icon, hotKey, clipDependencyChain));
    }

    private static @Nullable Integer getOptionalIntegerAttribute(XMLParser in, String attr) {
        if (in.hasAttribute(attr)) {
            return in.getIntegerAttribute(attr);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static <T> @NonNull TLongObjectMap<TIntObjectMap<T>> readCAMXML(@NonNull File dbDirectory, @NonNull ICAMXmlElementFactory<T> factory) throws IOException {
        block13: {
            result = new TLongObjectHashMap();
            camPath = CAM_Model.getCamPath(dbDirectory);
            viewsFile = new File(camPath, "cam.xml");
            leViewsFile = CommonFileUtils.getFile((File)viewsFile);
            if (!leViewsFile.isFile()) break block13;
            var6_6 = null;
            var7_8 = null;
            try {
                in = XMLParser.create((File)leViewsFile);
lbl10:
                // 2 sources

                try {
                    while ((tag = in.nextTag()) != null) {
                        block14: {
                            if (!"cam".equals(tag)) break block14;
                            marker = in.getMarker();
                            while ((tag = in.nextTag(marker)) != null) {
                                if ("views".equals(tag)) {
                                    vmUID = in.getLongAttribute("vmUID", 0L);
                                    viewUID = in.getIntegerAttribute("uid", -1);
                                    viewName = in.getAttribute("name", CAMMessages.UNNAMED_CAM);
                                    icon = in.getIntegerAttribute("icon", 0);
                                    hotkey = in.getAttribute("hot-key", "E");
                                    highlighting = in.hasAttribute("clipped-dependency-chain");
                                    originUtid = CAMXML.getOptionalIntegerAttribute(in, "origin-utid");
                                    perVmViews = (TIntObjectMap)result.get(vmUID);
                                    if (perVmViews == null) {
                                        perVmViews = new TIntObjectHashMap();
                                        result.put(vmUID, (Object)perVmViews);
                                    }
                                    perVmViews.put(viewUID, factory.create(vmUID, viewUID, viewName, icon, hotkey, highlighting, originUtid));
                                    continue;
                                }
                                in.skip();
                            }
                            ** GOTO lbl10
                        }
                        in.skip();
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Throwable var7_9) {
                if (var6_6 == null) {
                    var6_6 = var7_9;
                } else if (var6_6 != var7_9) {
                    var6_6.addSuppressed(var7_9);
                }
                throw var6_6;
            }
        }
        return result;
    }

    public static final class CAMXmlWriter
    implements Closeable {
        private int viewCounter = 0;
        private final @NonNull File viewsFile;
        private final @NonNull XMLGenerator xml;

        public CAMXmlWriter(@NonNull File dbDirectory) throws IOException {
            @NonNull File camPath = CAM_Model.getCamPath(dbDirectory);
            CommonFileUtils.makeDirectory((File)camPath);
            this.viewsFile = new File(camPath, CAMXML.CAM_VIEWS_FILE);
            this.xml = XMLGenerator.create((File)this.viewsFile);
            this.xml.startDocument();
            this.xml.startTag(CAMXML.TAG_CAM);
        }

        @Override
        public void close() throws IOException {
            try {
                this.xml.endTag();
                this.xml.endDocument();
            }
            finally {
                this.xml.close();
                if (this.viewCounter == 0) {
                    FileUtils.delete((File)this.viewsFile);
                }
            }
        }

        public void write(long vmUID, int viewUID, @NonNull String name, @Nullable Integer originUtid) throws IOException {
            this.xml.startEmptyTag(CAMXML.TAG_VIEWS);
            this.xml.addAttribute(CAMXML.ATTR_VMUID, vmUID);
            this.xml.addAttribute(CAMXML.ATTR_UID, viewUID);
            this.xml.addAttribute(CAMXML.ATTR_NAME, name);
            if (originUtid != null) {
                this.xml.addAttribute(CAMXML.ATTR_ORIGIN_UTID, originUtid.toString());
            }
            if (name.equals("OpenCL")) {
                this.xml.addAttribute(CAMXML.ATTR_ICON, 1);
                this.xml.addAttribute(CAMXML.ATTR_HOTKEY, "O");
                this.xml.addAttribute(CAMXML.ATTR_CLIPPED_DEPENDENCY_CHAIN, true);
            }
            ++this.viewCounter;
        }
    }

    @FunctionalInterface
    public static interface ICAMXmlElementFactory<T> {
        public @NonNull T create(long var1, int var3, @NonNull String var4, int var5, @NonNull String var6, boolean var7, @Nullable Integer var8);
    }
}

