/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.live;

import com.arm.streamline.analysis.database.api.profiling.IBacktraceSource;
import com.arm.streamline.analysis.live.ILiveEventStream;
import com.arm.streamline.analysis.model.DynamicCounterSeriesKey;
import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.analysis.model.KernelAnnotationSeriesKey;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.analysis.model.threads.IUniqueThread;
import com.arm.streamline.common.analysis.model.AnnotationColour;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.common.xml.spe.SpeOperationTypeClass;
import com.arm.streamline.ftrace.TracepointFormat;
import com.arm.streamline.protocol.capture.apc.pass_one.ICookieTracker;
import com.arm.streamline.protocol.capture.apc.pass_two.GatorPassTwoSortedEventStreamConsumer;
import com.arm.streamline.protocol.capture.apc.pass_two.IGatorPassTwoEventStream;
import com.arm.streamline.protocol.capture.apc.pass_two.IUniqueThreadTracker;
import com.arm.streamline.protocol.misc.LinuxMapsParser;
import com.arm.streamline.protocol.misc.TaskId;
import gnu.trove.map.TByteShortMap;
import gnu.trove.set.TShortSet;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class LiveProtocolPerVirtualMachineProtocolEventConsumer
implements IGatorPassTwoEventStream {
    private final @NonNull ICookieTracker cookieTracker;
    private final @NonNull ILiveEventStream stream;
    private final long vmUID;
    private final @NonNull IUniqueThreadTracker uniqueThreadTracker;

    public LiveProtocolPerVirtualMachineProtocolEventConsumer(long vmUID, @NonNull ICookieTracker cookieTracker, @NonNull ILiveEventStream stream, @NonNull IUniqueThreadTracker uniqueThreadTracker) {
        this.vmUID = vmUID;
        this.cookieTracker = cookieTracker;
        this.stream = stream;
        this.uniqueThreadTracker = uniqueThreadTracker;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable IUniqueThreadTracker.ITrackedUniqueThread trackNullable(long timestamp, @Nullable TaskId taskId) {
        if (taskId == null) {
            return null;
        }
        return this.uniqueThreadTracker.track(timestamp, taskId);
    }

    public void absoluteBacktrace(long timestamp, IBacktraceSource backtraceSource, @NonNull ProcessingElementReference peReference, @NonNull TaskId taskId, long @NonNull [] addresses) throws IOException {
        IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, taskId);
        this.stream.absoluteBacktrace(this.vmUID, timestamp, peReference, (IUniqueThread)uniqueThread, addresses);
    }

    public void activityStop(@NonNull ICounterSeriesKey counterKey, long timestamp, @NonNull ProcessingElementReference peReference, @Nullable TaskId taskId, int activity) throws IOException {
        IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.trackNullable(timestamp, taskId);
        this.stream.activityStop(this.vmUID, counterKey, timestamp, peReference, (IUniqueThread)uniqueThread, activity);
    }

    public void activitySwitch(@NonNull ICounterSeriesKey counterKey, long timestamp, @NonNull ProcessingElementReference peReference, @Nullable TaskId taskId, int activity, int reason) throws IOException {
        IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.trackNullable(timestamp, taskId);
        this.stream.activitySwitch(this.vmUID, counterKey, timestamp, peReference, (IUniqueThread)uniqueThread, activity, reason);
    }

    public void annotationMarker(long timestamp, @Nullable TaskId taskId, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        this.trackNullable(timestamp, taskId);
    }

    public void annotationText(long timestamp, @NonNull TaskId taskId, int channel, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        this.uniqueThreadTracker.track(timestamp, taskId);
    }

    public void annotationTextAsync(long timestamp, @NonNull TaskId taskId, @NonNull String title, int id, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        this.uniqueThreadTracker.track(timestamp, taskId);
    }

    public void annotationTextAsyncEnd(long timestamp, @NonNull TaskId taskId, @NonNull String title, int id) throws IOException {
        this.uniqueThreadTracker.track(timestamp, taskId);
    }

    public void annotationTextNameChannel(long timestamp, @NonNull TaskId taskId, int channel, int group, @NonNull String text) throws IOException {
        this.uniqueThreadTracker.track(timestamp, taskId);
    }

    public void annotationTextNameGroup(long timestamp, @NonNull TaskId taskId, int group, @NonNull String text) throws IOException {
        this.uniqueThreadTracker.track(timestamp, taskId);
    }

    public void annotationTextPop(long timestamp, @NonNull TaskId taskId, @NonNull String title) throws IOException {
        this.uniqueThreadTracker.track(timestamp, taskId);
    }

    public void annotationTextPush(long timestamp, @NonNull TaskId taskId, @NonNull String title, @NonNull AnnotationColour colour, @NonNull String text) throws IOException {
        this.uniqueThreadTracker.track(timestamp, taskId);
    }

    public void annotationVisual(long timestamp, @NonNull TaskId taskId, @NonNull String text, byte @NonNull [] image) throws IOException {
        IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, taskId);
        this.stream.annotationVisual(this.vmUID, timestamp, (IUniqueThread)uniqueThread, text, image);
    }

    public void atraceCounter(long timestamp, @NonNull String name, @NonNull TaskId taskId, long value) throws IOException {
        IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, taskId);
        this.stream.atraceCounter(this.vmUID, timestamp, name, (IUniqueThread)uniqueThread, value);
    }

    public void attributes(long vmUID, Map<@NonNull String, @NonNull String> attributes) throws IOException {
    }

    public void camJob(int viewUID, long startTime, long duration, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour, int primaryDependency, int @NonNull [] dependencies) throws IOException {
    }

    public void camJob(@NonNull TaskId taskId, int viewUID, long startTime, long duration, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour, int primaryDependency, int @NonNull [] dependencies) throws IOException {
        this.uniqueThreadTracker.track(startTime, taskId);
    }

    public void camJobDependencies(@NonNull TaskId taskId, int viewUID, long timestamp, int jobUID, int primaryDependency, int @NonNull [] dependencies) throws IOException {
        this.uniqueThreadTracker.track(timestamp, taskId);
    }

    public void camJobStart(@NonNull TaskId taskId, int viewUID, long timestamp, int track, int jobUID, @NonNull String name, @NonNull AnnotationColour colour) throws IOException {
        this.uniqueThreadTracker.track(timestamp, taskId);
    }

    public void camJobStop(@NonNull TaskId taskId, int viewUID, long timestamp, int jobUID) throws IOException {
        this.uniqueThreadTracker.track(timestamp, taskId);
    }

    public void camTrack(int viewUID, int parentTrack, int trackUID, @NonNull String name) throws IOException {
    }

    public void camTrack(long timestamp, @NonNull TaskId taskId, int viewUID, int parentTrack, int trackUID, @NonNull String name) throws IOException {
        this.uniqueThreadTracker.track(timestamp, taskId);
    }

    public void camView(int viewUID, @NonNull String name) throws IOException {
    }

    public void camView(long timestamp, @NonNull TaskId taskId, int viewUID, @NonNull String name) throws IOException {
        this.uniqueThreadTracker.track(timestamp, taskId);
    }

    public void chopExternalFrame(int offset) {
    }

    public void chopExternalHeaderFrame(int offset) {
    }

    public void counter(@NonNull ICounterSeriesKey counterKey, long timestamp, @NonNull ProcessingElementReference peReference, @Nullable TaskId taskId, long value) throws IOException {
        IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.trackNullable(timestamp, taskId);
        if (!counterKey.isMapCounterToActivity()) {
            this.stream.counter(this.vmUID, counterKey, timestamp, peReference, (IUniqueThread)uniqueThread, value);
        } else {
            this.stream.activitySwitch(this.vmUID, counterKey, timestamp, peReference, (IUniqueThread)uniqueThread, Math.max(1, (int)Math.min(value + 1L, (long)counterKey.getMappedActivityCount())), 0);
        }
    }

    public void createDynamicCounterSeries(@NonNull DynamicCounterSeriesKey counterKey, @NonNull String title, @NonNull String name, @NonNull String units, @NonNull String description, @NonNull CounterClass counterClass, @NonNull CounterDisplay display, @NonNull SeriesComposition seriesComposition, @NonNull GraphRenderingType renderingType, boolean averageSelection, boolean percentage, @NonNull AnnotationColour colour, double multiplier, @NonNull List<@NonNull String> activities, @NonNull List<@NonNull AnnotationColour> activityColors) throws IOException {
        this.stream.createDynamicCounterSeries(this.vmUID, counterKey, title, name, units, description, counterClass, display, seriesComposition, renderingType, averageSelection, percentage, colour, multiplier, activities, activityColors);
    }

    public void createKernelAnnotationsCounterSeries(@NonNull KernelAnnotationSeriesKey counterKey, @NonNull String title, @NonNull String name, @NonNull String units, @NonNull String description, @NonNull CounterClass counterClass, @NonNull CounterDisplay display, @NonNull SeriesComposition seriesComposition, @NonNull GraphRenderingType renderingType, boolean averageSelection, boolean percentage, @NonNull AnnotationColour colour, double multiplier, @NonNull List<@NonNull String> activities, @NonNull List<@NonNull AnnotationColour> activityColors) throws IOException {
        this.stream.createKernelAnnotationsCounterSeries(this.vmUID, counterKey, title, name, units, description, counterClass, display, seriesComposition, renderingType, averageSelection, percentage, colour, multiplier, activities, activityColors);
    }

    public void idle(long timestamp, @NonNull ProcessingElementReference peReference, boolean online) throws IOException {
    }

    public void schedSwitch(long timestamp, @NonNull ProcessingElementReference peReference, @NonNull TaskId nextTaskId, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason reason) throws IOException {
        IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, nextTaskId);
        this.stream.schedSwitch(this.vmUID, timestamp, peReference, (IUniqueThread)uniqueThread, reason);
    }

    public void speSample(int key, long timestamp, @NonNull ProcessingElementReference peReference, @NonNull TaskId taskId, long pc, @Nullable SpeOperationTypeClass opTypeClass, byte opTypeSubclass, long events, @NonNull TShortSet dataSources, @NonNull TByteShortMap counterMap) throws IOException {
        this.uniqueThreadTracker.track(timestamp, taskId);
    }

    public void threadExec(long timestamp, @Nullable TaskId oldTaskId, @NonNull TaskId taskId, int cookieUID) throws IOException {
        IExecutablePath executablePath = ICookieTracker.mapCookie((ICookieTracker)this.cookieTracker, (int)cookieUID);
        IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.threadExec(timestamp, oldTaskId, taskId, executablePath);
        this.stream.threadExec(this.vmUID, timestamp, (IUniqueThread)uniqueThread);
    }

    public void threadExit(long timestamp, @NonNull TaskId taskId) throws IOException {
        IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.threadExit(timestamp, taskId);
        this.stream.threadExit(this.vmUID, timestamp, (IUniqueThread)uniqueThread);
    }

    public void threadFork(long timestamp, @Nullable TaskId parentTaskId, @NonNull TaskId taskId) throws IOException {
        IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.threadFork(timestamp, parentTaskId, taskId);
        this.stream.threadFork(this.vmUID, timestamp, (IUniqueThread)uniqueThread);
    }

    public void threadLinkCookie(long timestamp, @NonNull TaskId taskId, int cookieUID) throws IOException {
        IExecutablePath executablePath = ICookieTracker.mapCookie((ICookieTracker)this.cookieTracker, (int)cookieUID);
        IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.threadLinkExecutablePath(timestamp, taskId, executablePath);
        this.stream.threadLinkCookie(this.vmUID, timestamp, (IUniqueThread)uniqueThread);
    }

    public void threadMaps(long timestamp, @NonNull TaskId taskId, @NonNull String maps) throws IOException {
        IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, taskId, false);
        LinuxMapsParser.parse((String)maps, (startAddress, endAddress, offset, filename) -> this.uniqueThreadTracker.threadMMap(uniqueThread, offset, startAddress, endAddress - startAddress, GatorPassTwoSortedEventStreamConsumer.mapExecutablePath((String)filename, (boolean)false)));
        this.stream.threadMaps(this.vmUID, timestamp, (IUniqueThread)uniqueThread);
    }

    public void threadMMap(long timestamp, @NonNull TaskId taskId, long fileOffset, long mapAddress, long length, @NonNull String filename) throws IOException {
        IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, taskId, false);
        this.uniqueThreadTracker.threadMMap(uniqueThread, fileOffset, mapAddress, length, GatorPassTwoSortedEventStreamConsumer.mapExecutablePath((String)filename, (boolean)false));
        this.stream.threadMMap(this.vmUID, timestamp, (IUniqueThread)uniqueThread);
    }

    public void threadProperties(long timestamp, @Nullable TaskId parentTaskId, @NonNull TaskId taskId, @NonNull String name, @NonNull String exePath, @Nullable String linuxProcMapsContents) throws IOException {
        IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.threadProperties(timestamp, parentTaskId, taskId, name, GatorPassTwoSortedEventStreamConsumer.mapExecutablePath((String)exePath, (boolean)true));
        if (linuxProcMapsContents != null) {
            LinuxMapsParser.parse((String)linuxProcMapsContents, (startAddress, endAddress, offset, filename) -> this.uniqueThreadTracker.threadMMap(uniqueThread, offset, startAddress, endAddress - startAddress, GatorPassTwoSortedEventStreamConsumer.mapExecutablePath((String)filename, (boolean)false)));
        }
        this.stream.threadProperties(this.vmUID, timestamp, (IUniqueThread)uniqueThread);
    }

    public void threadRename(long timestamp, @NonNull TaskId taskId, @NonNull String name, boolean exec) throws IOException {
        IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.threadRename(timestamp, taskId, name, exec);
        this.stream.threadRename(this.vmUID, timestamp, (IUniqueThread)uniqueThread);
    }

    public void tracepointEvent(long timestamp, @Nullable TaskId taskId, @NonNull TracepointFormat tracepointFormat, byte @NonNull [] raw) throws IOException {
        this.trackNullable(timestamp, taskId);
    }

    public void warning(long timestamp, @NonNull TaskId thread, @NonNull WarningItem warning) throws IOException {
        IUniqueThreadTracker.ITrackedUniqueThread uniqueThread = this.uniqueThreadTracker.track(timestamp, thread);
        this.stream.warning(this.vmUID, timestamp, (IUniqueThread)uniqueThread, warning);
    }

    public void warning(@NonNull WarningItem warning) throws IOException {
        this.stream.warning(warning);
    }
}

