/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.live;

import com.arm.streamline.analysis.live.ILiveEventStream;
import com.arm.streamline.analysis.live.ILiveGator;
import com.arm.streamline.analysis.live.LiveProtocolPerVirtualMachineProtocolEventConsumer;
import com.arm.streamline.analysis.model.AtraceCounterSeriesKey;
import com.arm.streamline.analysis.model.DynamicCounterSeriesKey;
import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.analysis.model.KernelAnnotationSeriesKey;
import com.arm.streamline.analysis.model.StaticCounterSeriesKey;
import com.arm.streamline.analysis.model.threads.ExecutablePathMapping;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.analysis.model.threads.IUniqueThread;
import com.arm.streamline.analysis.session.IImageTransferCaptureDataSource;
import com.arm.streamline.common.analysis.model.AnnotationColour;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.counters.CounterMode;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.common.utility.Ternary;
import com.arm.streamline.databrowser.ICaptureProxy;
import com.arm.streamline.protocol.capture.apc.live.ILiveOutputStreamFactory;
import com.arm.streamline.protocol.capture.apc.pass_one.ICookieTracker;
import com.arm.streamline.protocol.capture.apc.pass_two.IGatorPassTwoEventStream;
import com.arm.streamline.protocol.capture.apc.pass_two.IUniqueThreadTracker;
import com.arm.streamline.protocol.capture.apc.pass_two.LinuxThreadTracker;
import com.arm.streamline.protocol.misc.AttachedApkEntries;
import com.arm.utils.NullChecking;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.function.ToIntFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class LiveProtocolEventStream
implements IImageTransferCaptureDataSource,
ILiveEventStream,
ILiveOutputStreamFactory {
    private final @NonNull Map<@NonNull ICounterSeriesKey, @NonNull CounterRecord> counterSeriesToCounterRecord = new HashMap<ICounterSeriesKey, CounterRecord>();
    private final @NonNull TObjectIntMap<ICounterSeriesKey> counterSeriesToKey = new TObjectIntHashMap(10, 0.5f, -1);
    private final @NonNull IntSupplier dynamicKeySupplier;
    private final @Nullable ILiveGator live;
    private final @NonNull Map<@NonNull IUniqueThread, @NonNull IExecutablePath> processExecutableMap = new HashMap<IUniqueThread, IExecutablePath>();
    private final @NonNull Map<@NonNull IUniqueThread, @NonNull Set<@NonNull IExecutablePath>> processToLibraryMap = new HashMap<IUniqueThread, Set<IExecutablePath>>();
    private final @NonNull ICaptureProxy proxy;
    private long startTime = Long.MAX_VALUE;
    private long stopTime = 0L;
    private final @NonNull ToIntFunction<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IUniqueThreadTracker.ITrackedUniqueThread> threadUidAllocator = new ToIntFunction<IUniqueThreadTracker.ITrackedUniqueThread>(){
        private int counter = 0;

        @Override
        public int applyAsInt(IUniqueThreadTracker.ITrackedUniqueThread value) {
            return ++this.counter;
        }
    };

    private static int mapSchedSwitchReason(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason reason) {
        switch (reason) {
            case CONTENTION: {
                return 1;
            }
            case SCHEDULED: {
                return 0;
            }
            case WAIT_IO: {
                return 2;
            }
        }
        throw new AssertionError(reason);
    }

    public LiveProtocolEventStream(@NonNull List<@NonNull CounterRecord> staticCounterRecords, @NonNull IntSupplier dynamicKeySupplier, @NonNull ICaptureProxy proxy, @Nullable ILiveGator live) {
        this.proxy = proxy;
        this.live = live;
        this.dynamicKeySupplier = dynamicKeySupplier;
        staticCounterRecords.forEach(cr -> {
            StaticCounterSeriesKey k = new StaticCounterSeriesKey(cr);
            this.counterSeriesToCounterRecord.put((ICounterSeriesKey)k, (CounterRecord)cr);
            this.counterSeriesToKey.put((Object)k, cr.getKey());
        });
    }

    @Override
    public void absoluteBacktrace(long vmUID, long timestamp, @NonNull ProcessingElementReference peReference, @NonNull IUniqueThread taskId, long @NonNull [] addresses) throws IOException {
        if (addresses.length <= 0) {
            return;
        }
        this.findStartStopTime(timestamp);
    }

    @Override
    public void activityStop(long vmUID, @NonNull ICounterSeriesKey counterKey, long timestamp, @NonNull ProcessingElementReference peReference, @Nullable IUniqueThread taskId, int activity) throws IOException {
        @Nullable ILiveGator live = this.live;
        if (this.findStartStopTime(timestamp) && live != null) {
            live.activitySwitch(peReference, timestamp, this.mapCounterSeries(counterKey), 0);
        }
    }

    @Override
    public void activitySwitch(long vmUID, @NonNull ICounterSeriesKey counterKey, long timestamp, @NonNull ProcessingElementReference peReference, @Nullable IUniqueThread taskId, int activity, int reason) throws IOException {
        @Nullable ILiveGator live = this.live;
        if (this.findStartStopTime(timestamp) && live != null) {
            live.activitySwitch(peReference, timestamp, this.mapCounterSeries(counterKey), activity);
        }
    }

    @Override
    public void annotationVisual(long vmUID, long timestamp, @NonNull IUniqueThread taskId, @NonNull String text, byte @NonNull [] image) throws IOException {
        @Nullable ILiveGator live = this.live;
        if (live != null) {
            live.addVisualChart(taskId);
        }
    }

    @Override
    public void atraceCounter(long vmUID, long timestamp, @NonNull String name, @NonNull IUniqueThread taskId, long value) throws IOException {
        AtraceCounterSeriesKey counterKey = new AtraceCounterSeriesKey(name);
        int key = this.mapCounterSeries((ICounterSeriesKey)counterKey);
        @Nullable ILiveGator live = this.live;
        if (!this.counterSeriesToCounterRecord.containsKey(counterKey)) {
            @NonNull CounterRecord counterRecord = counterKey.getCounterRecord();
            counterRecord.setKey(key);
            this.counterSeriesToCounterRecord.put((ICounterSeriesKey)counterKey, counterRecord);
            if (live != null) {
                live.addCounterDuringCapture(counterRecord);
            }
        }
        if (this.findStartStopTime(timestamp) && live != null) {
            live.addCounterSample(timestamp, key, value, taskId);
        }
    }

    @Override
    public void counter(long vmUID, @NonNull ICounterSeriesKey counterKey, long timestamp, @NonNull ProcessingElementReference peReference, @Nullable IUniqueThread taskId, long value) throws IOException {
        @Nullable ILiveGator live = this.live;
        if (this.findStartStopTime(timestamp) && live != null) {
            if (counterKey.isThreadCounter()) {
                live.addCounterSample(timestamp, this.mapCounterSeries(counterKey), value, taskId);
            } else {
                live.addCounterSample(timestamp, peReference, this.mapCounterSeries(counterKey), value);
            }
        }
    }

    @Override
    public void createDynamicCounterSeries(long vmUID, @NonNull DynamicCounterSeriesKey counterKey, @NonNull String title, @NonNull String name, @NonNull String units, @NonNull String description, @NonNull CounterClass counterClass, @NonNull CounterDisplay display, @NonNull SeriesComposition seriesComposition, @NonNull GraphRenderingType renderingType, boolean averageSelection, boolean percentage, @NonNull AnnotationColour colour, double multiplier, @NonNull List<@NonNull String> activities, @NonNull List<@NonNull AnnotationColour> activityColors) throws IOException {
        if (this.counterSeriesToCounterRecord.containsKey(counterKey)) {
            return;
        }
        int key = this.mapCounterSeries((ICounterSeriesKey)counterKey);
        @NonNull String counter = String.format("dynamic_counter_%d_%s_%s", key, title.replaceAll("[^0-9A-Za-z]+", "_"), name.replaceAll("[^0-9A-Za-z]+", "_"));
        @NonNull TIntArrayList activityColor = new TIntArrayList(activityColors.stream().map(AnnotationColour::mapCounterColour).mapToInt(i -> NullChecking.neverNullOr((Integer)i, (int)0)).toArray());
        @NonNull CounterRecord counterRecord = new CounterRecord(counter, title, name, description, units, colour.mapCounterColour(), key, counterClass, display, averageSelection, CounterMode.SYSTEM_WIDE, multiplier, seriesComposition, renderingType, false, percentage, activities, activityColor, 0, false, true, Ternary.TRUE, null);
        this.counterSeriesToCounterRecord.put((ICounterSeriesKey)counterKey, counterRecord);
        @Nullable ILiveGator live = this.live;
        if (live != null) {
            live.addCounterDuringCapture(counterRecord);
        }
    }

    @Override
    public void createKernelAnnotationsCounterSeries(long vmUID, @NonNull KernelAnnotationSeriesKey counterKey, @NonNull String title, @NonNull String name, @NonNull String units, @NonNull String description, @NonNull CounterClass counterClass, @NonNull CounterDisplay display, @NonNull SeriesComposition seriesComposition, @NonNull GraphRenderingType renderingType, boolean averageSelection, boolean percentage, @NonNull AnnotationColour colour, double multiplier, @NonNull List<@NonNull String> activities, @NonNull List<@NonNull AnnotationColour> activityColors) throws IOException {
        if (this.counterSeriesToCounterRecord.containsKey(counterKey)) {
            return;
        }
        int key = this.mapCounterSeries((ICounterSeriesKey)counterKey);
        @NonNull String counter = String.format("kernel_annotations_counter_%s_%s", title.replaceAll("[^0-9A-Za-z]+", "_"), name.replaceAll("[^0-9A-Za-z]+", "_"));
        @NonNull TIntArrayList activityColor = new TIntArrayList(activityColors.stream().map(AnnotationColour::mapCounterColour).mapToInt(i -> NullChecking.neverNullOr((Integer)i, (int)0)).toArray());
        @NonNull CounterRecord counterRecord = new CounterRecord(counter, title, name, description, units, colour.mapCounterColour(), key, counterClass, display, averageSelection, CounterMode.SYSTEM_WIDE, multiplier, seriesComposition, renderingType, false, percentage, activities, activityColor, 0, false, true, Ternary.TRUE, null);
        this.counterSeriesToCounterRecord.put((ICounterSeriesKey)counterKey, counterRecord);
        @Nullable ILiveGator live = this.live;
        if (live != null) {
            live.addCounterDuringCapture(counterRecord);
        }
    }

    public @NonNull IGatorPassTwoEventStream createOutputStream(long vmUID, @NonNull ICookieTracker cookieTracker, boolean appTracingMode) throws IOException {
        ILiveGator live = this.live;
        LinuxThreadTracker uniqueThreadTracker = live != null ? live.createUniqueThreadTracker(vmUID, appTracingMode) : new LinuxThreadTracker(vmUID, this.threadUidAllocator, Collections.emptyList(), new AttachedApkEntries(Collections.emptyMap()), appTracingMode);
        return new LiveProtocolPerVirtualMachineProtocolEventConsumer(vmUID, cookieTracker, this, (IUniqueThreadTracker)uniqueThreadTracker);
    }

    @Override
    public @NonNull Map<@NonNull IUniqueThread, @NonNull IExecutablePath> getAllProcessExecutables() {
        return Collections.unmodifiableMap(this.processExecutableMap);
    }

    @Override
    public @NonNull Map<@NonNull IUniqueThread, @NonNull Set<@NonNull IExecutablePath>> getAllProcessImages() {
        return Collections.unmodifiableMap(this.processToLibraryMap);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    @Override
    public void schedSwitch(long vmUID, long timestamp, @NonNull ProcessingElementReference peReference, @NonNull IUniqueThread nextTaskId, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason reason) throws IOException {
        @Nullable ILiveGator live = this.live;
        if (this.findStartStopTime(timestamp) && live != null) {
            live.schedSwitch(peReference, timestamp, nextTaskId, LiveProtocolEventStream.mapSchedSwitchReason(reason));
        }
    }

    @Override
    public void threadExec(long vmUID, long timestamp, @NonNull IUniqueThread uniqueThread) throws IOException {
        this.findStartStopTime(timestamp);
        @Nullable ILiveGator live = this.live;
        if (live != null) {
            live.threadUpdate(timestamp, uniqueThread);
        }
        this.trackProcessImages(uniqueThread);
    }

    @Override
    public void threadExit(long vmUID, long timestamp, @NonNull IUniqueThread uniqueThread) throws IOException {
        this.findStartStopTime(timestamp);
        @Nullable ILiveGator live = this.live;
        if (live != null) {
            live.threadExit(timestamp, uniqueThread);
        }
    }

    @Override
    public void threadFork(long vmUID, long timestamp, @NonNull IUniqueThread uniqueThread) throws IOException {
        this.findStartStopTime(timestamp);
        @Nullable ILiveGator live = this.live;
        if (live != null) {
            live.threadFork(timestamp, uniqueThread);
        }
        this.trackProcessImages(uniqueThread);
    }

    @Override
    public void threadLinkCookie(long vmUID, long timestamp, @NonNull IUniqueThread uniqueThread) throws IOException {
        this.findStartStopTime(timestamp);
        @Nullable ILiveGator live = this.live;
        if (live != null) {
            live.threadUpdate(timestamp, uniqueThread);
        }
        this.trackProcessImages(uniqueThread);
    }

    @Override
    public void threadMaps(long vmUID, long timestamp, @NonNull IUniqueThread uniqueThread) throws IOException {
        this.findStartStopTime(timestamp);
        @Nullable ILiveGator live = this.live;
        if (live != null) {
            live.threadUpdate(timestamp, uniqueThread);
        }
        this.trackProcessImages(uniqueThread);
    }

    @Override
    public void threadMMap(long vmUID, long timestamp, @NonNull IUniqueThread uniqueThread) throws IOException {
        this.findStartStopTime(timestamp);
        @Nullable ILiveGator live = this.live;
        if (live != null) {
            live.threadUpdate(timestamp, uniqueThread);
        }
        this.trackProcessImages(uniqueThread);
        IUniqueThread parentUniqueThread = uniqueThread.getProcessThread();
        if (parentUniqueThread != null) {
            this.trackProcessImages(parentUniqueThread);
        }
    }

    @Override
    public void threadProperties(long vmUID, long timestamp, @NonNull IUniqueThread uniqueThread) throws IOException {
        this.findStartStopTime(timestamp);
        @Nullable ILiveGator live = this.live;
        if (live != null) {
            live.threadUpdate(timestamp, uniqueThread);
        }
        this.trackProcessImages(uniqueThread);
    }

    @Override
    public void threadRename(long vmUID, long timestamp, @NonNull IUniqueThread uniqueThread) throws IOException {
        this.findStartStopTime(timestamp);
        @Nullable ILiveGator live = this.live;
        if (live != null) {
            live.threadUpdate(timestamp, uniqueThread);
        }
        this.trackProcessImages(uniqueThread);
    }

    @Override
    public void waitUntilAllDataIsProcessed() throws InterruptedException {
    }

    @Override
    public void warning(long vmUID, long timestamp, @NonNull IUniqueThread thread, @NonNull WarningItem warning) throws IOException {
        this.warning(warning);
    }

    @Override
    public void warning(@NonNull WarningItem warning) throws IOException {
        this.proxy.liveWarning(warning);
    }

    private boolean findStartStopTime(long time) {
        if (time < 0L) {
            return false;
        }
        if (time < this.startTime) {
            if (this.live != null) {
                this.live.setStartTime(time);
            }
            this.startTime = time;
        }
        if (time > this.stopTime) {
            this.stopTime = time;
        }
        return true;
    }

    private int mapCounterSeries(@NonNull ICounterSeriesKey counterKey) {
        if (!this.counterSeriesToKey.containsKey((Object)counterKey)) {
            this.counterSeriesToKey.put((Object)counterKey, this.dynamicKeySupplier.getAsInt());
        }
        return this.counterSeriesToKey.get((Object)counterKey);
    }

    private void trackProcessImages(@NonNull IUniqueThread uniqueThread) {
        IUniqueThread process = uniqueThread.getProcessThread();
        if (process == null) {
            return;
        }
        Set set = this.processToLibraryMap.computeIfAbsent(uniqueThread, k -> new HashSet());
        IExecutablePath exe = process.getExecutablePath();
        if (exe != null) {
            this.processExecutableMap.put(process, exe);
            set.add(exe);
        }
        for (ExecutablePathMapping m : process.getMMaps()) {
            set.add(m.executablePath);
        }
    }
}

