/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.live;

import com.arm.streamline.analysis.live.CPUActivity;
import com.arm.streamline.analysis.model.threads.IUniqueThread;
import com.arm.streamline.application.StreamlinePlugin;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public class LiveHeatMap {
    private final List<@NonNull CPUActivity> mActivity = new ArrayList<CPUActivity>();
    private final @NonNull IUniqueThread @NonNull [] mLastActiveThread;
    private final long @NonNull [] mPreviousTime;
    private final int mNumCores;

    LiveHeatMap(int numCores, @NonNull IUniqueThread idleThread) {
        this.mNumCores = numCores;
        this.mPreviousTime = new long[numCores];
        this.mLastActiveThread = new IUniqueThread[numCores];
        Arrays.fill(this.mLastActiveThread, idleThread);
    }

    public void add(int core, long time, @NonNull IUniqueThread uniqueThread) {
        this.mActivity.add(new CPUActivity(core, time, uniqueThread, 0, false));
    }

    public @NonNull Map<@NonNull IUniqueThread, @NonNull TIntArrayList> commit(long threshold) {
        HashMap<IUniqueThread, TIntArrayList> accumulatedValues = new HashMap<IUniqueThread, TIntArrayList>();
        Collections.sort(this.mActivity);
        while (!this.mActivity.isEmpty() && this.mActivity.get((int)0).timestamp < threshold) {
            this.handleActivity(this.mActivity.get(0), accumulatedValues);
            this.mActivity.remove(0);
        }
        int core = 0;
        while (core < this.mNumCores) {
            this.commitActivity(core, threshold, accumulatedValues);
            ++core;
        }
        return accumulatedValues;
    }

    public void setStartTime(long time) {
        int core = 0;
        while (core < this.mNumCores) {
            this.mPreviousTime[core] = time;
            ++core;
        }
    }

    private void commitActivity(int core, long threshold, @NonNull Map<@NonNull IUniqueThread, @NonNull TIntArrayList> accumulatedValues) {
        long missing;
        TIntArrayList state = accumulatedValues.get(this.mLastActiveThread[core]);
        if (state == null) {
            state = new TIntArrayList();
            state.add(new int[this.mNumCores]);
            accumulatedValues.put(this.mLastActiveThread[core], state);
        }
        if ((missing = threshold - this.mPreviousTime[core]) < 0L) {
            StreamlinePlugin.warning("LiveHeatMap encountered activity > 100%, which should never happen");
        } else {
            int percentage = state.get(core);
            if ((percentage = (int)((long)percentage + missing * 10000L / 100000000L)) > 10000) {
                StreamlinePlugin.warning("LiveHeatMap encountered activity > 100%, which should never happen");
                percentage = 10000;
            }
            state.set(core, percentage);
        }
        this.mPreviousTime[core] = threshold;
    }

    private void handleActivity(@NonNull CPUActivity activity, @NonNull Map<@NonNull IUniqueThread, @NonNull TIntArrayList> accumulatedValues) {
        TIntArrayList state = accumulatedValues.get(this.mLastActiveThread[activity.core]);
        if (state == null) {
            state = new TIntArrayList();
            state.add(new int[this.mNumCores]);
            accumulatedValues.put(this.mLastActiveThread[activity.core], state);
        }
        long delta = activity.timestamp - this.mPreviousTime[activity.core];
        int percentage = state.get(activity.core);
        percentage = (int)((long)percentage + delta * 10000L / 100000000L);
        state.set(activity.core, percentage);
        this.mPreviousTime[activity.core] = activity.timestamp;
        this.mLastActiveThread[activity.core] = activity.uniqueThread;
    }
}

