/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.live;

import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterDisplay;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.HashMap;

public class LiveCounter {
    private long mTotalValues;
    private long mDroppedValues;
    private HashMap<CounterDisplay, Long> mCommitValues = new HashMap();
    private TIntObjectHashMap<TLongObjectHashMap<LiveCounterData>> mCounters = new TIntObjectHashMap();

    LiveCounter(int numCores) {
        int i = 0;
        while (i < numCores) {
            this.mCounters.put(i, (Object)new TLongObjectHashMap());
            ++i;
        }
    }

    public long addCounter(int core, int key, long time, long value) {
        LiveCounterData data = (LiveCounterData)((TLongObjectHashMap)this.mCounters.get(core)).get((long)key);
        long startOfBin = data.mThreshold - 100000000L;
        long totalTime = time - data.mLastTime;
        if (time < startOfBin) {
            if (time > data.mLastTime) {
                data.mLastTime = time;
                data.mLastValue = value;
            }
            ++this.mDroppedValues;
            return -1L;
        }
        if (time > data.mThreshold) {
            if (data.mCounterClass.isDelta()) {
                long dropTimeProportion = startOfBin - data.mLastTime;
                long thisTimeProportion = data.mThreshold - startOfBin;
                long futureTimeProportion = time - data.mThreshold;
                if (dropTimeProportion < 0L) {
                    dropTimeProportion = 0L;
                }
                long futureBinsValue = value * futureTimeProportion / totalTime;
                if (value * thisTimeProportion % totalTime > 0L) {
                    ++futureBinsValue;
                }
                this.addCounter(core, key, data.mThreshold, value - futureBinsValue);
                value = futureBinsValue;
            }
            return value;
        }
        if (data.mLastTime < startOfBin && data.mCounterClass.isDelta()) {
            long timeProportion = time - startOfBin;
            data.mAccumulate += value * timeProportion / totalTime;
            if (value * timeProportion % totalTime > 0L) {
                ++data.mAccumulate;
            }
        } else {
            data.mAccumulate += value;
        }
        if (time > data.mLastTime) {
            data.mLastTime = time;
            data.mLastValue = value;
        }
        ++data.mNumBins;
        if (value > data.mMax) {
            data.mMax = value;
        }
        if (value < data.mMin) {
            data.mMin = value;
        }
        ++this.mTotalValues;
        return -1L;
    }

    public HashMap<CounterDisplay, Long> commit(int core, int key) {
        this.mCommitValues.clear();
        LiveCounterData data = (LiveCounterData)((TLongObjectHashMap)this.mCounters.get(core)).get((long)key);
        switch (data.mCounterClass) {
            case ABSOLUTE: {
                if (data.mNumBins == 0L) {
                    data.mMax = data.mMin = data.mLastValue;
                    this.mCommitValues.put(CounterDisplay.AVERAGE, data.mLastValue);
                } else {
                    this.mCommitValues.put(CounterDisplay.AVERAGE, data.mAccumulate / data.mNumBins);
                }
                this.mCommitValues.put(CounterDisplay.MAXIMUM, data.mMax);
                this.mCommitValues.put(CounterDisplay.MINIMUM, data.mMin);
                break;
            }
            case ACTIVITY: {
                if (data.mNumBins == 0L) {
                    this.mCommitValues.put(CounterDisplay.AVERAGE, 0L);
                    break;
                }
                this.mCommitValues.put(CounterDisplay.AVERAGE, data.mAccumulate / data.mNumBins);
                break;
            }
            case DELTA: 
            case INCIDENT: {
                this.mCommitValues.put(CounterDisplay.ACCUMULATE, data.mAccumulate);
                break;
            }
            case CONSTANT: {
                this.mCommitValues.put(CounterDisplay.AVERAGE, data.mLastValue);
                this.mCommitValues.put(CounterDisplay.MAXIMUM, data.mLastValue);
                this.mCommitValues.put(CounterDisplay.MINIMUM, data.mLastValue);
                break;
            }
        }
        data.mThreshold += 100000000L;
        data.mMax = data.mMin = data.mLastValue;
        data.mNumBins = 0L;
        data.mAccumulate = 0L;
        return this.mCommitValues;
    }

    public boolean exists(int key) {
        return ((TLongObjectHashMap)this.mCounters.get(0)).get((long)key) != null;
    }

    public long getDroppedValues() {
        return this.mDroppedValues;
    }

    public long getThreshold(int core, int key) {
        return ((LiveCounterData)((TLongObjectHashMap)this.mCounters.get((int)core)).get((long)((long)key))).mThreshold;
    }

    public long getTotalValues() {
        return this.mTotalValues;
    }

    public void initialize(int core, int key, long threshold, CounterClass cclass, boolean perCPU) {
        TLongObjectHashMap coreSpecificCounter = (TLongObjectHashMap)this.mCounters.get(core);
        LiveCounterData data = (LiveCounterData)coreSpecificCounter.get((long)key);
        if (data == null) {
            data = new LiveCounterData();
            coreSpecificCounter.put((long)key, (Object)data);
            data.mThreshold = threshold;
            data.mCounterClass = cclass;
            data.mSystemWide = !perCPU;
        }
    }

    public boolean isSystemWideCounter(int key) {
        return ((LiveCounterData)((TLongObjectHashMap)this.mCounters.get((int)0)).get((long)((long)key))).mSystemWide;
    }

    public void setThreshold(int core, int key, long threshold) {
        ((LiveCounterData)((TLongObjectHashMap)this.mCounters.get((int)core)).get((long)((long)key))).mThreshold = threshold;
    }

    private static class LiveCounterData {
        public long mLastValue;
        public long mLastTime;
        public long mMax;
        public long mMin;
        public long mAccumulate;
        public long mNumBins;
        public CounterClass mCounterClass;
        public long mThreshold;
        public boolean mSystemWide;
    }
}

