/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.live;

import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntLongMap;
import gnu.trove.map.hash.TIntLongHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LiveActivity {
    private TIntObjectHashMap<ArrayList<ActivityState>> mState = new TIntObjectHashMap();
    private List<ActivitySwitch> mActivitySwitches = new ArrayList<ActivitySwitch>();

    private static TIntLongHashMap commitActivity(ActivityState state, long threshold) {
        int[] activityKeys;
        long total = 0L;
        int[] nArray = activityKeys = state.mActivity.keys();
        int n = activityKeys.length;
        int n2 = 0;
        while (n2 < n) {
            int activityKey = nArray[n2];
            total += state.mActivity.get(activityKey);
            ++n2;
        }
        long missing = 100000000L - total;
        if (missing < 0L) {
            int new_total = 0;
            int index = 0;
            while (index < activityKeys.length - 1) {
                int key = activityKeys[index];
                long truncatedValue = state.mActivity.get(key) * 100000000L / total;
                state.mActivity.put(key, truncatedValue);
                new_total = (int)((long)new_total + truncatedValue);
                ++index;
            }
            long remaining = 100000000 - new_total;
            int lastKey = activityKeys[activityKeys.length - 1];
            state.mActivity.put(lastKey, remaining);
        } else if (missing > 0L) {
            state.mActivity.adjustOrPutValue(state.mPreviousType, missing, missing);
        }
        TIntLongHashMap returnValue = new TIntLongHashMap((TIntLongMap)state.mActivity);
        state.mPreviousTime = threshold;
        int[] nArray2 = activityKeys;
        int n3 = activityKeys.length;
        int n4 = 0;
        while (n4 < n3) {
            int key = nArray2[n4];
            state.mActivity.put(key, 0L);
            ++n4;
        }
        return returnValue;
    }

    public void add(int core, long time, int counterkey, int activity) {
        ActivitySwitch as = new ActivitySwitch(core, time, counterkey, activity);
        this.mActivitySwitches.add(as);
    }

    public TIntObjectHashMap<ArrayList<TIntLongHashMap>> commit(long threshold) {
        Collections.sort(this.mActivitySwitches);
        while (!this.mActivitySwitches.isEmpty() && this.mActivitySwitches.get((int)0).mTimestamp < threshold) {
            this.handleActivity(this.mActivitySwitches.get(0));
            this.mActivitySwitches.remove(0);
        }
        TIntObjectHashMap returnValue = new TIntObjectHashMap();
        TIntObjectIterator itr = this.mState.iterator();
        while (itr.hasNext()) {
            itr.advance();
            int key = itr.key();
            ArrayList<TIntLongHashMap> resultPerKey = new ArrayList<TIntLongHashMap>();
            returnValue.put(key, resultPerKey);
            ArrayList statePerKey = (ArrayList)itr.value();
            int cores = statePerKey.size();
            int core = 0;
            while (core < cores) {
                ActivityState state = (ActivityState)statePerKey.get(core);
                TIntLongHashMap result = LiveActivity.commitActivity(state, threshold);
                resultPerKey.add(result);
                ++core;
            }
        }
        return returnValue;
    }

    public void initialize(int numCores, int counterKey) {
        ArrayList<ActivityState> perCore = new ArrayList<ActivityState>();
        this.mState.put(counterKey, perCore);
        int core = 0;
        while (core < numCores) {
            ActivityState as = new ActivityState();
            perCore.add(as);
            ++core;
        }
    }

    public void setStartTime(long time) {
        TIntObjectIterator itr = this.mState.iterator();
        while (itr.hasNext()) {
            itr.advance();
            ArrayList state = (ArrayList)itr.value();
            int cores = state.size();
            state.clear();
            int i = 0;
            while (i < cores) {
                ActivityState initState = new ActivityState();
                state.add(i, initState);
                initState.mPreviousType = 0;
                initState.mPreviousTime = time;
                ++i;
            }
        }
    }

    private void handleActivity(ActivitySwitch activity) {
        ArrayList states = (ArrayList)this.mState.get(activity.mCounterKey);
        if (states == null) {
            return;
        }
        ActivityState state = (ActivityState)states.get(activity.mCore);
        long delta = activity.mTimestamp - state.mPreviousTime;
        state.mActivity.adjustOrPutValue(state.mPreviousType, delta, delta);
        state.mPreviousTime = activity.mTimestamp;
        state.mPreviousType = activity.mActivity;
    }

    private static class ActivityState {
        TIntLongHashMap mActivity = new TIntLongHashMap();
        int mPreviousType;
        long mPreviousTime;

        ActivityState() {
        }
    }

    private static class ActivitySwitch
    implements Comparable<ActivitySwitch> {
        int mCore;
        long mTimestamp;
        int mCounterKey;
        int mActivity;

        ActivitySwitch(int core, long timestamp, int counterKey, int activity) {
            this.mCore = core;
            this.mTimestamp = timestamp;
            this.mCounterKey = counterKey;
            this.mActivity = activity;
        }

        @Override
        public int compareTo(ActivitySwitch other) {
            long delta = this.mTimestamp - other.mTimestamp;
            if (delta < 0L) {
                return -1;
            }
            if (delta > 0L) {
                return 1;
            }
            return 0;
        }
    }
}

