/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.gator;

import com.arm.streamline.analysis.gator.BacktraceProcessing;
import com.arm.streamline.analysis.gator.ProtocolInfo;
import com.arm.streamline.analysis.model.DeviceTypeCalculator;
import com.arm.streamline.common.model.CaptureSubType;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.SpeCaptureRecord;
import com.arm.streamline.counterconfig.model.CounterNames;
import com.arm.streamline.model.EventBasedSampleInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface ICaptureDetails {
    default public @NonNull DeviceTypeCalculator createDeviceTypeCalculator() {
        CounterNames counterNames = this.getCounterNames();
        return DeviceTypeCalculator.create(this.getCounterList(), (Collection)counterNames);
    }

    default public @NonNull CounterNames getCounterNames() {
        @NonNull CounterNames counterNames = new CounterNames();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream is = new FileInputStream(new File(this.getPath(), "counters.xml"));){
                counterNames.load(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return counterNames;
    }

    default public boolean hasMutiGpu() {
        @Nullable Integer gpuCoreCount = this.getGpuCoresCount();
        return gpuCoreCount != null && gpuCoreCount > 1;
    }

    public @NonNull BacktraceProcessing getBacktraceProcessing();

    public @NonNull CaptureSubType getCaptureSubType();

    public @Nullable CounterRecord getCounter(int var1);

    public @NonNull List<@NonNull CounterRecord> getCounterList();

    public @Nullable CounterRecord getDerivedCounter(String var1);

    public @Nullable EventBasedSampleInfo getEBSInfo();

    public @NonNull ProtocolInfo getProtocolInfo();

    default public int getFirstDynamicKey() {
        int maxKey = 4;
        for (CounterRecord counter : this.getCounterList()) {
            maxKey = Math.max(maxKey, counter.getKey() + 1);
        }
        return maxKey;
    }

    public @NonNull String @NonNull [] getInvalidCounters();

    public @NonNull String getName();

    public int getNumberOfCores();

    public @Nullable Integer getGpuCoresCount();

    public @NonNull String getPath();

    public long getSampleIntervalNanoSeconds();

    public @NonNull Set<@NonNull SpeCaptureRecord> getSpes();

    public @NonNull TimeUnit getTimeUnit();

    public boolean hasBeenRecordedOnTarget();

    public boolean hasDerivedCounterOfType(String var1);

    public boolean hasMaliCounters();

    public boolean hasArmNNCounters();

    public boolean isCallStackUnwindingSupported();

    public boolean supportsSelectableCPUActivityPerCluster();

    public boolean isAtraceEnabled();

    public @Nullable String getGatordMd5Sum();

    public @Nullable String getGatordBuildId();
}

