/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.elfdwarf;

import com.arm.streamline.jni.elfdwarf.MappingClassificationRange;
import com.arm.streamline.jni.elfdwarf.SectionRecord;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;

public class SymbolRecord {
    private final long mAddress;
    private final long mSize;
    private final long mOffset;
    private final @NonNull String @NonNull [] mAliasNames;
    private final @NonNull String @NonNull [] mUnmangledAliasNames;
    private final int mStackSize;
    private final @NonNull String mName;
    private final @NonNull String mUnmangledName;
    private final @NonNull MappingClassificationRange @NonNull [] mRanges;
    private final @NonNull SectionRecord mSection;

    public SymbolRecord(long l, long l2, long l3, @NonNull String @NonNull [] stringArray, @NonNull String @NonNull [] stringArray2, int n, @NonNull String string, @NonNull String string2, @NonNull MappingClassificationRange @NonNull [] mappingClassificationRangeArray, @NonNull SectionRecord sectionRecord) {
        this.mAddress = l;
        this.mSize = l2;
        this.mOffset = l3;
        this.mAliasNames = stringArray;
        this.mUnmangledAliasNames = stringArray2;
        this.mStackSize = n;
        this.mName = string;
        this.mUnmangledName = string2;
        this.mRanges = mappingClassificationRangeArray;
        this.mSection = sectionRecord;
    }

    public long getAddress() {
        return this.mAddress;
    }

    public long getSize() {
        return this.mSize;
    }

    public long getFileOffset() {
        return this.mOffset;
    }

    public @NonNull String @NonNull [] getAliasNames() {
        return this.mAliasNames;
    }

    public @NonNull String @NonNull [] getUnmangledAliasNames() {
        return this.mUnmangledAliasNames;
    }

    public int getStackSize() {
        return this.mStackSize;
    }

    public @NonNull String getName() {
        return this.mName;
    }

    public @NonNull String getUnmangledName() {
        return this.mUnmangledName;
    }

    public @NonNull MappingClassificationRange @NonNull [] getRanges() {
        return this.mRanges;
    }

    public @NonNull SectionRecord getSection() {
        return this.mSection;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        @NonNull SymbolRecord symbolRecord = (SymbolRecord)object;
        return this.mAddress == symbolRecord.mAddress && this.mSize == symbolRecord.mSize && this.mOffset == symbolRecord.mOffset && Arrays.equals(this.mAliasNames, symbolRecord.mAliasNames) && Arrays.equals(this.mUnmangledAliasNames, symbolRecord.mUnmangledAliasNames) && this.mStackSize == symbolRecord.mStackSize && this.mName.equals(symbolRecord.mName) && this.mUnmangledName.equals(symbolRecord.mUnmangledName) && Arrays.equals(this.mRanges, symbolRecord.mRanges) && this.mSection.equals(symbolRecord.mSection);
    }

    public int hashCode() {
        return Objects.hash(this.mAddress);
    }

    public String toString() {
        return String.format("SymbolRecord{vAddr=0x%x, size=%d, offset=%d aliasNames=%s, stackSize=%d, ranges=%s, section=%s}", this.mAddress, this.mSize, this.mOffset, Arrays.toString(this.mAliasNames), this.mStackSize, Arrays.toString(this.mRanges), this.mSection);
    }
}

