/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen;

import com.arm.streamline.jni.apcdbgen.ProfileReportData;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.eclipse.jdt.annotation.NonNull;

public class FunctionRowCalculator {
    private final @NonNull ProfileReportData reportData;
    private final @NonNull Map<@NonNull Long, @NonNull Number @NonNull []> cachedRowValues;
    private final long @NonNull [] totalValues;
    private final @NonNull BiFunction<long @NonNull [], long @NonNull [], @NonNull Number @NonNull []> cellValueCalculator;

    FunctionRowCalculator(@NonNull ProfileReportData profileReportData, @NonNull BiFunction<long @NonNull [], long @NonNull [], @NonNull Number @NonNull []> biFunction) {
        this.reportData = profileReportData;
        this.cachedRowValues = new HashMap<Long, Number[]>();
        this.totalValues = profileReportData.getFunctionTotalValues();
        this.cellValueCalculator = biFunction;
    }

    public @NonNull Number @NonNull [] getCellValues(long l) {
        return this.cachedRowValues.computeIfAbsent(l, this::computeCellValues);
    }

    private @NonNull Number @NonNull [] computeCellValues(@NonNull Long l) {
        long[] lArray = this.reportData.getFunctionRowValues(l);
        return this.cellValueCalculator.apply(lArray, this.totalValues);
    }
}

