/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen;

import com.arm.streamline.jni.StreamlineLib;
import com.arm.streamline.jni.apcdbgen.ApcReport;
import com.arm.streamline.jni.common.CancellationPredicate;
import com.arm.streamline.jni.common.CodecException;
import com.arm.streamline.jni.common.Executor;
import com.arm.streamline.jni.common.IProgressMonitorFactory;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ApcReportGen {
    private final @NonNull String licenseEdition;
    private final @NonNull ExecutorService executorService;
    private final @NonNull IProgressMonitorFactory progressMonitorFactory;

    private static native long openReport(long var0, String var2, String var3, Executor var4) throws CodecException, IOException;

    public ApcReportGen(@NonNull String string, @NonNull ExecutorService executorService, @NonNull IProgressMonitorFactory iProgressMonitorFactory) {
        this.licenseEdition = string;
        this.executorService = executorService;
        this.progressMonitorFactory = iProgressMonitorFactory;
    }

    public @Nullable ApcReport openReport(@NonNull File file, @NonNull CancellationPredicate cancellationPredicate) throws CodecException, IOException {
        return cancellationPredicate.doWith(l -> {
            long l2 = ApcReportGen.openReport(l, file.getCanonicalPath(), this.licenseEdition, new Executor(this.executorService, this.progressMonitorFactory));
            if (l2 == 0L) {
                return null;
            }
            try {
                return ApcReport.fromHandle(l2);
            }
            catch (Throwable throwable) {
                ApcReport.destroyHandle(l2);
                throw throwable;
            }
        });
    }

    static {
        if (!StreamlineLib.isLoaded) {
            throw new AssertionError((Object)"Failed to load Streamline JNI lib");
        }
    }
}

