/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen;

import com.arm.streamline.jni.StreamlineLib;
import com.arm.streamline.jni.apcdbgen.ProfileReportData;
import com.arm.streamline.jni.apcdbgen.ProfilingFilterParams;
import com.arm.streamline.jni.apcdbgen.ProfilingLoadOptions;
import com.arm.streamline.jni.apcdbgen.ReportColumn;
import com.arm.streamline.jni.apcdbgen.SymbolProperties;
import com.arm.streamline.jni.common.CancellationPredicate;
import com.arm.streamline.jni.common.CodecException;
import com.arm.streamline.jni.common.IProgressMonitorFactory;
import com.arm.streamline.jni.common.NativeHandle;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ApcReport
implements AutoCloseable {
    private final @NonNull NativeHandle nativeHandle;
    static final /* synthetic */ boolean $assertionsDisabled;

    static @NonNull ApcReport fromHandle(long l) {
        if (!$assertionsDisabled && l == 0L) {
            throw new AssertionError();
        }
        return new ApcReport(l);
    }

    static native void destroyHandle(long var0);

    private static native long loadBacktraceData(long var0, long var2, @NonNull IProgressMonitorFactory var4, @NonNull String @Nullable [] var5, @NonNull String @Nullable [] var6, int @Nullable [] var7, int @Nullable [] var8, int @Nullable [] var9, int @Nullable [] var10, long @Nullable [] var11, long @Nullable [] var12, long @Nullable [] var13, long @Nullable [] var14, long var15, long var17, long var19, boolean var21);

    private static native long loadSPEData(long var0, long var2, @NonNull IProgressMonitorFactory var4, @NonNull String @Nullable [] var5, @NonNull String @Nullable [] var6, int @Nullable [] var7, int @Nullable [] var8, int @Nullable [] var9, int @Nullable [] var10, long @Nullable [] var11, long @Nullable [] var12, long @Nullable [] var13, long @Nullable [] var14, long var15, long var17, long var19, boolean var21);

    private static native int getNumberOfBacktraceColumns(long var0);

    private static native int getNumberOfSPEColumns(long var0);

    private static native void populateBacktraceColumns(long var0, @NonNull ReportColumn @NonNull [] var2);

    private static native void populateSPEColumns(long var0, @NonNull ReportColumn @NonNull [] var2);

    private static native @Nullable SymbolProperties getBacktraceReportSymbolProperties(long var0, long var2);

    private static native @Nullable SymbolProperties getSPEReportSymbolProperties(long var0, long var2);

    private static native void populateBacktraceRowColumnValues(long var0, long @NonNull [] var2, long @NonNull [] var3, @NonNull Number @NonNull [] var4);

    private static native void populateSPERowColumnValues(long var0, long @NonNull [] var2, long @NonNull [] var3, @NonNull Number @NonNull [] var4);

    private static final @NonNull String @Nullable [] toStringList(@Nullable Set<@NonNull Pattern> set) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        String[] stringArray = new String[set.size()];
        int n = 0;
        for (Pattern pattern : set) {
            stringArray[n++] = pattern.pattern();
        }
        return stringArray;
    }

    private static long toRangeFrom(@Nullable Long l) {
        if (l == null || l < 0L) {
            return -1L;
        }
        return l;
    }

    private static long toRangeTo(@Nullable Long l) {
        if (l == null) {
            return Long.MAX_VALUE;
        }
        if (l < 0L) {
            return -1L;
        }
        return l;
    }

    private ApcReport(long l) {
        this.nativeHandle = new NativeHandle(l, ApcReport::destroyHandle);
    }

    @Override
    public void close() throws Exception {
        this.nativeHandle.close();
    }

    public @Nullable ProfileReportData loadBacktrace(@NonNull ProfilingFilterParams profilingFilterParams, @NonNull ProfilingLoadOptions profilingLoadOptions, @NonNull CancellationPredicate cancellationPredicate, @NonNull IProgressMonitorFactory iProgressMonitorFactory) throws CodecException, IOException {
        return this.nativeHandle.doWith(l -> cancellationPredicate.doWith(l2 -> {
            long l3 = ApcReport.loadBacktraceData(l, l2, iProgressMonitorFactory, ApcReport.toStringList(profilingFilterParams.filterProcessNames()), ApcReport.toStringList(profilingFilterParams.filterThreadNames()), profilingFilterParams.filterPidsIncluded(), profilingFilterParams.filterPidsExcluded(), profilingFilterParams.filterTidsIncluded(), profilingFilterParams.filterTidsExcluded(), profilingFilterParams.filterUPidsIncluded(), profilingFilterParams.filterUPidsExcluded(), profilingFilterParams.filterUTidsIncluded(), profilingFilterParams.filterUTidsExcluded(), ApcReport.toRangeFrom(profilingFilterParams.timeRangeFrom()), ApcReport.toRangeTo(profilingFilterParams.timeRangeTo()), profilingLoadOptions.nestedMetricFilter(), profilingLoadOptions.useInlinedSymbols());
            if (l3 == 0L) {
                return null;
            }
            return ProfileReportData.fromHandle(this, l3, false);
        }));
    }

    public @Nullable ProfileReportData loadSPE(@NonNull ProfilingFilterParams profilingFilterParams, @NonNull ProfilingLoadOptions profilingLoadOptions, @NonNull CancellationPredicate cancellationPredicate, @NonNull IProgressMonitorFactory iProgressMonitorFactory) throws CodecException, IOException {
        return this.nativeHandle.doWith(l -> cancellationPredicate.doWith(l2 -> {
            long l3 = ApcReport.loadSPEData(l, l2, iProgressMonitorFactory, ApcReport.toStringList(profilingFilterParams.filterProcessNames()), ApcReport.toStringList(profilingFilterParams.filterThreadNames()), profilingFilterParams.filterPidsIncluded(), profilingFilterParams.filterPidsExcluded(), profilingFilterParams.filterTidsIncluded(), profilingFilterParams.filterTidsExcluded(), profilingFilterParams.filterUPidsIncluded(), profilingFilterParams.filterUPidsExcluded(), profilingFilterParams.filterUTidsIncluded(), profilingFilterParams.filterUTidsExcluded(), ApcReport.toRangeFrom(profilingFilterParams.timeRangeFrom()), ApcReport.toRangeTo(profilingFilterParams.timeRangeTo()), profilingLoadOptions.nestedMetricFilter(), profilingLoadOptions.useInlinedSymbols());
            if (l3 == 0L) {
                return null;
            }
            return ProfileReportData.fromHandle(this, l3, true);
        }));
    }

    public @NonNull ReportColumn @NonNull [] getBacktraceColumns() {
        try {
            return this.nativeHandle.doWith(l -> {
                int n = ApcReport.getNumberOfBacktraceColumns(l);
                ReportColumn[] reportColumnArray = new ReportColumn[n];
                if (n > 0) {
                    ApcReport.populateBacktraceColumns(l, reportColumnArray);
                }
                return reportColumnArray;
            });
        }
        catch (CodecException | IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public @NonNull ReportColumn @NonNull [] getSPEColumns() {
        try {
            return this.nativeHandle.doWith(l -> {
                int n = ApcReport.getNumberOfSPEColumns(l);
                ReportColumn[] reportColumnArray = new ReportColumn[n];
                if (n > 0) {
                    ApcReport.populateSPEColumns(l, reportColumnArray);
                }
                return reportColumnArray;
            });
        }
        catch (CodecException | IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public @Nullable SymbolProperties getBacktraceReportSymbolProperties(long l) {
        return this.nativeHandle.doWith(l2 -> ApcReport.getBacktraceReportSymbolProperties(l2, l));
    }

    public @Nullable SymbolProperties getSPEReportSymbolProperties(long l) {
        return this.nativeHandle.doWith(l2 -> ApcReport.getSPEReportSymbolProperties(l2, l));
    }

    @NonNull Number @NonNull [] computeBacktraceCellValues(long @NonNull [] lArray, long @NonNull [] lArray2) {
        return this.nativeHandle.doWith(l -> {
            int n = ApcReport.getNumberOfBacktraceColumns(l);
            Number[] numberArray = new Number[n];
            ApcReport.populateBacktraceRowColumnValues(l, lArray, lArray2, numberArray);
            return numberArray;
        });
    }

    @NonNull Number @NonNull [] computeSPECellValues(long @NonNull [] lArray, long @NonNull [] lArray2) {
        return this.nativeHandle.doWith(l -> {
            int n = ApcReport.getNumberOfSPEColumns(l);
            Number[] numberArray = new Number[n];
            ApcReport.populateSPERowColumnValues(l, lArray, lArray2, numberArray);
            return numberArray;
        });
    }

    static {
        boolean bl = $assertionsDisabled = !ApcReport.class.desiredAssertionStatus();
        if (!StreamlineLib.isLoaded) {
            throw new AssertionError((Object)"Failed to load Streamline JNI lib");
        }
    }
}

