/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util.tree;

import com.arm.util.HexNumberHelper;
import com.arm.util.Unsigned;
import com.arm.util.tree.IInterval;

public class UnsignedIntInterval
implements IInterval<Integer> {
    private final int start;
    private final int end;

    public UnsignedIntInterval(int start, int end) {
        this.start = start;
        this.end = end;
        if (Unsigned.less64(this.end, this.start)) {
            String error = "end < start: " + end + " < " + start;
            throw new IllegalArgumentException(error);
        }
    }

    @Override
    public Integer getStart() {
        return this.start;
    }

    @Override
    public Integer getEnd() {
        return this.end;
    }

    @Override
    public boolean contains(Integer point) {
        return Unsigned.lessOrEq64(this.start, point.intValue()) && Unsigned.greaterOrEq64(this.end, point.intValue());
    }

    @Override
    public boolean overlaps(IInterval<Integer> interval) {
        return !Unsigned.less64((long)interval.getEnd().intValue() & 0xFFFFFFFFL, (long)this.start & 0xFFFFFFFFL) && !Unsigned.less64((long)this.getEnd().intValue() & 0xFFFFFFFFL, (long)interval.getStart().intValue() & 0xFFFFFFFFL);
    }

    @Override
    public int compareTo(IInterval<Integer> interval) {
        int implStart = interval.getStart();
        int implEnd = interval.getEnd();
        int compareStart = Integer.compareUnsigned(this.start, implStart);
        if (compareStart != 0) {
            return compareStart;
        }
        return Integer.compareUnsigned(this.end, implEnd);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.end;
        result = 31 * result + this.start;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnsignedIntInterval other = (UnsignedIntInterval)obj;
        if (this.end != other.end) {
            return false;
        }
        return this.start == other.start;
    }

    public String toString() {
        String hexStart = HexNumberHelper.longToHexString(this.start);
        String hexEnd = HexNumberHelper.longToHexString(this.end);
        return String.format("[%s; %s]", hexStart, hexEnd);
    }
}

