/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util.tree;

import com.arm.util.tree.IInterval;

final class SinglePointInterval<Point extends Comparable<Point>>
implements IInterval<Point> {
    private final Point point;

    SinglePointInterval(Point point) {
        this.point = point;
    }

    @Override
    public boolean contains(Point p) {
        return this.point.equals(p);
    }

    @Override
    public Point getEnd() {
        return this.point;
    }

    @Override
    public Point getStart() {
        return this.point;
    }

    @Override
    public boolean overlaps(IInterval<Point> interval) {
        return interval.contains(this.point);
    }

    public int hashCode() {
        return this.point.hashCode();
    }

    public boolean equals(Object obj) {
        IInterval interval;
        boolean equals = this == obj ? true : (obj instanceof IInterval ? this.compareTo(interval = (IInterval)obj) == 0 : false);
        return equals;
    }

    @Override
    public int compareTo(IInterval<Point> interval) {
        int startCompare = this.point.compareTo(interval.getStart());
        if (startCompare != 0) {
            return startCompare;
        }
        Point end = this.getEnd();
        if (end == null) {
            return interval.getEnd() == null ? 0 : -1;
        }
        Point otherEnd = interval.getEnd();
        return otherEnd == null ? 1 : end.compareTo(otherEnd);
    }
}

