/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util.tree;

import com.arm.util.tree.Filter;
import com.arm.util.tree.Node;
import com.arm.util.tree.SimpleNode;
import com.arm.util.tree.Tree;
import java.util.Collection;
import java.util.List;

public class SimpleTree<E>
implements Tree<E> {
    private final Node<E> treeRoot = new SimpleNode<Object>(null);

    @Override
    public void addRoot(Node<E> root) {
        this.treeRoot.addChild(root);
    }

    @Override
    public void addRoots(Collection<Node<E>> roots) {
        this.treeRoot.addChildren(roots);
    }

    @Override
    public Node<E> getRoot(int index) {
        return this.treeRoot.getChild(index);
    }

    @Override
    public List<Node<E>> find(E object) {
        return this.treeRoot.find(object, true);
    }

    @Override
    public List<Node<E>> getRoots() {
        return this.treeRoot.getChildren();
    }

    @Override
    public List<Node<E>> getAllChildren() {
        return this.treeRoot.getChildren(true);
    }

    @Override
    public List<Node<E>> getAllChildren(Filter<E> filter) {
        return this.treeRoot.getChildren(true, filter);
    }

    @Override
    public void removeRoot(int index) {
        this.treeRoot.removeChild(index);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Node<E> root : this.getRoots()) {
            ((SimpleNode)root).stringify(root, builder, 0);
        }
        return builder.toString();
    }
}

