/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util.tree;

import com.arm.util.tree.Entry;
import com.arm.util.tree.IOverlappingPrimitiveIntervalTree;
import com.arm.util.tree.LLRBUnsignedInt64IntervalTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class OverlappingUnsignedInt64IntervalTree<Value>
implements IOverlappingPrimitiveIntervalTree<Value> {
    private final OverlappingLLRBUnsignedInt64IntervalTree tree = new OverlappingLLRBUnsignedInt64IntervalTree();
    private int size;

    @Override
    public void add(long start, long end, Value value, boolean unique) {
        Object[] values = (Object[])this.tree.get(start, end);
        if (values == null) {
            values = new Object[]{value};
            this.tree.put(start, end, values);
            ++this.size;
        } else {
            this.update(start, end, this.add(values, value, unique));
        }
    }

    protected LLRBUnsignedInt64IntervalTree.Node<Object[]> createNode(long start, long end, Object[] value) {
        return new LLRBUnsignedInt64IntervalTree.Node<Object[]>(start, end, value);
    }

    @Override
    public void remove(long start, long end, Value value) {
        Object[] values = (Object[])this.tree.get(start, end);
        if (values != null) {
            this.update(start, end, this.remove(values, value));
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Set<Value> find(long point) {
        HashSet result = new HashSet();
        this.search(this.tree.getRoot(), point, result);
        return result;
    }

    @Override
    public Collection<Entry<Value>> findWithRange(long point) {
        HashSet<LLRBUnsignedInt64IntervalTree.Node<Object[]>> nodes = new HashSet<LLRBUnsignedInt64IntervalTree.Node<Object[]>>();
        this.searchWithNode(this.tree.getRoot(), point, nodes);
        ArrayList<Entry<Value>> result = new ArrayList<Entry<Value>>(nodes.size());
        for (LLRBUnsignedInt64IntervalTree.Node node : nodes) {
            Object[] objectArray = (Object[])node.value;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object v = objectArray[n2];
                result.add(new Entry<Object>(v, node.start, node.end));
                ++n2;
            }
        }
        return result;
    }

    @Override
    public Set<Value> findNearestLeft(long point) {
        HashSet result = new HashSet();
        LLRBUnsignedInt64IntervalTree.Node<Object[]> foundNode = this.searchNearest(this.tree.getRoot(), point);
        if (foundNode != null) {
            this.searchStartsWith(this.tree.getRoot(), foundNode.start, result);
        }
        return result;
    }

    private void update(long start, long end, Object[] newValues) {
        if (newValues != null) {
            if (newValues.length == 0) {
                this.tree.remove(start, end);
            } else {
                this.tree.put(start, end, newValues);
            }
        }
    }

    private void searchWithNode(LLRBUnsignedInt64IntervalTree.Node<Object[]> node, long point, Set<LLRBUnsignedInt64IntervalTree.Node<Object[]>> result) {
        if (node == null) {
            return;
        }
        long rightmost = ((OverlappingLLRBUnsignedInt64IntervalTree.OverlappingNode)node).getMaximumEnd();
        if (point > rightmost ^ point < 0L ^ rightmost < 0L) {
            return;
        }
        this.searchWithNode(node.left, point, result);
        if (point >= node.start ^ point < 0L ^ node.start < 0L && point <= node.end ^ point < 0L ^ node.end < 0L) {
            result.add(node);
        }
        if (point < node.start ^ point < 0L ^ node.start < 0L) {
            return;
        }
        this.searchWithNode(node.right, point, result);
    }

    private void search(LLRBUnsignedInt64IntervalTree.Node<Object[]> node, long point, Set<Value> result) {
        if (node == null) {
            return;
        }
        long rightmost = ((OverlappingLLRBUnsignedInt64IntervalTree.OverlappingNode)node).getMaximumEnd();
        if (point > rightmost ^ point < 0L ^ rightmost < 0L) {
            return;
        }
        this.search(node.left, point, result);
        if (point >= node.start ^ point < 0L ^ node.start < 0L && point <= node.end ^ point < 0L ^ node.end < 0L) {
            Object[] objectArray = (Object[])node.value;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                result.add(value);
                ++n2;
            }
        }
        if (point < node.start ^ point < 0L ^ node.start < 0L) {
            return;
        }
        this.search(node.right, point, result);
    }

    private LLRBUnsignedInt64IntervalTree.Node<Object[]> searchNearest(LLRBUnsignedInt64IntervalTree.Node<Object[]> node, long point) {
        if (node == null) {
            return null;
        }
        LLRBUnsignedInt64IntervalTree.Node<Object[]> found = null;
        if (point == node.start) {
            found = node;
        } else if (point < node.start ^ point < 0L ^ node.start < 0L) {
            found = this.searchNearest(node.left, point);
            if (found == null) {
                found = this.searchNearest(node.right, point);
            }
        } else {
            found = this.searchNearest(node.right, point);
            if (found == null) {
                found = this.searchNearest(node.left, point);
            }
            if (found == null || found.start < node.start ^ found.start < 0L ^ node.start < 0L) {
                found = node;
            }
        }
        return found;
    }

    private void searchStartsWith(LLRBUnsignedInt64IntervalTree.Node<Object[]> node, long start, Set<Value> result) {
        if (node == null) {
            return;
        }
        if (start == node.start) {
            Object[] objectArray = (Object[])node.value;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                result.add(value);
                ++n2;
            }
            this.searchStartsWith(node.left, start, result);
            this.searchStartsWith(node.right, start, result);
        } else if (start < node.start ^ start < 0L ^ node.start < 0L) {
            this.searchStartsWith(node.left, start, result);
        } else {
            this.searchStartsWith(node.right, start, result);
        }
    }

    private int indexOf(Object[] values, Object value) {
        int i = 0;
        while (i < values.length) {
            if (value.equals(values[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private Object[] add(Object[] values, Value value, boolean unique) {
        if (unique || this.indexOf(values, value) == -1) {
            int newLength = values.length + 1;
            Object[] newValues = new Object[newLength];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[values.length] = value;
            ++this.size;
            return newValues;
        }
        return null;
    }

    private Object[] remove(Object[] values, Value value) {
        int index = this.indexOf(values, value);
        if (index == -1) {
            return null;
        }
        int newLength = values.length - 1;
        values[index] = values[newLength];
        Object[] newValues = new Object[newLength];
        System.arraycopy(values, 0, newValues, 0, newLength);
        --this.size;
        return newValues;
    }

    void setChecked() {
        this.tree.checkTree(true);
    }

    static class OverlappingLLRBUnsignedInt64IntervalTree
    extends LLRBUnsignedInt64IntervalTree<Object[]> {
        OverlappingLLRBUnsignedInt64IntervalTree() {
        }

        @Override
        protected LLRBUnsignedInt64IntervalTree.Node<Object[]> createNode(long start, long end, Object[] value) {
            return new OverlappingNode(start, end, value);
        }

        public static class OverlappingNode
        extends LLRBUnsignedInt64IntervalTree.Node<Object[]> {
            boolean computedMaxEnd = false;
            private long maxEnd;

            OverlappingNode(long start, long end, Object[] value) {
                super(start, end, value);
            }

            long getMaximumEnd() {
                if (!this.computedMaxEnd) {
                    long maxRight;
                    long maxLeft;
                    long end = this.end;
                    if (this.start == end) {
                        end = this.start;
                    }
                    if (this.left != null && end < (maxLeft = ((OverlappingNode)this.left).getMaximumEnd()) ^ end < 0L ^ maxLeft < 0L) {
                        end = maxLeft;
                    }
                    if (this.right != null && end < (maxRight = ((OverlappingNode)this.right).getMaximumEnd()) ^ end < 0L ^ maxRight < 0L) {
                        end = maxRight;
                    }
                    this.maxEnd = end;
                    this.computedMaxEnd = true;
                }
                return this.maxEnd;
            }

            @Override
            void changed() {
                this.computedMaxEnd = false;
            }
        }
    }
}

