/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util.tree;

import com.arm.util.tree.IInterval;
import com.arm.util.tree.OverlappingIntervalException;
import com.arm.util.tree.SinglePointInterval;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class NonOverlappingIntervalTree<Point extends Comparable<Point>, Value> {
    private final TreeMap<IInterval<Point>, Value> tree = new TreeMap();
    private boolean checkForOverlapsOnInsertion;

    public NonOverlappingIntervalTree() {
    }

    public NonOverlappingIntervalTree(NonOverlappingIntervalTree<Point, Value> other) {
        this.tree.putAll(other.tree);
    }

    public void checkForOverlapsOnInsertion(boolean check) {
        this.checkForOverlapsOnInsertion = check;
    }

    public void add(IInterval<Point> interval, Value value) throws OverlappingIntervalException {
        if (this.checkForOverlapsOnInsertion && !this.find(interval).isEmpty()) {
            throw new OverlappingIntervalException();
        }
        this.tree.put(interval, value);
    }

    public void addAll(NonOverlappingIntervalTree<Point, Value> other) throws OverlappingIntervalException {
        for (Map.Entry<IInterval<Point>, Value> entry : other.tree.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public void remove(IInterval<Point> interval) {
        this.tree.remove(interval);
    }

    public void clear() {
        this.tree.clear();
    }

    public Entry<Point, Value> find(Point point) {
        SinglePointInterval<Point> interval = new SinglePointInterval<Point>(point);
        List<Entry<Point, Value>> entries = this.find(interval);
        return entries.size() > 0 ? entries.get(0) : null;
    }

    public List<Entry<Point, Value>> find(IInterval<Point> interval) {
        ArrayList<Entry<Point, Value>> result = new ArrayList<Entry<Point, Value>>();
        Value exactMatch = this.tree.get(interval);
        if (exactMatch != null) {
            result.add(new Entry<Point, Value>(interval, exactMatch));
        } else {
            IInterval<Point> prev = this.tree.lowerKey(interval);
            if (prev != null && prev.overlaps(interval)) {
                result.add(new Entry<Point, Value>(prev, this.tree.get(prev)));
            }
            IInterval<Point> next = this.tree.higherKey(interval);
            while (next != null) {
                if (next.overlaps(interval)) {
                    result.add(new Entry<Point, Value>(next, this.tree.get(next)));
                }
                if (interval.compareComponents(interval.getEnd(), next.getStart()) <= 0) break;
                next = this.tree.higherKey(next);
            }
        }
        return result;
    }

    public Entry<Point, Value> findLower(Point point) {
        SinglePointInterval<Point> interval = new SinglePointInterval<Point>(point);
        IInterval key = this.tree.ceilingKey(interval);
        if (key != null && key.overlaps(interval)) {
            return new Entry(key, this.tree.get(key));
        }
        key = this.tree.floorKey(interval);
        return key == null ? null : new Entry(key, this.tree.get(key));
    }

    public Entry<Point, Value> findHigher(Point point) {
        SinglePointInterval<Point> interval = new SinglePointInterval<Point>(point);
        IInterval key = this.tree.floorKey(interval);
        if (key != null && key.overlaps(interval)) {
            return new Entry(key, this.tree.get(key));
        }
        key = this.tree.ceilingKey(interval);
        return key == null ? null : new Entry(key, this.tree.get(key));
    }

    public List<Value> values() {
        return new ArrayList<Value>(this.tree.values());
    }

    public List<Entry<Point, Value>> entries() {
        Set<Map.Entry<IInterval<Point>, Value>> internalEntries = this.tree.entrySet();
        ArrayList<Entry<Point, Value>> entries = new ArrayList<Entry<Point, Value>>(internalEntries.size());
        for (Map.Entry<IInterval<Point>, Value> entry : internalEntries) {
            entries.add(new Entry<Point, Value>(entry.getKey(), entry.getValue()));
        }
        return entries;
    }

    public int size() {
        return this.tree.size();
    }

    public static class Entry<P extends Comparable<P>, V> {
        private final IInterval<P> interval;
        private final V value;

        public Entry(IInterval<P> interval, V value) {
            this.interval = interval;
            this.value = value;
        }

        public IInterval<P> getInterval() {
            return this.interval;
        }

        public V getValue() {
            return this.value;
        }
    }
}

