/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util.tree;

public class LLRBUnsignedInt32Tree<Value> {
    private Node<Value> root;
    private int size;
    private boolean checkTree;

    void checkTree(boolean checkTree) {
        this.checkTree = checkTree;
    }

    protected Node<Value> getRoot() {
        return this.root;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public boolean contains(long key) {
        return this.get(this.root, 0xFFFFFFFFL & key) != null;
    }

    public Value get(long key) {
        return this.get(this.root, 0xFFFFFFFFL & key);
    }

    private Value get(Node<Value> x, long key) {
        return x == null ? null : (key == x.key ? (Value)x.value : (key < x.key ? (Value)this.get(x.left, key) : (Value)this.get(x.right, key)));
    }

    public Node<Value> min() {
        return this.root == null ? null : this.min(this.root);
    }

    private Node<Value> min(Node<Value> x) {
        return x.left == null ? x : this.min(x.left);
    }

    public Node<Value> max() {
        return this.root == null ? null : this.max(this.root);
    }

    protected Node<Value> max(Node<Value> x) {
        return x.right == null ? x : this.max(x.right);
    }

    public void put(long key, Value value) {
        this.root = this.insert(this.root, 0xFFFFFFFFL & key, value);
        this.root.isRed = false;
        if (this.checkTree) {
            this.check();
        }
    }

    private Node<Value> insert(Node<Value> h, long key, Value value) {
        if (h == null) {
            ++this.size;
            return this.createNode(key, value);
        }
        h.changed();
        if (key == h.key) {
            h.value = value;
        } else if (key < h.key) {
            h.left = this.insert(h.left, key, value);
        } else {
            h.right = this.insert(h.right, key, value);
        }
        if (this.isRed(h.right)) {
            h = this.rotateLeft(h);
        }
        if (this.isRed(h.left) && this.isRed(h.left.left)) {
            h = this.rotateRight(h);
        }
        if (this.isRed(h.left) && this.isRed(h.right)) {
            this.colorFlip(h);
        }
        return h;
    }

    protected Node<Value> createNode(long key, Value value) {
        return new Node<Value>(0xFFFFFFFFL & key, value);
    }

    public void removeMin() {
        if (this.root != null) {
            this.root = this.removeMin(this.root);
            if (this.root != null) {
                this.root.isRed = false;
            }
        }
    }

    private Node<Value> removeMin(Node<Value> h) {
        if (h.left == null) {
            --this.size;
            return null;
        }
        if (!this.isRed(h.left) && !this.isRed(h.left.left)) {
            h = this.moveRedLeft(h);
        }
        h.left = this.removeMin(h.left);
        return this.fixUp(h);
    }

    public void removeMax() {
        if (this.root != null) {
            this.root = this.removeMax(this.root);
            if (this.root != null) {
                this.root.isRed = false;
            }
        }
    }

    private Node<Value> removeMax(Node<Value> h) {
        if (this.isRed(h.left)) {
            h = this.rotateRight(h);
        }
        if (h.right == null) {
            --this.size;
            return null;
        }
        if (!this.isRed(h.right) && !this.isRed(h.right.left)) {
            h = this.moveRedRight(h);
        }
        h.right = this.removeMax(h.right);
        return this.fixUp(h);
    }

    public void remove(long key) {
        if (this.root != null) {
            this.root = this.remove(this.root, 0xFFFFFFFFL & key);
            if (this.root != null) {
                this.root.isRed = false;
            }
            if (this.checkTree) {
                this.check();
            }
        }
    }

    private Node<Value> remove(Node<Value> h, long key) {
        if (h == null) {
            return null;
        }
        h.changed();
        if (key < h.key) {
            if (!this.isRed(h.left) && h.left != null && !this.isRed(h.left.left)) {
                h = this.moveRedLeft(h);
            }
            h.left = this.remove(h.left, key);
        } else {
            if (this.isRed(h.left)) {
                h = this.rotateRight(h);
            }
            if (key == h.key && h.right == null) {
                --this.size;
                return null;
            }
            if (!this.isRed(h.right) && h.right != null && !this.isRed(h.right.left)) {
                h = this.moveRedRight(h);
            }
            if (key == h.key) {
                Node min = this.min(h.right);
                h.value = this.get(h.right, min.key);
                h.key = min.key;
                h.right = this.removeMin(h.right);
            } else {
                h.right = this.remove(h.right, key);
            }
        }
        return this.fixUp(h);
    }

    private boolean isRed(Node<Value> x) {
        return x == null ? false : x.isRed;
    }

    private void colorFlip(Node<Value> h) {
        h.isRed = !h.isRed;
        h.left.isRed = !h.left.isRed;
        h.right.isRed = !h.right.isRed;
    }

    private Node<Value> rotateLeft(Node<Value> h) {
        Node x = h.right;
        h.right = x.left;
        x.left = h;
        x.isRed = x.left.isRed;
        x.left.isRed = true;
        x.changed();
        h.changed();
        return x;
    }

    private Node<Value> rotateRight(Node<Value> h) {
        Node x = h.left;
        h.left = x.right;
        x.right = h;
        x.isRed = x.right.isRed;
        x.right.isRed = true;
        x.changed();
        h.changed();
        return x;
    }

    private Node<Value> moveRedLeft(Node<Value> h) {
        this.colorFlip(h);
        if (this.isRed(h.right.left)) {
            h.right = this.rotateRight(h.right);
            h = this.rotateLeft(h);
            this.colorFlip(h);
        }
        return h;
    }

    private Node<Value> moveRedRight(Node<Value> h) {
        this.colorFlip(h);
        if (this.isRed(h.left.left)) {
            h = this.rotateRight(h);
            this.colorFlip(h);
        }
        return h;
    }

    private Node<Value> fixUp(Node<Value> h) {
        if (this.isRed(h.right)) {
            h = this.rotateLeft(h);
        }
        if (this.isRed(h.left) && this.isRed(h.left.left)) {
            h = this.rotateRight(h);
        }
        if (this.isRed(h.left) && this.isRed(h.right)) {
            this.colorFlip(h);
        }
        return h;
    }

    void check() {
        if (!(this.isBST() && this.is234() && this.isBalanced())) {
            throw new RuntimeException("tree integrity checks failed");
        }
    }

    private boolean isBST() {
        return this.isBST(this.root, this.min(), this.max());
    }

    private boolean isBST(Node<Value> x, Node<Value> min, Node<Value> max) {
        if (x == null) {
            return true;
        }
        if (x.key < min.key || max.key < x.key) {
            return false;
        }
        return this.isBST(x.left, min, x) && this.isBST(x.right, x, max);
    }

    private boolean is234() {
        return this.is234(this.root);
    }

    private boolean is234(Node<Value> x) {
        if (x == null) {
            return true;
        }
        if (this.isRed(x.right)) {
            return false;
        }
        if (this.isRed(x) && this.isRed(x.left) && this.isRed(x.left.left)) {
            return false;
        }
        return this.is234(x.left) && this.is234(x.right);
    }

    private boolean isBalanced() {
        int black = 0;
        Node<Value> x = this.root;
        while (x != null) {
            if (!this.isRed(x)) {
                ++black;
            }
            x = x.left;
        }
        return this.isBalanced(this.root, black);
    }

    private boolean isBalanced(Node<Value> x, int black) {
        if (x == null && black == 0) {
            return true;
        }
        if (x == null && black != 0) {
            return false;
        }
        if (!this.isRed(x)) {
            --black;
        }
        return x != null && this.isBalanced(x.left, black) && this.isBalanced(x.right, black);
    }

    protected static class Node<Value> {
        long key;
        Value value;
        Node<Value> left;
        Node<Value> right;
        boolean isRed = true;

        Node(long key, Value value) {
            this.key = 0xFFFFFFFFL & key;
            this.value = value;
        }

        void changed() {
        }
    }
}

