/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util.preprocessor;

import com.arm.util.preprocessor.Token;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Iterator;

public class JavaTokenizer
implements Iterator<Token> {
    private final StreamTokenizer tokenizer;
    private int currentTokenType;
    private String nextToken;

    public JavaTokenizer(Reader reader) throws IOException {
        this.tokenizer = new StreamTokenizer(reader);
        this.tokenizer.eolIsSignificant(true);
        this.currentTokenType = this.tokenizer.ttype;
        this.tokenizer.ordinaryChar(34);
        this.tokenizer.ordinaryChar(39);
        this.tokenizer.ordinaryChar(32);
        this.tokenizer.ordinaryChar(9);
        this.tokenizer.ordinaryChar(47);
        this.tokenizer.ordinaryChar(46);
        this.tokenizer.ordinaryChar(45);
        this.tokenizer.ordinaryChars(48, 57);
        this.tokenizer.wordChars(95, 95);
        this.tokenizer.wordChars(48, 57);
        this.tokenizer.nextToken();
        this.currentTokenType = this.tokenizer.ttype;
        this.getTokenContents();
    }

    @Override
    public boolean hasNext() {
        return this.currentTokenType != -1;
    }

    @Override
    public Token next() {
        Token result = new Token(this.nextToken, this.currentTokenType);
        try {
            this.tokenizer.nextToken();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.currentTokenType = this.tokenizer.ttype;
        this.getTokenContents();
        return result;
    }

    private void getTokenContents() {
        switch (this.currentTokenType) {
            case -1: {
                break;
            }
            case 10: {
                this.nextToken = "\n";
                break;
            }
            case -3: 
            case -2: {
                this.nextToken = this.tokenizer.sval;
                break;
            }
            default: {
                this.nextToken = Character.toString((char)this.currentTokenType);
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

