/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util.misc;

import com.arm.util.misc.TablePrinterException;
import java.util.ArrayList;
import java.util.List;

public class TablePrinter {
    private final List<List<Object>> rows;
    private final int columns;
    private final String LS;
    private static final String EMPTY = "";

    public TablePrinter(int columnCount, String lineSeparator) throws TablePrinterException {
        if (columnCount <= 0) {
            throw new TablePrinterException();
        }
        this.columns = columnCount;
        this.LS = lineSeparator;
        this.rows = new ArrayList<List<Object>>();
    }

    public void addRow(List<? extends Object> row) throws TablePrinterException {
        if (row == null) {
            throw new TablePrinterException();
        }
        ArrayList<Object> object = new ArrayList<Object>();
        int i = 0;
        while (i < this.columns) {
            if (i >= row.size() || row.get(i) == null) {
                object.add(EMPTY);
            } else {
                object.add(row.get(i));
            }
            ++i;
        }
        this.rows.add(object);
    }

    public String printTable() {
        String[] row;
        int[] maxColumnWidths = new int[this.columns];
        String[][] data = new String[this.rows.size()][this.columns];
        int i = 0;
        while (i < this.rows.size()) {
            String[] dataRow = data[i];
            row = this.rows.get(i);
            int j = 0;
            while (j < this.columns) {
                dataRow[j] = row.get(j).toString();
                int length = dataRow[j].length();
                if (length > maxColumnWidths[j]) {
                    maxColumnWidths[j] = length;
                }
                ++j;
            }
            ++i;
        }
        StringBuilder b = new StringBuilder();
        String separator = EMPTY;
        String[][] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            row = stringArray[n2];
            b.append(separator);
            int i2 = 0;
            while (i2 < this.columns) {
                int startCell = b.length();
                int indent = maxColumnWidths[i2];
                b.append(row[i2]);
                TablePrinter.padBuilderTo(b, startCell, i2 == this.columns - 1 ? indent : indent + 1);
                ++i2;
            }
            separator = this.LS;
            ++n2;
        }
        return b.toString();
    }

    private static void padBuilderTo(StringBuilder builder, int pad, int start) {
        int i = builder.length();
        while (i < start + pad) {
            builder.append(' ');
            ++i;
        }
    }
}

