/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util.libs;

import com.arm.io.Files;
import com.arm.io.JVMTempFolder;
import com.arm.util.Tuple;
import com.arm.util.libs.AbstractURLResolver;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class JarURLResolver
extends AbstractURLResolver {
    @Override
    public String getSupportedProtocol() {
        return "jar";
    }

    private Tuple<String, String> parse(URL url) throws IOException {
        int lastCharIndex;
        String path;
        this.checkSupportedProtocol(url);
        URL fileURL = new URL(url.getPath());
        try {
            path = fileURL.toURI().getSchemeSpecificPart();
        }
        catch (URISyntaxException uRISyntaxException) {
            path = fileURL.getPath();
        }
        int mark = path.indexOf(33);
        String jar = path.substring(0, mark);
        String entry = path.substring(mark + 2);
        if (!entry.isEmpty() && entry.charAt(lastCharIndex = entry.length() - 1) == '/') {
            entry = entry.substring(0, lastCharIndex);
        }
        return new Tuple<String, String>(jar, entry);
    }

    @Override
    public String getPhysicalPath(URL url) throws IOException {
        return (String)this.parse((URL)url).tb;
    }

    @Override
    public File resolve(URL url) throws IOException {
        return this.resolve(url, null);
    }

    @Override
    public File resolve(URL url, File targetDir) throws IOException {
        Tuple<String, String> parsed = this.parse(url);
        return this.extract(new File((String)parsed.ta), (String)parsed.tb, targetDir);
    }

    protected File extract(File jarFile, String entry, File targetDir) throws IOException {
        if (targetDir == null) {
            targetDir = JVMTempFolder.getJVMTempFolder();
        } else {
            Files.mkdirs(targetDir);
        }
        ZipFile zipFile = new ZipFile(jarFile);
        FileInputStream fis = new FileInputStream(jarFile);
        BufferedInputStream bis = new BufferedInputStream(fis);
        ZipInputStream zis = new ZipInputStream(bis);
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            block7: {
                File extractedFile;
                block9: {
                    block8: {
                        String entryName = ze.getName();
                        if (!entryName.startsWith(entry)) break block7;
                        extractedFile = new File(targetDir, entryName);
                        if (!ze.isDirectory()) break block8;
                        Files.mkdirs(extractedFile);
                        break block7;
                    }
                    if (!extractedFile.exists()) break block9;
                    if (extractedFile.lastModified() == ze.getTime()) break block7;
                    Files.delete(extractedFile);
                }
                Files.mkdirs(extractedFile.getParentFile());
                Files.createFile(extractedFile);
                InputStream is = zipFile.getInputStream(ze);
                Files.copy(is, extractedFile);
                is.close();
                if (ze.getTime() != -1L) {
                    extractedFile.setLastModified(ze.getTime());
                }
            }
            ze = zis.getNextEntry();
        }
        zis.close();
        zipFile.close();
        return new File(targetDir, entry);
    }
}

