/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util.libs;

import com.arm.io.Files;
import com.arm.util.libs.AbstractURLResolver;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;

public class FileURLResolver
extends AbstractURLResolver {
    @Override
    public String getSupportedProtocol() {
        return "file";
    }

    @Override
    public String getPhysicalPath(URL url) throws IOException {
        return URLDecoder.decode(url.getPath(), "UTF8");
    }

    @Override
    public File resolve(URL url) throws IOException {
        this.checkSupportedProtocol(url);
        return new File(this.getPhysicalPath(url));
    }

    @Override
    public File resolve(URL url, File targetDir) throws IOException {
        File result;
        File file = this.resolve(url);
        if (targetDir == null) {
            result = file;
        } else {
            Files.mkdirs(targetDir);
            result = new File(targetDir, file.getName());
            Files.copy(file, result, false, true);
        }
        return result;
    }
}

