/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import java.io.IOException;

public class UnEscaper {
    public static final String unEscape(String input) throws IOException {
        StringBuilder result = new StringBuilder();
        LastChar lastChar = LastChar.ORDINARY_CHAR;
        int index = 0;
        while (index < input.length()) {
            char c = input.charAt(index);
            switch (lastChar) {
                case ORDINARY_CHAR: {
                    if (c == '\\') {
                        lastChar = LastChar.BACKSLASH;
                        break;
                    }
                    result.append(c);
                    break;
                }
                case BACKSLASH: {
                    switch (c) {
                        case '0': {
                            break;
                        }
                        case 'a': {
                            result.append('\u0007');
                            break;
                        }
                        case 'b': {
                            int length = result.length();
                            if (length <= 0) break;
                            result.deleteCharAt(length - 1);
                            break;
                        }
                        case 'f': {
                            result.append('\f');
                            break;
                        }
                        case 'n': {
                            result.append('\n');
                            break;
                        }
                        case 'r': {
                            result.append("\r");
                            break;
                        }
                        case 't': {
                            result.append('\t');
                            break;
                        }
                        case 'v': {
                            result.append('\u000b');
                            break;
                        }
                        case '\\': {
                            result.append('\\');
                            break;
                        }
                        default: {
                            result.append(c);
                        }
                    }
                    lastChar = LastChar.ORDINARY_CHAR;
                }
            }
            ++index;
        }
        return result.toString();
    }

    private static enum LastChar {
        ORDINARY_CHAR,
        BACKSLASH;

    }
}

