/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

public class Tuple<TA, TB> {
    public final TA ta;
    public final TB tb;

    public Tuple(TA ta, TB tb) {
        this.ta = ta;
        this.tb = tb;
    }

    public boolean equals(Object obj) {
        boolean equals;
        if (this == obj) {
            equals = true;
        } else if (obj instanceof Tuple) {
            Tuple t = (Tuple)obj;
            equals = this.safeCompare(this.ta, t.ta) && this.safeCompare(this.tb, t.tb);
        } else {
            equals = false;
        }
        return equals;
    }

    private boolean safeCompare(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (b == null || a == null) {
            return false;
        }
        return a.equals(b);
    }

    public int hashCode() {
        if (this.ta == null && this.tb == null) {
            return 0;
        }
        if (this.ta == null) {
            return this.tb.hashCode();
        }
        if (this.tb == null) {
            return this.ta.hashCode();
        }
        return this.tb.hashCode() ^ this.ta.hashCode();
    }

    public String toString() {
        return "(" + this.ta + ", " + this.tb + ")";
    }

    public static <TA, TB> Tuple<TA, TB> getInstance(TA a, TB b) {
        return new Tuple<TA, TB>(a, b);
    }
}

