/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import com.arm.util.Messages;
import com.arm.util.Platform;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class Strings {
    public static final char BRACKET_START = '(';
    public static final char BRACKET_END = ')';
    public static final char DOUBLE_QUOTE = '\"';
    public static final String EMPTY_STRING = "";
    private static final Pattern RTRIM = Pattern.compile(" +$");

    public static String repeat(String s, int n) {
        if (n < 0) {
            throw new IllegalArgumentException(Messages.N_MUST_BE_POSITIVE.getLocalisedValue(new Object[0]));
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < n) {
            result.append(s);
            ++i;
        }
        return result.toString();
    }

    public static String indentMultiLineString(String s, int indent) {
        return s.replaceAll("(?m)^", Strings.repeat(" ", indent));
    }

    public static String stringify(Object[] objects, String separator) {
        String result;
        if (objects == null || objects.length == 0) {
            result = EMPTY_STRING;
        } else {
            StringBuilder builder = new StringBuilder();
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                builder.append(obj);
                builder.append(separator);
                ++n2;
            }
            result = builder.substring(0, builder.length() - separator.length());
        }
        return result;
    }

    public static String expandEscapes(String s) {
        s = s.replace("\\a", Character.toString('\u0007'));
        s = s.replace("\\b", "\b");
        s = s.replace("\\t", "\t");
        s = s.replace("\\n", "\n");
        s = s.replace("\\v", Character.toString('\u000b'));
        s = s.replace("\\f", "\f");
        s = s.replace("\\r", "\r");
        s = s.replaceAll("\\\\(.)", "$1");
        return s;
    }

    public static String removeDoubleQoutes(String s) {
        if (s == null) {
            return s;
        }
        int startIndex = s.indexOf(34);
        int endIndex = s.lastIndexOf(34);
        if (startIndex == -1 || startIndex == endIndex) {
            return s;
        }
        return s.substring(startIndex + 1, endIndex);
    }

    public static String removeBrackets(String s) {
        if (s == null) {
            return s;
        }
        int startIndex = s.indexOf(40);
        int endIndex = s.lastIndexOf(41);
        if (startIndex == -1 || endIndex == -1 || startIndex > endIndex) {
            return s;
        }
        return s.substring(startIndex + 1, endIndex);
    }

    public static int indexOfFirstNonDigit(String s) {
        if (s == null) {
            return -1;
        }
        int i = 0;
        while (i < s.length()) {
            if (!Character.isDigit(s.charAt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String join(String ... strings) {
        Collector<CharSequence, ?, String> collector = Collectors.joining(EMPTY_STRING);
        return Strings.join(collector, strings);
    }

    public static String joinWithNewline(String ... strings) {
        Collector<CharSequence, ?, String> collector = Collectors.joining(Platform.LS);
        return Strings.join(collector, strings);
    }

    public static String joinWithSeparator(String separator, String ... strings) {
        Collector<CharSequence, ?, String> collector = Collectors.joining(separator);
        return Strings.join(collector, strings);
    }

    public static String join(Collector<CharSequence, ?, String> collector, String ... strings) {
        return Arrays.stream(strings).collect(collector);
    }

    public static String rtrim(String s) {
        return RTRIM.matcher(s).replaceAll(EMPTY_STRING);
    }

    public static Set<String> split(String s, String regex) {
        if (s == null || s.isEmpty() || regex == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(s.split(regex)));
    }

    public static String[] splitOnEquals(String string) {
        if (string != null) {
            if (string.contains("=")) {
                String[] splitStrings = string.split("=", 2);
                int i = 0;
                while (i < splitStrings.length) {
                    splitStrings[i] = splitStrings[i].trim();
                    ++i;
                }
                return splitStrings;
            }
            return new String[]{string, EMPTY_STRING};
        }
        return new String[]{EMPTY_STRING, EMPTY_STRING};
    }

    public static String[] optionStringToArray(String string) {
        if (string != null && string.startsWith("[") && string.endsWith("]")) {
            return string.substring(1, string.length() - 1).split(", ");
        }
        return new String[0];
    }

    public static String listToOptionString(List<String> options) {
        if (options != null) {
            Pattern keyValuePattern = Pattern.compile(".+=.+");
            return options.stream().filter(o -> keyValuePattern.matcher((CharSequence)o).matches()).collect(Collectors.joining(", ", "[", "]"));
        }
        return "[]";
    }
}

