/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ReflectionUtils {
    public static <T> T stubImplementation(final @Nonnull Class<T> iface, final @Nullable Object stub) {
        final Class<?> stubClass = stub == null ? null : stub.getClass();
        return iface.cast(Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (stubClass != null) {
                    Method stubMethod = stubClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
                    if (stubMethod == null) {
                        stubMethod = stubClass.getMethod(method.getName(), method.getParameterTypes());
                    }
                    if (stubMethod != null) {
                        stubMethod.setAccessible(true);
                        return stubMethod.invoke(stub, args);
                    }
                }
                throw new UnsupportedOperationException(String.format("%s::%s", iface.getSimpleName(), method.getName()));
            }
        }));
    }
}

