/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class RandomIterator<E>
implements Iterator<E> {
    private List<E> toServe;
    private int position;

    public RandomIterator(Collection<E> l) {
        this.toServe = new ArrayList<E>(l);
        Collections.shuffle(this.toServe);
        this.position = 0;
    }

    public RandomIterator(Collection<E> l, Random r) {
        this.toServe = new ArrayList<E>(l);
        Collections.shuffle(this.toServe, r);
        this.position = 0;
    }

    public RandomIterator(E ... a) {
        this(Arrays.asList(a));
    }

    public static <E> Iterable<E> iterable(final Collection<E> l) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new RandomIterator(l);
            }
        };
    }

    public static <E> Iterable<E> iterable(E ... a) {
        return RandomIterator.iterable(Arrays.asList(a));
    }

    @Override
    public boolean hasNext() {
        return this.position < this.toServe.size();
    }

    @Override
    public E next() {
        ++this.position;
        return this.toServe.get(this.position - 1);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

