/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import com.arm.text.IMessage;
import com.arm.util.Units;
import java.math.BigInteger;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;

public class NumberUtils {
    private static final String NA = "-";
    private static final String INFINITE = "\u221e";
    private static final String K_FORMAT = "{0} K";
    private static final String M_FORMAT = "{0} M";
    private static final String G_FORMAT = "{0} G";
    private static final String DAY_POSTFIX = "d";
    private static final String HOUR_POSTFIX = "h";
    private static final String MINUTE_POSTFIX = "m";
    private static final String SECOND_POSTFIX = "s";
    private static final String MILLISECOND_POSTFIX = "ms";
    private static String SEPARATOR = " ";
    public static final String BINARY_PREFIX = "0b";
    public static final String BINARY_PREFIX2 = "0B";
    public static final String HEX_PREFIX = "0x";
    public static final String HEX_PREFIX2 = "0X";
    public static final String PLUS = "+";
    public static final String MINUS = "-";
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance();
    private static final NumberFormat NO_COMMA_NUMBER_FORMAT;
    private static final NumberFormat PRETTY_FORMATTER;
    private static final NumberFormat TRUNCATE_FORMATTER;
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    private static final Units.TimeUnit[] HIGH_UNITS;

    static {
        NUMBER_FORMAT.setMaximumFractionDigits(13);
        NO_COMMA_NUMBER_FORMAT = NumberFormat.getNumberInstance();
        NO_COMMA_NUMBER_FORMAT.setGroupingUsed(false);
        NO_COMMA_NUMBER_FORMAT.setMaximumFractionDigits(13);
        PRETTY_FORMATTER = NumberFormat.getInstance();
        PRETTY_FORMATTER.setMinimumFractionDigits(2);
        PRETTY_FORMATTER.setMaximumFractionDigits(2);
        TRUNCATE_FORMATTER = NumberFormat.getInstance();
        TRUNCATE_FORMATTER.setMinimumFractionDigits(0);
        TRUNCATE_FORMATTER.setMaximumFractionDigits(2);
        HIGH_UNITS = new Units.TimeUnit[]{Units.TimeUnit.DAY, Units.TimeUnit.HOUR, Units.TimeUnit.MINUTE};
    }

    public static String formatAddress(int address) {
        return NumberUtils.formatHex(address, 8, true);
    }

    public static String formatAddress(long address) {
        return NumberUtils.formatHex(address, address < 0L || address > 0xFFFFFFFFL ? 16 : 8, true);
    }

    public static String formatBinary(byte value, int pad, boolean prefix) {
        return NumberUtils.formatWithPad(prefix ? BINARY_PREFIX : null, Integer.toBinaryString(value & 0xFF), pad);
    }

    public static String formatBinary(short value, int pad, boolean prefix) {
        return NumberUtils.formatWithPad(prefix ? BINARY_PREFIX : null, Integer.toBinaryString(value & 0xFFFF), pad);
    }

    public static String formatBinary(int value, int pad, boolean prefix) {
        return NumberUtils.formatWithPad(prefix ? BINARY_PREFIX : null, Integer.toBinaryString(value), pad);
    }

    public static String formatBinary(long value, int pad, boolean prefix) {
        return NumberUtils.formatWithPad(prefix ? BINARY_PREFIX : null, Long.toBinaryString(value), pad);
    }

    public static String formatUnsignedLong(long value) {
        if (value >= 0L) {
            return Long.toString(value);
        }
        return NumberUtils.unsignedBigInteger(value).toString();
    }

    public static String formatUnsignedDecimal(byte value, int pad) {
        return NumberUtils.formatWithPad(null, Integer.toString(value & 0xFF), pad);
    }

    public static String formatUnsignedDecimal(short value, int pad) {
        return NumberUtils.formatWithPad(null, Integer.toString(value & 0xFFFF), pad);
    }

    public static String formatUnsignedDecimal(int value, int pad) {
        return NumberUtils.formatWithPad(null, Long.toString((long)value & 0xFFFFFFFFL), pad);
    }

    public static String formatUnsignedDecimal(long value, int pad) {
        return NumberUtils.formatWithPad(null, NumberUtils.formatUnsignedLong(value), pad);
    }

    private static String padSignedDecimal(int pad, String number) {
        String prefix;
        if (number.startsWith("-")) {
            prefix = "-";
            number = number.substring(1);
        } else {
            prefix = PLUS;
        }
        return NumberUtils.formatWithPad(prefix, number, pad);
    }

    public static String formatSignedDecimal(byte value, int pad) {
        return NumberUtils.padSignedDecimal(pad, Integer.toString(value));
    }

    public static String formatSignedDecimal(short value, int pad) {
        return NumberUtils.padSignedDecimal(pad, Integer.toString(value));
    }

    public static String formatSignedDecimal(int value, int pad) {
        return NumberUtils.padSignedDecimal(pad, Integer.toString(value));
    }

    public static String formatSignedDecimal(long value, int pad) {
        return NumberUtils.padSignedDecimal(pad, Long.toString(value));
    }

    public static String formatHex(byte value, int pad, boolean prefix) {
        return NumberUtils.formatWithPad(prefix ? HEX_PREFIX : null, Integer.toHexString(value & 0xFF).toUpperCase(), pad);
    }

    public static String formatHex(short value, int pad, boolean prefix) {
        return NumberUtils.formatWithPad(prefix ? HEX_PREFIX : null, Integer.toHexString(value & 0xFFFF).toUpperCase(), pad);
    }

    public static String formatHex(int value, int pad, boolean prefix) {
        return NumberUtils.formatWithPad(prefix ? HEX_PREFIX : null, Integer.toHexString(value).toUpperCase(), pad);
    }

    public static String formatHex(long value, int pad, boolean prefix) {
        return NumberUtils.formatWithPad(prefix ? HEX_PREFIX : null, Long.toHexString(value).toUpperCase(), pad);
    }

    public static String formatWithPad(String prefix, String value, int pad) {
        int length;
        StringBuilder builder = new StringBuilder(pad + (prefix != null ? prefix.length() : 0));
        if (prefix != null) {
            builder.append(prefix);
        }
        if ((length = value.length()) < pad) {
            int i = length;
            while (i < pad) {
                builder.append('0');
                ++i;
            }
        } else if (length > pad) {
            value = value.substring(length - pad);
        }
        builder.append(value);
        return builder.toString();
    }

    public static String format(long value) {
        return NUMBER_FORMAT.format(value);
    }

    public static String format(double value) {
        return NUMBER_FORMAT.format(value);
    }

    public static String formatNoComma(double value) {
        return NO_COMMA_NUMBER_FORMAT.format(value);
    }

    public static String format(long value, boolean forceSign) {
        return String.valueOf(forceSign && value >= 0L ? PLUS : "") + NUMBER_FORMAT.format(value);
    }

    public static String format(double value, boolean forceSign) {
        return String.valueOf(forceSign && value >= 0.0 ? PLUS : "") + NUMBER_FORMAT.format(value);
    }

    public static boolean getBoolean(String buffer) {
        return "true".equalsIgnoreCase(buffer = NumberUtils.strip(buffer)) || "yes".equalsIgnoreCase(buffer) || "on".equalsIgnoreCase(buffer) || "1".equals(buffer);
    }

    private static String strip(String buffer) {
        if (buffer == null) {
            return "";
        }
        return (buffer = buffer.trim()).startsWith(PLUS) ? buffer.substring(1) : buffer;
    }

    public static short getLocalizedShort(String buffer, short defValue) {
        try {
            return NUMBER_FORMAT.parse(NumberUtils.strip(buffer)).shortValue();
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static short getNonLocalizedShort(String buffer, short defValue) {
        try {
            buffer = NumberUtils.strip(buffer);
            if (buffer.startsWith(HEX_PREFIX)) {
                return NumberUtils.getNonLocalizedHexShort(buffer, defValue);
            }
            if (buffer.startsWith(HEX_PREFIX2)) {
                return NumberUtils.getNonLocalizedHexShort(buffer, defValue);
            }
            return Short.parseShort(buffer);
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static short getNonLocalizedHexShort(String buffer, short defValue) {
        try {
            buffer = NumberUtils.strip(buffer);
            if (buffer.startsWith(HEX_PREFIX)) {
                buffer = buffer.substring(HEX_PREFIX.length());
            } else if (buffer.startsWith(HEX_PREFIX2)) {
                buffer = buffer.substring(HEX_PREFIX2.length());
            }
            if (buffer.length() == 4) {
                int value = Character.digit(buffer.charAt(0), 16);
                return (short)(value << 14 | Short.parseShort(buffer.substring(1), 16));
            }
            return Short.parseShort(buffer, 16);
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static short getNonLocalizedBinaryShort(String buffer, short defValue) {
        try {
            buffer = NumberUtils.strip(buffer);
            if (buffer.startsWith(HEX_PREFIX)) {
                return NumberUtils.getNonLocalizedHexShort(buffer, defValue);
            }
            if (buffer.startsWith(HEX_PREFIX2)) {
                return NumberUtils.getNonLocalizedHexShort(buffer, defValue);
            }
            if (buffer.startsWith(BINARY_PREFIX)) {
                buffer = buffer.substring(BINARY_PREFIX.length());
            } else if (buffer.startsWith(BINARY_PREFIX2)) {
                buffer = buffer.substring(BINARY_PREFIX2.length());
            }
            if (buffer.length() == 16) {
                int value = Character.digit(buffer.charAt(0), 2);
                return (short)(value << 15 | Short.parseShort(buffer.substring(1), 2));
            }
            return Short.parseShort(buffer, 2);
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static int getLocalizedInteger(String buffer, int defValue) {
        try {
            return NUMBER_FORMAT.parse(NumberUtils.strip(buffer)).intValue();
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static int getNonLocalizedInteger(String buffer, int defValue) {
        try {
            buffer = NumberUtils.strip(buffer);
            if (buffer.startsWith(HEX_PREFIX)) {
                return NumberUtils.getNonLocalizedHexInteger(buffer, defValue);
            }
            if (buffer.startsWith(HEX_PREFIX2)) {
                return NumberUtils.getNonLocalizedHexInteger(buffer, defValue);
            }
            return Integer.parseInt(buffer);
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static int getNonLocalizedHexInteger(String buffer, int defValue) {
        try {
            buffer = NumberUtils.strip(buffer);
            if (buffer.startsWith(HEX_PREFIX)) {
                buffer = buffer.substring(HEX_PREFIX.length());
            } else if (buffer.startsWith(HEX_PREFIX2)) {
                buffer = buffer.substring(HEX_PREFIX2.length());
            }
            if (buffer.length() == 8) {
                int value = Character.digit(buffer.charAt(0), 16);
                return value << 28 | Integer.parseInt(buffer.substring(1), 16);
            }
            return Integer.parseInt(buffer, 16);
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static Integer getInteger(String value) {
        if (NumberUtils.isValidHex(value, 8)) {
            return (int)NumberUtils.parseHex(value);
        }
        if (NumberUtils.isValidBinary(value)) {
            return (int)NumberUtils.parseBinary(value);
        }
        if (NumberUtils.isValidOctal(value)) {
            return (int)NumberUtils.parseOctal(value);
        }
        if (NumberUtils.isValidDecimal(value, true)) {
            return (int)NumberUtils.parseDecimal(value);
        }
        if (NumberUtils.isValidUnicode(value)) {
            return NumberUtils.getUnicodeAsInt(value, 0);
        }
        return null;
    }

    public static boolean isValidInteger(String value) {
        if (NumberUtils.isValidHex(value, 8)) {
            return true;
        }
        if (NumberUtils.isValidBinary(value)) {
            return true;
        }
        if (NumberUtils.isValidOctal(value)) {
            return true;
        }
        if (NumberUtils.isValidDecimal(value, true)) {
            return true;
        }
        return NumberUtils.isValidUnicode(value);
    }

    static boolean isValidDigits(String s, int radix) {
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.digit(c, radix) == -1) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static long parseDigits(String s, int radix) {
        s = s.trim();
        long v = 0L;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            int digit = Character.digit(c, radix);
            if (digit == -1) break;
            v = v * (long)radix + (long)digit;
            ++n2;
        }
        return v;
    }

    public static boolean isValidHex(String s, int maxDigits) {
        if (s == null) {
            return false;
        }
        if ((s = s.trim().toLowerCase()).startsWith(HEX_PREFIX)) {
            s = s.substring(HEX_PREFIX.length());
        } else if (s.startsWith(HEX_PREFIX2)) {
            s = s.substring(HEX_PREFIX2.length());
        } else {
            return false;
        }
        s = s.substring(NumberUtils.countLeadingZeros(s));
        if (s.length() > maxDigits) {
            return false;
        }
        return NumberUtils.isValidDigits(s, 16);
    }

    public static boolean isValidDecimal(String value, boolean permitNegative) {
        if ((value = value.trim()).startsWith(PLUS) || permitNegative && value.startsWith("-")) {
            value = value.substring(1).trim();
        }
        return NumberUtils.isValidDigits(value, 10);
    }

    public static int logBase2(long value) {
        if (value == 0L) {
            throw new IllegalArgumentException("Cannot calculate logBase2(0)");
        }
        return 63 - Long.numberOfLeadingZeros(value);
    }

    public static long parseBinary(String s) {
        if (s == null) {
            return 0L;
        }
        if ((s = s.trim().toLowerCase()).startsWith(BINARY_PREFIX)) {
            s = s.substring(BINARY_PREFIX.length());
        } else if (s.startsWith(BINARY_PREFIX2)) {
            s = s.substring(BINARY_PREFIX2.length());
        } else {
            return 0L;
        }
        return NumberUtils.parseDigits(s, 2);
    }

    public static boolean isValidBinary(String s) {
        if (s == null) {
            return false;
        }
        if ((s = s.trim().toLowerCase()).startsWith(BINARY_PREFIX)) {
            s = s.substring(BINARY_PREFIX.length());
        } else if (s.startsWith(BINARY_PREFIX2)) {
            s = s.substring(BINARY_PREFIX2.length());
        } else {
            return false;
        }
        return NumberUtils.isValidDigits(s, 2);
    }

    public static long parseOctal(String s) {
        s = s.trim();
        return NumberUtils.parseDigits(s, 8);
    }

    public static boolean isValidOctal(String value) {
        if (!(value = value.trim()).startsWith("0")) {
            return false;
        }
        return NumberUtils.isValidDigits(value, 8);
    }

    public static long parseDecimal(String s) {
        if ((s = s.trim()).startsWith("-")) {
            s = s.substring(1);
            return -NumberUtils.parseDigits(s, 10);
        }
        if (s.startsWith(PLUS)) {
            s = s.substring(1).trim();
        }
        return NumberUtils.parseDigits(s, 10);
    }

    public static long parseHex(String s) {
        if (s == null) {
            return 0L;
        }
        if ((s = s.trim().toLowerCase()).startsWith(HEX_PREFIX)) {
            s = s.substring(HEX_PREFIX.length());
        } else if (s.startsWith(HEX_PREFIX2)) {
            s = s.substring(HEX_PREFIX2.length());
        } else {
            return 0L;
        }
        return NumberUtils.parseDigits(s, 16);
    }

    private static int countLeadingZeros(String s) {
        int length = s.length();
        int i = 0;
        while (i < length) {
            if (s.charAt(i) != '0') {
                return i;
            }
            ++i;
        }
        return length;
    }

    public static int getNonLocalizedBinaryInteger(String buffer, int defValue) {
        try {
            buffer = NumberUtils.strip(buffer);
            if (buffer.startsWith(HEX_PREFIX)) {
                return NumberUtils.getNonLocalizedHexInteger(buffer, defValue);
            }
            if (buffer.startsWith(HEX_PREFIX2)) {
                return NumberUtils.getNonLocalizedHexInteger(buffer, defValue);
            }
            if (buffer.startsWith(BINARY_PREFIX)) {
                buffer = buffer.substring(BINARY_PREFIX.length());
            } else if (buffer.startsWith(BINARY_PREFIX2)) {
                buffer = buffer.substring(BINARY_PREFIX2.length());
            }
            if (buffer.length() == 32) {
                int value = Character.digit(buffer.charAt(0), 2);
                return value << 31 | Integer.parseInt(buffer.substring(1), 2);
            }
            return Integer.parseInt(buffer, 2);
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static long getLocalizedLong(String buffer, long defValue) {
        try {
            return NUMBER_FORMAT.parse(NumberUtils.strip(buffer)).longValue();
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static long getNonLocalizedLong(String buffer, long defValue) {
        try {
            buffer = NumberUtils.strip(buffer);
            if (buffer.startsWith(HEX_PREFIX)) {
                return NumberUtils.getNonLocalizedHexLong(buffer, defValue);
            }
            if (buffer.startsWith(HEX_PREFIX2)) {
                return NumberUtils.getNonLocalizedHexLong(buffer, defValue);
            }
            return Long.parseLong(buffer);
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static long getNonLocalizedHexLong(String buffer, long defValue) {
        try {
            buffer = NumberUtils.strip(buffer);
            if (buffer.startsWith(HEX_PREFIX)) {
                buffer = buffer.substring(HEX_PREFIX.length());
            } else if (buffer.startsWith(HEX_PREFIX2)) {
                buffer = buffer.substring(HEX_PREFIX2.length());
            }
            if (buffer.length() == 16) {
                long value = Character.digit(buffer.charAt(0), 16);
                return value << 60 | Long.parseLong(buffer.substring(1), 16);
            }
            return Long.parseLong(buffer, 16);
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static long getNonLocalizedBinaryLong(String buffer, long defValue) {
        try {
            buffer = NumberUtils.strip(buffer);
            if (buffer.startsWith(HEX_PREFIX)) {
                return NumberUtils.getNonLocalizedHexLong(buffer, defValue);
            }
            if (buffer.startsWith(HEX_PREFIX2)) {
                return NumberUtils.getNonLocalizedHexLong(buffer, defValue);
            }
            if (buffer.startsWith(BINARY_PREFIX)) {
                buffer = buffer.substring(BINARY_PREFIX.length());
            } else if (buffer.startsWith(BINARY_PREFIX2)) {
                buffer = buffer.substring(BINARY_PREFIX2.length());
            }
            if (buffer.length() == 64) {
                long value = Character.digit(buffer.charAt(0), 2);
                return value << 63 | Long.parseLong(buffer.substring(1), 2);
            }
            return Long.parseLong(buffer, 2);
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static float getLocalizedFloat(String buffer, float defValue) {
        try {
            return NUMBER_FORMAT.parse(NumberUtils.strip(buffer)).floatValue();
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static float getNonLocalizedFloat(String buffer, float defValue) {
        try {
            return Float.parseFloat(NumberUtils.strip(buffer));
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static double getLocalizedDouble(String buffer, double defValue) {
        try {
            return NUMBER_FORMAT.parse(NumberUtils.strip(buffer)).doubleValue();
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static double getNonLocalizedDouble(String buffer, double defValue) {
        try {
            return Double.parseDouble(NumberUtils.strip(buffer));
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static int getUnicodeAsInt(String value, int defValue) {
        try {
            int unicode = NumberUtils.unicodeToInt(value);
            return unicode;
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static boolean isValidUnicode(String value) {
        try {
            NumberUtils.unicodeToInt(value);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static int unicodeToInt(String value) throws Exception {
        if (value == null) {
            throw new Exception();
        }
        if ((value = value.trim()).length() < 3) {
            throw new Exception();
        }
        if (!value.startsWith("'")) {
            throw new Exception();
        }
        if (!value.endsWith("'")) {
            throw new Exception();
        }
        value = value.substring(1, value.length() - 1);
        int firstChar = value.charAt(0);
        int unicode = 0;
        if (firstChar == 92) {
            if (value.length() < 2) {
                throw new Exception();
            }
            char third = value.charAt(1);
            switch (third) {
                case 'n': {
                    unicode = 10;
                    break;
                }
                case 't': {
                    unicode = 9;
                    break;
                }
                case 'v': {
                    unicode = 11;
                    break;
                }
                case 'b': {
                    unicode = 8;
                    break;
                }
                case 'r': {
                    unicode = 13;
                    break;
                }
                case 'f': {
                    unicode = 12;
                    break;
                }
                case 'a': {
                    unicode = 7;
                    break;
                }
                case '\\': {
                    unicode = 92;
                    break;
                }
                case '?': {
                    unicode = 63;
                    break;
                }
                case '\'': {
                    unicode = 39;
                    break;
                }
                case '\"': {
                    unicode = 34;
                    break;
                }
                case 'U': 
                case 'u': 
                case 'x': {
                    String remains = value.substring(2);
                    if (remains.length() < 1) {
                        throw new Exception();
                    }
                    if (!NumberUtils.isValidDigits(remains, 16)) {
                        throw new Exception();
                    }
                    unicode = (int)NumberUtils.parseDigits(remains, 16);
                    break;
                }
                default: {
                    String remains = value.substring(1);
                    if (remains.length() < 1) {
                        throw new Exception();
                    }
                    if (!NumberUtils.isValidDigits(remains, 8)) {
                        throw new Exception();
                    }
                    unicode = (int)NumberUtils.parseDigits(remains, 8);
                    break;
                }
            }
        } else {
            unicode = firstChar;
        }
        return unicode;
    }

    public static String charToCLiteral(char c) {
        String unicodeString = "";
        switch (c) {
            case '\u0000': {
                unicodeString = "\\0";
                break;
            }
            case '\n': {
                unicodeString = "\\n";
                break;
            }
            case '\t': {
                unicodeString = "\\t";
                break;
            }
            case '\u000b': {
                unicodeString = "\\v";
                break;
            }
            case '\b': {
                unicodeString = "\\b";
                break;
            }
            case '\r': {
                unicodeString = "\\r";
                break;
            }
            case '\f': {
                unicodeString = "\\f";
                break;
            }
            case '\u0007': {
                unicodeString = "\\a";
                break;
            }
            case '\\': {
                unicodeString = "\\\\";
                break;
            }
            case '\'': {
                unicodeString = "\\'";
                break;
            }
            case '\"': {
                unicodeString = "\\\"";
                break;
            }
            default: {
                unicodeString = Character.isISOControl(c) ? String.format("\\x%02X", c) : (Character.isDefined(c) ? String.format("%c", c) : String.format("\\U%08X", c));
            }
        }
        return unicodeString;
    }

    public static String formatUnicodeAsCharLiteral(int value, int sizeInBits) {
        String unicodeString = "";
        switch (value) {
            case 0: {
                unicodeString = "'\\0'";
                break;
            }
            case 10: {
                unicodeString = "'\\n'";
                break;
            }
            case 9: {
                unicodeString = "'\\t'";
                break;
            }
            case 11: {
                unicodeString = "'\\v'";
                break;
            }
            case 8: {
                unicodeString = "'\\b'";
                break;
            }
            case 13: {
                unicodeString = "'\\r'";
                break;
            }
            case 12: {
                unicodeString = "'\\f'";
                break;
            }
            case 7: {
                unicodeString = "'\\a'";
                break;
            }
            case 92: {
                unicodeString = "'\\\\'";
                break;
            }
            case 39: {
                unicodeString = "'\\''";
                break;
            }
            case 34: {
                unicodeString = "'\\\"'";
                break;
            }
            default: {
                unicodeString = Character.isISOControl(value) ? NumberUtils.formatControlCharacter(value, sizeInBits) : (Character.isDefined(value) ? String.format("'%c'", value) : NumberUtils.formatControlCharacter(value, sizeInBits));
            }
        }
        return unicodeString;
    }

    private static String formatControlCharacter(int value, int sizeInBits) {
        String unicodeString;
        switch (sizeInBits) {
            case 8: {
                unicodeString = String.format("'\\x%02X'", value);
                break;
            }
            case 16: {
                unicodeString = String.format("'\\u%04X'", value);
                break;
            }
            default: {
                unicodeString = String.format("'\\U%08X'", value);
            }
        }
        return unicodeString;
    }

    public static final String formatTime(double seconds) {
        StringBuilder builder = new StringBuilder();
        long remainingSeconds = (long)Math.floor(seconds);
        String separator = "";
        Units.TimeUnit[] timeUnitArray = HIGH_UNITS;
        int n = HIGH_UNITS.length;
        int n2 = 0;
        while (n2 < n) {
            Units.TimeUnit unit = timeUnitArray[n2];
            long inUnit = unit.fromBase(remainingSeconds);
            if (inUnit > 0L) {
                builder.append(separator);
                separator = " ";
                builder.append(inUnit);
                builder.append(separator);
                if (inUnit == 1L) {
                    builder.append(unit.getLocalisedSingular());
                } else {
                    builder.append(unit.getLocalisedPlural());
                }
            }
            remainingSeconds -= unit.toBase(inUnit);
            seconds -= (double)unit.toBase(inUnit);
            ++n2;
        }
        if (seconds < 0.01) {
            seconds = 0.0;
        }
        if (seconds >= 0.01 || builder.length() == 0) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            int isec = (int)Math.floor(seconds * 100.0);
            builder.append(isec / 100);
            int fsec = isec % 100;
            if (fsec > 0) {
                builder.append('.');
                if (fsec < 10) {
                    builder.append('0');
                }
                builder.append(fsec);
            }
            builder.append(' ');
            String dayLocalised = isec == 100 && fsec == 0 ? Units.TimeUnit.SECOND.getLocalisedSingular() : Units.TimeUnit.SECOND.getLocalisedPlural();
            builder.append(dayLocalised);
        }
        return builder.toString();
    }

    public static String formatMillisecondsNoDays(long time) {
        long seconds;
        int d;
        long hours = time / 3600000L;
        long minutes = (time -= hours * 3600000L) / 60000L;
        time -= minutes * 60000L;
        if ((d = Math.round((float)(time -= (seconds = time / 1000L) * 1000L) / 100.0f)) == 10) {
            d = 0;
            if (++seconds >= 60L) {
                seconds -= 60L;
                if (++minutes >= 60L) {
                    minutes -= 60L;
                    ++hours;
                }
            }
        }
        StringBuilder builder = new StringBuilder();
        if (hours > 0L) {
            builder.append(String.format("%02d:%02d:%02d", hours, minutes, seconds));
        } else {
            builder.append(String.format("%02d:%02d", minutes, seconds));
        }
        return builder.toString();
    }

    public static String formatMilliseconds(long time, int minPad, boolean trimLeading, IMessage oneDay, IMessage manyDays) {
        long days = time / 86400000L;
        StringBuilder buffer = new StringBuilder();
        if (days > 0L) {
            if (days == 1L) {
                buffer.append(oneDay.getLocalisedValue(new Object[0]));
            } else {
                buffer.append(manyDays.getLocalisedValue(days));
            }
            time -= days * 86400000L;
        }
        long hours = time / 3600000L;
        long minutes = (time -= hours * 3600000L) / 60000L;
        long seconds = (time -= minutes * 60000L) / 1000L;
        buffer.append(String.format("%d:%02d:%02d", hours, minutes, seconds));
        if ((time -= seconds * 1000L) > 0L || minPad > 0) {
            int pos = buffer.length() + 1;
            buffer.append(String.format(".%03d", time));
            int length = buffer.length();
            while (length - pos > minPad && buffer.charAt(length - 1) == '0') {
                buffer.setLength(--length);
            }
        }
        if (trimLeading) {
            int length = buffer.length();
            int i = 0;
            while (i < length) {
                char ch = buffer.charAt(i);
                if (ch != '0' && ch != ':') break;
                ++i;
            }
            if (i > 0 && i < length && buffer.charAt(i) == '.') {
                --i;
            }
            if (i == length) {
                --i;
            }
            if (i > 0) {
                buffer.delete(0, i);
            }
        }
        return buffer.toString();
    }

    public static String formatMillisecondsDuration(long time) {
        long seconds;
        long minutes;
        long hours;
        long days = time / 86400000L;
        StringBuilder buffer = new StringBuilder();
        if (days > 0L) {
            buffer.append(days);
            buffer.append(DAY_POSTFIX);
            time -= days * 86400000L;
        }
        if ((hours = time / 3600000L) > 0L) {
            if (buffer.length() > 0) {
                buffer.append(SEPARATOR);
            }
            buffer.append(hours);
            buffer.append(HOUR_POSTFIX);
            time -= hours * 3600000L;
        }
        if ((minutes = time / 60000L) > 0L) {
            if (buffer.length() > 0) {
                buffer.append(SEPARATOR);
            }
            buffer.append(minutes);
            buffer.append(MINUTE_POSTFIX);
            time -= minutes * 60000L;
        }
        if ((seconds = time / 1000L) > 0L) {
            if (buffer.length() > 0) {
                buffer.append(SEPARATOR);
            }
            buffer.append(seconds);
            buffer.append(SECOND_POSTFIX);
            time -= seconds * 1000L;
        }
        if (time > 0L) {
            if (buffer.length() > 0) {
                buffer.append(SEPARATOR);
            }
            buffer.append(time);
            buffer.append(MILLISECOND_POSTFIX);
        }
        if (buffer.length() == 0) {
            buffer.append(0);
            buffer.append(SECOND_POSTFIX);
        }
        return buffer.toString();
    }

    public static final String adjustForLessThanVisiblePrecision(String buffer, double origValue) {
        if (origValue == 0.0) {
            return buffer;
        }
        int i = 0;
        while (i < buffer.length()) {
            char ch = buffer.charAt(i);
            if (ch != '0' && ch != '.') {
                return buffer;
            }
            ++i;
        }
        return "< " + buffer.substring(0, buffer.length() - 1) + "1";
    }

    public static final String formatPercentage(double value) {
        if (Double.isInfinite(value)) {
            return INFINITE;
        }
        if (value < 0.0 || Double.isNaN(value)) {
            return "-";
        }
        if (value < 0.01 && value > 0.0) {
            return "< 0.01%";
        }
        if (value < 100.0 && value >= 99.995) {
            return "> 99.99%";
        }
        return String.valueOf(PRETTY_FORMATTER.format(value)) + "%";
    }

    public static final String formatPercentageAndAllowNegatives(double value) {
        if (Double.isInfinite(value)) {
            return INFINITE;
        }
        if (Double.isNaN(value)) {
            return "-";
        }
        if (value < 100.0 && value >= 99.995) {
            return "> 99.99%";
        }
        if (value > -100.0 && value <= -99.995) {
            return "< -99.99%";
        }
        return String.valueOf(PRETTY_FORMATTER.format(value)) + "%";
    }

    public static final String prettyFormat(int value) {
        if (value < 0) {
            return "-";
        }
        return NumberUtils.format(value);
    }

    public static final String prettyFormat(long value) {
        if (value < 0L) {
            return "-";
        }
        return NumberUtils.format(value);
    }

    public static final String prettyFormat(double value) {
        if (value < 0.0 || Double.isNaN(value)) {
            return "-";
        }
        return NumberUtils.adjustForLessThanVisiblePrecision(PRETTY_FORMATTER.format(value), value);
    }

    public static final String truncateFormat(double value) {
        if (value < 0.0 || Double.isNaN(value)) {
            return "-";
        }
        return NumberUtils.adjustForLessThanVisiblePrecision(TRUNCATE_FORMATTER.format(value), value);
    }

    public static String formatWholeSuffixedNumber(long value) {
        if (value < 1000L) {
            return NumberUtils.prettyFormat(value).concat(" ");
        }
        if (value < 1000000L) {
            return MessageFormat.format(K_FORMAT, NumberUtils.prettyFormat(value / 1000L));
        }
        if (value < 1000000000L) {
            return MessageFormat.format(M_FORMAT, NumberUtils.prettyFormat(value / 1000000L));
        }
        return MessageFormat.format(G_FORMAT, NumberUtils.prettyFormat((double)value / 1.0E9));
    }

    public static String formatWholeSuffixedNumber(double value) {
        if (value < 1000.0) {
            if (value == (double)((long)value)) {
                return NumberUtils.formatWholeSuffixedNumber((long)value);
            }
            return NumberUtils.prettyFormat(value).concat(" ");
        }
        if (value < 999995.0) {
            return MessageFormat.format(K_FORMAT, NumberUtils.truncateFormat(value /= 1000.0));
        }
        if (value < 9.99995E8) {
            return MessageFormat.format(M_FORMAT, NumberUtils.truncateFormat(value /= 1000000.0));
        }
        return MessageFormat.format(G_FORMAT, NumberUtils.truncateFormat(value /= 1.0E9));
    }

    public static String formatWholeSuffixedNumberKibi(long value) {
        Units.ByteUnit unit = Units.ByteUnit.getFirstUnitSmallerThan(value);
        return String.format("%s %s", NumberUtils.prettyFormat(unit.fromBase(value)), unit.name());
    }

    public static String formatWholeSuffixedNumberKibi(double value) {
        if (value < 1024.0) {
            if (value == (double)((long)value)) {
                return NumberUtils.formatWholeSuffixedNumberKibi((long)value);
            }
            return NumberUtils.prettyFormat(value).concat(" ");
        }
        if (value < 1023994.0) {
            return MessageFormat.format(K_FORMAT, NumberUtils.truncateFormat(value /= 1024.0));
        }
        if (value < 1.048570757E9) {
            return MessageFormat.format(M_FORMAT, NumberUtils.truncateFormat(value /= 1048576.0));
        }
        return MessageFormat.format(G_FORMAT, NumberUtils.truncateFormat(value /= 1.073741824E9));
    }

    public static double calculateLimit(double value, boolean useKibi) {
        if (value == 0.0) {
            return 1.0;
        }
        long scale = 1L;
        double v = value;
        double multiplier = useKibi ? 1024.0 : 1000.0;
        if (value <= 10.0) {
            v = Math.ceil(v);
        }
        while (v >= multiplier) {
            v /= multiplier;
            scale = (long)((double)scale * multiplier);
        }
        v = v <= 2.0 ? Math.ceil(v * 10.0) / 10.0 : (v <= 5.0 ? Math.ceil(v * 2.0) / 2.0 : (v <= 10.0 ? Math.ceil(v) : (v <= 50.0 ? Math.ceil(v / 5.0) * 5.0 : (v <= 100.0 ? Math.ceil(v / 10.0) * 10.0 : (v <= 500.0 ? Math.ceil(v / 50.0) * 50.0 : Math.ceil(v / 100.0) * 100.0)))));
        return v * (double)scale;
    }

    public static String trimTrailingZerosAfterDecimal(String buffer, boolean localized) {
        int dot;
        if (buffer != null && (dot = (buffer = buffer.trim()).indexOf(localized ? (int)DecimalFormatSymbols.getInstance().getDecimalSeparator() : 46)) != -1) {
            int pos = buffer.length() - 1;
            while (buffer.charAt(pos) == '0') {
                --pos;
            }
            if (dot != pos) {
                ++pos;
            }
            buffer = buffer.substring(0, pos);
        }
        return buffer;
    }

    public static BigInteger unsignedBigInteger(long number) {
        if (number >= 0L) {
            return BigInteger.valueOf(number);
        }
        return BigInteger.valueOf(number & Long.MAX_VALUE).setBit(63);
    }

    public static final String fill(int count, char ch) {
        StringBuilder buffer = new StringBuilder(count);
        int i = 0;
        while (i < count) {
            buffer.append(ch);
            ++i;
        }
        return buffer.toString();
    }

    public static final String zeroPad(String buffer, int count) {
        int len = count - buffer.length();
        return len > 0 ? String.valueOf(NumberUtils.fill(len, '0')) + buffer : buffer;
    }

    public static String formatSize(long size) {
        return NumberUtils.formatSize(size, "");
    }

    public static String formatSize(long size, String suffix) {
        if (size < 1024L) {
            if (suffix.isEmpty()) {
                return Long.toString(size);
            }
            return String.valueOf(Long.toString(size)) + " " + suffix;
        }
        if (size < 0x100000L) {
            return String.format("%.1f K%s", new Double((double)size / 1024.0), suffix);
        }
        if (size < 0x40000000L) {
            return String.format("%.1f M%s", new Double((double)size / 1048576.0), suffix);
        }
        if (size < 0x10000000000L) {
            return String.format("%.1f G%s", new Double((double)size / 1.073741824E9), suffix);
        }
        return String.format("%.1f T%s", new Double((double)size / 1.099511627776E12), suffix);
    }

    public static int roundUpToPowerOf2(int x) {
        if (x == 0) {
            return x;
        }
        return Integer.MIN_VALUE >>> Integer.numberOfLeadingZeros(x - 1) - 1;
    }

    public static int roundDownToPowerOf2(int x) {
        if (x == 0) {
            return x;
        }
        int nlz = Integer.numberOfLeadingZeros(x);
        return Integer.MIN_VALUE >>> nlz;
    }
}

