/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import com.arm.util.IProgressListener;
import com.arm.util.Messages;
import java.io.Serializable;

public class IntervalProgressListener
implements IProgressListener,
Serializable {
    private static final long serialVersionUID = 3256722879293763635L;
    double begin;
    double end;
    IProgressListener client;

    public IntervalProgressListener(double begin, double end, IProgressListener client) {
        this.begin = begin;
        this.end = end;
        if (end < begin) {
            String message = Messages.INTERVAL_PROGRESS_LISTENER_MUST_HAVE_BEGIN_LESS_THAN_END.getLocalisedValue(new Object[0]);
            throw new IllegalArgumentException(message);
        }
        this.client = client;
    }

    @Override
    public void progressEvent(String message, double perc) {
        if (this.client != null) {
            this.client.progressEvent(message, this.begin + (this.end - this.begin) * perc / 100.0);
        }
    }
}

