/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class InjectiveMap<K, V>
implements Map<K, V> {
    private final Map<K, V> map = new HashMap();
    private final Map<V, K> inv = new HashMap<V, K>();

    public InjectiveMap() {
    }

    public InjectiveMap(Map<K, V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V put(K key, V value) {
        this.removeValue(value);
        this.remove(key);
        this.inv.put(value, key);
        return this.map.put(key, value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    protected Set<Map.Entry<V, K>> invertedEntrySet() {
        return new InvertedEntrySet();
    }

    @Override
    public void clear() {
        this.map.clear();
        this.inv.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.inv.containsKey(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    public K getKey(V value) {
        return this.inv.get(value);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        V v = this.map.remove(key);
        this.inv.remove(v);
        return v;
    }

    public K removeValue(V value) {
        K k = this.inv.remove(value);
        this.map.remove(k);
        return k;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    private Iterator<Map.Entry<K, V>> entrySetIterator() {
        return new Iterator<Map.Entry<K, V>>(){
            Iterator<Map.Entry<K, V>> it;
            Map.Entry<K, V> current;
            {
                this.it = InjectiveMap.this.map.entrySet().iterator();
                this.current = null;
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                this.current = this.it.next();
                return this.current;
            }

            @Override
            public void remove() {
                if (this.current == null) {
                    throw new IllegalStateException();
                }
                if (InjectiveMap.this.map.containsKey(this.current.getKey())) {
                    InjectiveMap.this.map.remove(this.current.getKey());
                    InjectiveMap.this.inv.remove(this.current.getValue());
                }
                this.current = null;
            }
        };
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Set<V> values() {
        return new ValueSet();
    }

    public InjectiveMap<V, K> invert() {
        return new InjectiveMap<V, K>(){

            @Override
            public void clear() {
                InjectiveMap.this.clear();
            }

            @Override
            public boolean containsKey(Object key) {
                return InjectiveMap.this.containsValue(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return InjectiveMap.this.containsKey(value);
            }

            @Override
            public Set<Map.Entry<V, K>> entrySet() {
                return InjectiveMap.this.invertedEntrySet();
            }

            @Override
            protected Set<Map.Entry<K, V>> invertedEntrySet() {
                return InjectiveMap.this.entrySet();
            }

            @Override
            public K get(Object key) {
                return InjectiveMap.this.getKey(key);
            }

            @Override
            public V getKey(K value) {
                return InjectiveMap.this.get(value);
            }

            @Override
            public InjectiveMap<K, V> invert() {
                return InjectiveMap.this;
            }

            @Override
            public boolean isEmpty() {
                return InjectiveMap.this.isEmpty();
            }

            @Override
            public Set<V> keySet() {
                return InjectiveMap.this.values();
            }

            @Override
            public K put(V key, K value) {
                Object oldKey = InjectiveMap.this.getKey(key);
                InjectiveMap.this.put(value, key);
                return oldKey;
            }

            @Override
            public void putAll(Map<? extends V, ? extends K> m) {
                for (Map.Entry e : m.entrySet()) {
                    InjectiveMap.this.put(e.getValue(), e.getKey());
                }
            }

            @Override
            public K remove(Object key) {
                return InjectiveMap.this.removeValue(key);
            }

            @Override
            public V removeValue(K value) {
                return InjectiveMap.this.remove(value);
            }

            @Override
            public int size() {
                return InjectiveMap.this.size();
            }

            @Override
            public Set<K> values() {
                return InjectiveMap.this.keySet();
            }
        };
    }

    private abstract class BackedSet<T>
    extends AbstractSet<T>
    implements Set<T> {
        private BackedSet() {
        }

        @Override
        public void clear() {
            InjectiveMap.this.clear();
        }

        @Override
        public int size() {
            return InjectiveMap.this.map.size();
        }
    }

    private class EntrySet
    extends BackedSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public boolean contains(Object o) {
            return o instanceof Map.Entry && InjectiveMap.this.map.containsKey(((Map.Entry)o).getKey());
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return InjectiveMap.this.entrySetIterator();
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                if (InjectiveMap.this.map.containsKey(e.getKey()) && InjectiveMap.this.inv.containsKey(e.getValue()) && InjectiveMap.this.map.get(e.getKey()).equals(e.getValue()) && InjectiveMap.this.inv.get(e.getValue()).equals(e.getKey())) {
                    InjectiveMap.this.map.remove(e.getKey());
                    InjectiveMap.this.inv.remove(e.getValue());
                    return true;
                }
            }
            return false;
        }
    }

    private class InvertedEntrySet
    extends BackedSet<Map.Entry<V, K>> {
        private InvertedEntrySet() {
        }

        @Override
        public boolean contains(Object o) {
            return o instanceof Map.Entry && InjectiveMap.this.map.containsKey(((Map.Entry)o).getValue());
        }

        @Override
        public Iterator<Map.Entry<V, K>> iterator() {
            return new Iterator<Map.Entry<V, K>>(){
                Iterator<Map.Entry<K, V>> it;
                {
                    this.it = InjectiveMap.this.entrySetIterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public Map.Entry<V, K> next() {
                    final Map.Entry e = this.it.next();
                    return new Map.Entry<V, K>(){

                        @Override
                        public V getKey() {
                            return e.getValue();
                        }

                        @Override
                        public K getValue() {
                            return e.getKey();
                        }

                        @Override
                        public K setValue(K value) {
                            Object oldValue = e.getKey();
                            InjectiveMap.this.put(value, e.getValue());
                            return oldValue;
                        }
                    };
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                if (InjectiveMap.this.map.containsKey(e.getKey()) && InjectiveMap.this.inv.containsKey(e.getValue()) && InjectiveMap.this.map.get(e.getKey()).equals(e.getValue()) && InjectiveMap.this.inv.get(e.getValue()).equals(e.getKey())) {
                    InjectiveMap.this.map.remove(e.getKey());
                    InjectiveMap.this.inv.remove(e.getValue());
                    return true;
                }
            }
            return false;
        }
    }

    private class KeySet
    extends BackedSet<K> {
        private KeySet() {
        }

        @Override
        public boolean contains(Object o) {
            return InjectiveMap.this.containsKey(o);
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator<K>(){
                Iterator<Map.Entry<K, V>> it;
                {
                    this.it = InjectiveMap.this.entrySetIterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public K next() {
                    return this.it.next().getKey();
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        @Override
        public boolean remove(Object o) {
            if (InjectiveMap.this.containsKey(o)) {
                InjectiveMap.this.remove(o);
                return true;
            }
            return false;
        }
    }

    private class ValueSet
    extends BackedSet<V> {
        private ValueSet() {
        }

        @Override
        public boolean contains(Object o) {
            return InjectiveMap.this.containsValue(o);
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(){
                Iterator<Map.Entry<K, V>> it;
                {
                    this.it = InjectiveMap.this.entrySetIterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public V next() {
                    return this.it.next().getValue();
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        @Override
        public boolean remove(Object o) {
            if (InjectiveMap.this.containsValue(o)) {
                InjectiveMap.this.removeValue(o);
                return true;
            }
            return false;
        }
    }
}

