/*
 * Decompiled with CFR 0.152.
 */
package com.arm.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Semaphore;

public abstract class Generator<T>
implements Iterable<T> {
    private Map<Thread, ArrayBlockingQueue<T>> results = Collections.synchronizedMap(new HashMap());
    private Map<Thread, Semaphore> semaphores = Collections.synchronizedMap(new HashMap());
    private Map<Thread, Exception> exceptions = Collections.synchronizedMap(new HashMap());
    private Set<CancellableIterator<T>> iterators = new HashSet<CancellableIterator<T>>();

    protected void yield(T o) {
        ArrayBlockingQueue<T> r = this.results.get(Thread.currentThread());
        Semaphore s = this.semaphores.get(Thread.currentThread());
        if (r == null || s == null) {
            return;
        }
        try {
            r.put(o);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        s.release();
    }

    protected abstract void generate();

    protected boolean isCancelled() {
        return Thread.currentThread().isInterrupted();
    }

    @Override
    public CancellableIterator<T> iterator() {
        final Semaphore hasNext = new Semaphore(0);
        final Thread producer = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        Generator.this.generate();
                    }
                    catch (Exception e) {
                        Generator.this.exceptions.put(Thread.currentThread(), e);
                        hasNext.release();
                    }
                }
                finally {
                    hasNext.release();
                }
            }
        }, "generator thread");
        this.results.put(producer, new ArrayBlockingQueue(1));
        this.semaphores.put(producer, hasNext);
        producer.start();
        final ArrayBlockingQueue<T> myResults = this.results.get(producer);
        CancellableIterator i = new CancellableIterator<T>(){
            private boolean finished = false;

            @Override
            public boolean hasNext() {
                if (Generator.this.exceptions.containsKey(producer)) {
                    Exception e = (Exception)Generator.this.exceptions.get(producer);
                    this.finish();
                    throw new RuntimeException(e);
                }
                if (this.finished) {
                    return false;
                }
                try {
                    hasNext.acquire();
                    hasNext.release();
                }
                catch (InterruptedException interruptedException) {}
                if (myResults.isEmpty()) {
                    this.finish();
                }
                return !this.finished;
            }

            @Override
            public T next() {
                if (Generator.this.exceptions.containsKey(producer)) {
                    Exception e = (Exception)Generator.this.exceptions.get(producer);
                    this.finish();
                    throw new RuntimeException(e);
                }
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                try {
                    hasNext.acquire();
                    if (myResults.isEmpty()) {
                        this.finish();
                        throw new NoSuchElementException();
                    }
                    return myResults.take();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void finish() {
                if (this.finished) {
                    return;
                }
                this.finished = true;
                Generator.this.results.remove(producer);
                Generator.this.semaphores.remove(producer);
                Generator.this.exceptions.remove(producer);
                producer.interrupt();
                hasNext.release();
                Generator.this.iterators.remove(this);
            }

            @Override
            public void cancel() {
                this.finish();
            }
        };
        this.iterators.add(i);
        return i;
    }

    public void cancelAll() {
        for (CancellableIterator<T> i : this.iterators) {
            i.cancel();
        }
    }

    public static interface CancellableIterator<T>
    extends Iterator<T> {
        public void cancel();
    }
}

