/*
 * Decompiled with CFR 0.152.
 */
package com.arm.system;

import com.arm.nativeutil.AbstractProcessEnvironment;
import com.arm.util.Platform;
import com.arm.util.Tuple;
import com.arm.util.URLResolver;
import com.arm.util.UnsupportedProtocolException;
import com.arm.util.libs.LibLoaderHelper;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class ProcessEnvironment
extends AbstractProcessEnvironment {
    private static ProcessEnvironment INSTANCE;

    private ProcessEnvironment() {
        this.loadNativeLibraries();
    }

    public static synchronized ProcessEnvironment getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ProcessEnvironment();
        }
        return INSTANCE;
    }

    private void loadNativeLibraries() {
        Tuple<String, String> platformId = Platform.getId();
        String path = String.valueOf((String)platformId.ta) + "/" + (String)platformId.tb;
        URL location = AbstractProcessEnvironment.class.getResource(path);
        File dir = this.resolveLocation(location);
        LibLoaderHelper.load("nativeutil", dir);
    }

    private File resolveLocation(URL location) {
        try {
            return URLResolver.resolve(location);
        }
        catch (UnsupportedProtocolException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

