/*
 * Decompiled with CFR 0.152.
 */
package com.arm.shell;

import com.arm.shell.IProcStreamListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class StreamPipe
extends Thread {
    private static AtomicInteger threadId = new AtomicInteger(1);
    private final OutputStream os;
    private final InputStream in;
    private final byte[] buffer = new byte[100];
    private volatile boolean done = false;
    private List<IProcStreamListener> listeners = new ArrayList<IProcStreamListener>();

    public StreamPipe(String name, OutputStream os, InputStream in) {
        super("StreamPipe " + name + " thread " + threadId.getAndIncrement());
        this.os = os;
        this.in = in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StreamPipe streamPipe = this;
        synchronized (streamPipe) {
            this.done = false;
        }
        try {
            int count = -1;
            while (!this.isDone()) {
                count = this.readFromStream();
                if (!this.isDone()) {
                    if (this.listeners != null) {
                        for (IProcStreamListener listener : this.listeners) {
                            listener.inputReceived(new String(this.buffer, 0, count));
                        }
                    }
                    this.os.write(this.buffer, 0, count);
                    this.os.flush();
                }
                Thread.yield();
            }
        }
        catch (IOException iOException) {}
    }

    private int readFromStream() throws IOException {
        int count = this.in.read(this.buffer, 0, this.buffer.length);
        if (count < 0) {
            this.setDone();
        }
        return count;
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    public synchronized void setDone() {
        this.done = true;
        this.notifyAll();
    }

    public void addStreamListener(IProcStreamListener listener) {
        this.listeners.add(listener);
    }

    public void waitFor() throws InterruptedException {
        this.join();
    }
}

