/*
 * Decompiled with CFR 0.152.
 */
package com.arm.prefs;

import com.arm.prefs.CachedPrefsStore;
import com.arm.prefs.PrefsIOException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class ReadOnlyPropertiesPrefsStore
extends CachedPrefsStore {
    private final InputStream input;
    private boolean hasSynced;

    public ReadOnlyPropertiesPrefsStore(InputStream input) {
        this.input = input;
    }

    @Override
    public void put(String nodePath, String key, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(String nodePath, String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(String nodePath) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sync(String nodePath) throws PrefsIOException {
        if (!this.hasSynced) {
            Properties props = new Properties();
            try {
                props.load(this.input);
            }
            catch (IOException ioe) {
                throw new PrefsIOException("failed to read preferences", ioe);
            }
            for (Map.Entry<Object, Object> prop : props.entrySet()) {
                String path;
                String propKey = String.valueOf(prop.getKey());
                String value = String.valueOf(prop.getValue());
                int lastSeparatorPosition = propKey.lastIndexOf(47);
                if (lastSeparatorPosition <= 1 || !(path = propKey.substring(0, lastSeparatorPosition)).startsWith(nodePath)) continue;
                String key = propKey.substring(lastSeparatorPosition + 1);
                this.put(path, key, value, false);
            }
            this.hasSynced = true;
        }
    }
}

